/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.stands;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.messages.MessageUtil;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GSRealTimeConnector
extends BaseSessionBean {
    private static final String OUTPUT_FILE = "fromServer.xml";
    protected String fisHost = "";
    protected static int PORT = 0;
    Socket socket = null;
    PrintWriter printWriter = null;
    protected BufferedReader bufferedReader = null;
    protected boolean connectionEstablished = false;
    protected ConfigurationLocal configurationBean = null;
    protected InformantFacadeLocal informantFacadeLocal = null;
    protected static final Log log = LogFactory.getLog(GSRealTimeConnector.class);

    public GSRealTimeConnector() {
        try {
            this.configurationBean = ConfigurationUtil.getLocalHome().create();
            this.informantFacadeLocal = InformantFacadeUtil.getLocalHome().create();
            this.fisHost = this.configurationBean.getParameter("observable.stands.fis.ip");
        }
        catch (CreateException e1) {
            log.error((Object)"GSRealTimeConnector() runs into CreateException: ", (Throwable)e1);
        }
        catch (NamingException e1) {
            log.error((Object)"GSRealTimeConnector() runs into NamingException: ", (Throwable)e1);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"GSRealTimeConnector() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
    }

    protected void establishSocketConnection() throws UnknownHostException, IOException {
        if (this.connectionEstablished) {
            log.debug((Object)"Closing all connections...");
            this.printWriter.close();
            this.bufferedReader.close();
            this.socket.close();
        }
        try {
            log.debug((Object)"Connecting with GSRealTimeSystem socket...");
            this.socket = new Socket(this.fisHost, PORT);
            this.socket.setSoTimeout(1800000);
            this.printWriter = new PrintWriter(this.socket.getOutputStream(), true);
            this.bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.connectionEstablished = true;
            log.debug((Object)"Connected with GSRealTimeSystem socket!");
        }
        catch (UnknownHostException e) {
            log.error((Object)"ejbCreate() runs into UnknownHostException: ", (Throwable)e);
            this.informantFacadeLocal.notify("run() runs into UnknownHostException: " + e, "StandErrorEvent");
        }
        catch (IOException e) {
            log.error((Object)"ejbCreate() runs into IOException! No connection possible to server!");
            this.informantFacadeLocal.notify("ejbCreate() runs into IOException! No connection possible to server!", "StandErrorEvent");
            log.debug((Object)"Trying to reconnect...");
            this.establishSocketConnection();
        }
    }

    @Deprecated
    protected byte[] getLengthOfText(String file) {
        byte[] length = new byte[]{(byte)((file.length() & 0xFF000000) >> 24), (byte)((file.length() & 0xFF0000) >> 16), (byte)((file.length() & 0xFF00) >> 8), (byte)(file.length() & 0xFF)};
        if (log.isDebugEnabled()) {
            log.debug((Object)("Byte array of sending message is: " + length[0] + "/" + length[1] + "/" + length[2] + "/" + length[3]));
        }
        return length;
    }

    protected String readSocketData(boolean terminateConnection) {
        log.debug((Object)"Incoming socket data reading...");
        String fromServer = "";
        try {
            char[] charBuffer = new char[4];
            this.bufferedReader.read(charBuffer, 0, 4);
            int messageSize = MessageUtil.getSizeOfIncomingMessage((char[])charBuffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Size of reveiving message: " + messageSize));
            }
            if (messageSize == 0) {
                log.error((Object)"Message size was null! Establishing new connection!");
                this.establishSocketConnection();
                return this.readSocketData(terminateConnection);
            }
            while (fromServer.indexOf("</MbOs>") == -1) {
                fromServer = fromServer + this.bufferedReader.readLine() + "\n";
            }
            this.writeToFile(fromServer);
            if (terminateConnection) {
                this.bufferedReader.close();
                this.printWriter.close();
                this.connectionEstablished = false;
            }
        }
        catch (IOException e) {
            log.error((Object)"readSocketData() runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("ejbCreate() runs into IOException! " + e, "StandErrorEvent");
        }
        log.debug((Object)"All incoming socket data read!");
        return fromServer;
    }

    protected String readEvent() {
        log.debug((Object)"Wating for next event...");
        String fromServer = "";
        try {
            char[] charBuffer = new char[4];
            this.bufferedReader.read(charBuffer, 0, 4);
            int messageSize = MessageUtil.getSizeOfIncomingMessage((char[])charBuffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Size of reveiving message: " + messageSize));
            }
            if (messageSize == 0) {
                log.error((Object)"Message size was null! Establishing new connection!");
                this.informantFacadeLocal.notify("Message size was null! Establishing new connection!", "StandErrorEvent");
                this.establishSocketConnection();
                return this.readEvent();
            }
            while (fromServer.indexOf("</MbOs>") == -1) {
                fromServer = fromServer + this.bufferedReader.readLine() + "\n";
            }
            log.debug((Object)fromServer);
        }
        catch (IOException e) {
            log.error((Object)"readEvent() runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("readEvent() runs into IOException: " + e, "StandErrorEvent");
            try {
                log.debug((Object)"Establishing new connection and retrying to get next event!");
                this.establishSocketConnection();
                return this.readEvent();
            }
            catch (UnknownHostException e1) {
                log.error((Object)"readEvent() runs into UnknownHostException: ", (Throwable)e);
                this.informantFacadeLocal.notify("readEvent() runs into IOException: " + e, "StandErrorEvent");
            }
            catch (IOException e1) {
                log.error((Object)"readEvent() runs into IOException: ", (Throwable)e);
                this.informantFacadeLocal.notify("readEvent() runs into IOException: " + e, "StandErrorEvent");
            }
            return this.readEvent();
        }
        log.debug((Object)"Incoming event read!");
        return fromServer;
    }

    private void writeToFile(String file) {
        try {
            FileWriter fileWriter = new FileWriter(new File(OUTPUT_FILE));
            fileWriter.write(file);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            log.error((Object)"writeToFile() runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("writeToFile() runs into IOException: " + e, "StandErrorEvent");
        }
    }

    @Deprecated
    protected int getSizeOfIncomingMessage(char[] message) {
        String strMessage = "";
        for (char element : message) {
            strMessage = strMessage + element;
        }
        byte[] byteMessage = strMessage.getBytes();
        int size = 0;
        size |= byteMessage[3] & 0xFF;
        size |= (byteMessage[2] & 0xFF) << 8;
        size |= (byteMessage[1] & 0xFF) << 16;
        return size |= (byteMessage[0] & 0xFF) << 24;
    }

    protected boolean writeSocketData(String transferData) {
        log.debug((Object)"Writing socket data...");
        boolean isErrorOccurred = false;
        try {
            this.printWriter.print(transferData);
            this.printWriter.flush();
            isErrorOccurred = this.printWriter.checkError();
        }
        catch (Exception e) {
            log.error((Object)"writeSocketData(final String transferData) runs into Exception: ", (Throwable)e);
            this.informantFacadeLocal.notify("writeSocketData(final String transferData) runs into Exception: " + e, "StandErrorEvent");
            isErrorOccurred = true;
        }
        if (!isErrorOccurred) {
            log.debug((Object)"Socket data written!");
        } else {
            log.error((Object)"writeSocketData(final String transferData): Socket data NOT written! An error occurred!");
            this.informantFacadeLocal.notify("writeSocketData(final String transferData) Socket data NOT written! An error occurred!", "StandErrorEvent");
        }
        return isErrorOccurred;
    }

    protected boolean writeSocketData(byte[] transferData) {
        log.debug((Object)"Writing socket data...");
        try {
            this.socket.getOutputStream().write(transferData);
            this.socket.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error((Object)"writeSocketData (final byte[] transferData) runs into IOException!");
            this.informantFacadeLocal.notify("writeSocketData (final byte[] transferData) runs into IOException!", "StandErrorEvent");
            return true;
        }
        log.debug((Object)"Socket header written!");
        return false;
    }

    protected void sendACK() {
        this.writeSocketData(MessageUtil.getLengthOfMessage((String)"ACK"));
        if (this.writeSocketData("ACK")) {
            try {
                log.error((Object)"Error while sendin ACK! Creating new connection!");
                this.informantFacadeLocal.notify("Error while sendin ACK! Creating new connection!", "StandErrorEvent");
                this.establishSocketConnection();
            }
            catch (UnknownHostException e) {
                log.error((Object)"sendACK() runs into UnknownHostException: ", (Throwable)e);
                this.informantFacadeLocal.notify("sendACK() runs into UnknownHostException: " + e, "StandErrorEvent");
            }
            catch (IOException e) {
                log.error((Object)"sendACK() runs into IOException: ", (Throwable)e);
                this.informantFacadeLocal.notify("sendACK() runs into IOException: " + e, "StandErrorEvent");
            }
        } else {
            log.debug((Object)"ACK sent");
        }
    }
}

