/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.scanmanmsg;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.helper.BaseHelperUtil;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCachePK;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryHelperUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgWriteException;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeUtil;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserUtil;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ScanmanMsgFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final transient Log log = LogFactory.getLog(ScanmanMsgFacadeBean.class);
    private ScanmanMsgHistoryLocalHome scanmanMsgHistoryHome;
    private ScanmanMsgCacheLocalHome scanmanMsgCacheHome;
    private InfomanSetupFacadeLocal infomanSetupFacade;
    private GrouphistoryLocalHome grouphistoryHome;
    private UnitUserLocal unitUser;
    private GeofencingUpdateFacadeLocal geofUpdateFacade;
    private static final int DEFAULT_MAX_MESSAGE_LENGTH = 254;
    private int maxMessageLength = 254;

    public void ejbCreate() throws CreateException {
        try {
            this.scanmanMsgHistoryHome = ScanmanMsgHistoryUtil.getLocalHome();
            this.scanmanMsgCacheHome = ScanmanMsgCacheUtil.getLocalHome();
            this.infomanSetupFacade = InfomanSetupFacadeUtil.getLocalHome().create();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
            this.unitUser = UnitUserUtil.getLocalHome().create();
            this.geofUpdateFacade = GeofencingUpdateFacadeUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            throw new EJBException((Exception)ex);
        }
        try {
            InitialContext ctx = new InitialContext();
            this.maxMessageLength = (Integer)ctx.lookup("java:comp/env/maxMessageLength");
        }
        catch (Exception ex) {
            log.warn((Object)"ejbCreate() runs during lookup env entries into", (Throwable)ex);
        }
    }

    public void resetUnit(long unitId) {
        try {
            Collection cacheEntries = this.scanmanMsgCacheHome.findByUnit(unitId);
            for (ScanmanMsgCacheLocal cacheEntry : cacheEntries) {
                cacheEntry.remove();
            }
            Collection historyEntries = this.scanmanMsgHistoryHome.findByUnitId(unitId);
            for (ScanmanMsgHistoryLocal historyEntry : historyEntries) {
                historyEntry.remove();
            }
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void event(ScanmanMsgHistoryValue event) throws ImplicitRollbackException {
        String originalMessage = null;
        boolean newStyleBootMessage = false;
        if (event.getType() == 25 && event.getMsgToString().contains("=")) {
            originalMessage = event.getMsgToString();
            newStyleBootMessage = true;
            event.setMsgToString(this.infomanSetupFacade.getOldStyleBootMessage(event.getMsgToString()));
        } else if (event.getType() == 30) {
            originalMessage = event.getMsgToString();
        }
        if (event.getMsgToString().length() > this.maxMessageLength) {
            String oldMsg = event.getMsgToString();
            event.setMsgToString(oldMsg.substring(0, this.maxMessageLength));
            if (log.isWarnEnabled()) {
                log.warn((Object)("event() msg exceeded maximumlenth of " + this.maxMessageLength + " cutted off. orignal: " + oldMsg + " cutted to: " + event.getMsgToString()));
            }
        }
        ScanmanMsgCachePK cachePK = new ScanmanMsgCachePK(event.getUnitId(), event.getType());
        try {
            try {
                ScanmanMsgCacheLocal cache = this.scanmanMsgCacheHome.findByPrimaryKey(cachePK);
                ScanmanMsgCacheValue value = cache.getScanmanMsgCacheValue();
                ScanmanMsgCacheValue eventValue = this.getCacheValueFromHistory(event);
                if (value.equals(eventValue)) {
                    log.debug((Object)"double trasmitted event, discard it");
                    return;
                }
                this.writeHistory(this.getHistoryValueFromCache(value));
                cache.setScanmanMsgCacheValue(eventValue);
                cache.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(event.getUnitId(), event.getCreateTime()));
            }
            catch (FinderException ex) {
                ScanmanMsgCacheValue value = new ScanmanMsgCacheValue();
                value.setUnitId(event.getUnitId());
                value.setType(event.getType());
                value.setCreateTime(event.getCreateTime());
                value.setMessage(event.getMsgToString());
                this.scanmanMsgCacheHome.create(value);
            }
            switch (event.getType()) {
                case 25: {
                    if (!newStyleBootMessage) break;
                    event.setMsgToString(originalMessage);
                    this.infomanSetupFacade.infomanBoot(event);
                    break;
                }
                case 30: {
                    event.setMsgToString(originalMessage);
                    this.infomanSetupFacade.updateConfiguration(event);
                    break;
                }
                case 31: {
                    this.infomanSetupFacade.updateReport(event.getCreateTime(), event.getMsgToString());
                    break;
                }
                case 32: {
                    this.unitUser.updateReport(event.getUnitId(), event.getCreateTime(), event.getMsgToString());
                    break;
                }
                case 33: {
                    this.geofUpdateFacade.updateGeofReport(event.getUnitId(), event.getCreateTime(), event.getMsgToString());
                }
            }
        }
        catch (ScanmanMsgWriteException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
        catch (CreateException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    protected void writeHistory(ScanmanMsgHistoryValue event) throws ScanmanMsgWriteException {
        try {
            try {
                ScanmanMsgHistoryLocal history = this.scanmanMsgHistoryHome.create(event);
                history.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(event.getUnitId(), event.getCreateTime()));
                long daystamp = BaseHelperUtil.roundToDaystamp((long)event.getCreateTime());
                long groupHistoryId = 0L;
                GrouphistoryLocal grouphistoryLocal = history.getGroupHistoryId();
                if (grouphistoryLocal != null) {
                    groupHistoryId = grouphistoryLocal.getGroupHistoryId();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating helper: (" + history.getScanmanMsgHistoryValue().getScanmanMsgHistoryId() + ", " + daystamp + ", " + event.getUnitId() + ", " + groupHistoryId + ");"));
                }
                ScanmanMsgHistoryHelperUtil.getLocalHome().create(history.getScanmanMsgHistoryValue().getScanmanMsgHistoryId(), daystamp, event.getUnitId(), groupHistoryId);
            }
            catch (DuplicateKeyException ex) {
                this.scanmanMsgHistoryHome.reorganizeSequence();
                ScanmanMsgHistoryLocal history = this.scanmanMsgHistoryHome.create(event);
                history.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(event.getUnitId(), event.getCreateTime()));
                long daystamp = BaseHelperUtil.roundToDaystamp((long)event.getCreateTime());
                long groupHistoryId = 0L;
                GrouphistoryLocal grouphistoryLocal = history.getGroupHistoryId();
                if (grouphistoryLocal != null) {
                    groupHistoryId = grouphistoryLocal.getGroupHistoryId();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating helper: (" + history.getScanmanMsgHistoryValue().getScanmanMsgHistoryId() + ", " + daystamp + ", " + event.getUnitId() + ", " + groupHistoryId + ");"));
                }
                ScanmanMsgHistoryHelperUtil.getLocalHome().create(history.getScanmanMsgHistoryValue().getScanmanMsgHistoryId(), daystamp, event.getUnitId(), groupHistoryId);
            }
        }
        catch (Exception ex) {
            log.error((Object)"event() runs during writeHistory() into", (Throwable)ex);
            throw new ScanmanMsgWriteException(ex);
        }
    }

    public List getMessages(long unitId, long since, long until) {
        try {
            List result = this.getHistoryValueObjectsFromCache(this.scanmanMsgCacheHome.findByUnitTime(unitId, since, until));
            result.addAll(this.getValueObjects(this.scanmanMsgHistoryHome.findByUnit(unitId, since, until)));
            return result;
        }
        catch (Exception ex) {
            log.error((Object)"getMessages() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public List getMessages(int type, long since, long until) {
        try {
            List result = this.getHistoryValueObjectsFromCache(this.scanmanMsgCacheHome.findByTypeTime(type, since, until));
            result.addAll(this.getValueObjects(this.scanmanMsgHistoryHome.findByType(type, since, until)));
            return result;
        }
        catch (Exception ex) {
            log.error((Object)"getMessages() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public List getMessages(int type, long unitId, long since, long until) {
        try {
            List result = this.getHistoryValueObjectsFromCache(this.scanmanMsgCacheHome.findByUnitTypeTime(type, unitId, since, until));
            result.addAll(this.getValueObjects(this.scanmanMsgHistoryHome.findByTypeAndUnit(type, unitId, since, until)));
            return result;
        }
        catch (Exception ex) {
            log.error((Object)"getMessages() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public ScanmanMsgHistoryValue getLastMessage(int type, long unitId) {
        ScanmanMsgCachePK cachePK = new ScanmanMsgCachePK(unitId, type);
        try {
            ScanmanMsgCacheLocal cache = this.scanmanMsgCacheHome.findByPrimaryKey(cachePK);
            ScanmanMsgCacheValue cacheValue = cache.getScanmanMsgCacheValue();
            return this.getHistoryValueFromCache(cacheValue);
        }
        catch (FinderException ex) {
            return null;
        }
    }

    protected ScanmanMsgCacheValue getCacheValueFromHistory(ScanmanMsgHistoryValue history) {
        ScanmanMsgCacheValue cache = new ScanmanMsgCacheValue();
        cache.setUnitId(history.getUnitId());
        cache.setType(history.getType());
        cache.setCreateTime(history.getCreateTime());
        cache.setMessage(history.getMsgToString());
        return cache;
    }

    protected ScanmanMsgHistoryValue getHistoryValueFromCache(ScanmanMsgCacheValue cache) {
        ScanmanMsgHistoryValue history = new ScanmanMsgHistoryValue();
        history.setUnitId(cache.getUnitId());
        history.setType(cache.getType());
        history.setCreateTime(cache.getCreateTime());
        history.setMsgToString(cache.getMessage());
        return history;
    }

    protected List getHistoryValueObjectsFromCache(Collection entities) {
        ArrayList<ScanmanMsgHistoryValue> valueObjects = new ArrayList<ScanmanMsgHistoryValue>(entities.size());
        for (ScanmanMsgCacheLocal msgEntity : entities) {
            valueObjects.add(this.getHistoryValueFromCache(msgEntity.getScanmanMsgCacheValue()));
        }
        return valueObjects;
    }

    protected List getValueObjects(Collection entities) throws RemoteException {
        ArrayList<ScanmanMsgHistoryValue> valueObjects = new ArrayList<ScanmanMsgHistoryValue>(entities.size());
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            ScanmanMsgHistory msgEntity = (ScanmanMsgHistory)PortableRemoteObject.narrow(it.next(), ScanmanMsgHistory.class);
            valueObjects.add(msgEntity.getScanmanMsgHistoryValue());
        }
        return valueObjects;
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        Collection coll = null;
        try {
            coll = this.scanmanMsgCacheHome.findByUnit(unitModel.getUnitId());
        }
        catch (FinderException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        List result = this.getHistoryValueObjectsFromCache(coll);
        for (int i = 0; i < result.size(); ++i) {
            ScanmanMsgHistoryValue hisValue = (ScanmanMsgHistoryValue)result.get(i);
            if (hisValue == null) continue;
            try {
                this.writeHistory(hisValue);
                continue;
            }
            catch (ScanmanMsgWriteException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        for (Object obj : coll) {
            ScanmanMsgCacheLocal cacheLocal = (ScanmanMsgCacheLocal)obj;
            if (cacheLocal == null) continue;
            try {
                cacheLocal.remove();
            }
            catch (EJBException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (RemoveException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return true;
    }
}

