/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.rfid.persistence;

import de.proveo.util.geo.GPSPosition;
import java.text.MessageFormat;
import java.text.ParseException;

public abstract class AbstractTagPositionMappingValue {
    private static final MessageFormat rfidTagIdpattern = new MessageFormat("{0,number,#0,000,000,000}");

    public abstract long getTagId();

    public String getTagIdAsString() {
        return AbstractTagPositionMappingValue.formatTagId(this.getTagId());
    }

    public static String formatTagId(long rfidTagId) {
        return rfidTagIdpattern.format(new Object[]{rfidTagId});
    }

    public static long parseTagId(String rfidTagId) throws ParseException {
        return (Long)rfidTagIdpattern.parse(rfidTagId)[0];
    }

    public abstract int getLongMSEC();

    public abstract int getLatMSEC();

    public String getLatitudeAsString() {
        return GPSPosition.formatLatitude((int)this.getLatMSEC());
    }

    public String getLongitudeAsString() {
        return GPSPosition.formatLongitude((int)this.getLongMSEC());
    }
}

