/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.rfid;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.rfid.RFIDValue;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.rfid.persistence.AbstractTagPositionMappingValue;
import de.proveo.wwt.logic.ejb.dataIn.rfid.persistence.TagPositionMappingLocal;
import de.proveo.wwt.logic.ejb.dataIn.rfid.persistence.TagPositionMappingLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.rfid.persistence.TagPositionMappingPK;
import de.proveo.wwt.logic.ejb.dataIn.rfid.persistence.TagPositionMappingUtil;
import de.proveo.wwt.logic.ejb.dataIn.rfid.persistence.TagPositionMappingValue;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagEventFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(TagEventFacadeBean.class);
    private TagPositionMappingLocalHome mappingHome;
    private EventFacadeLocal eventFacadeLocal;

    public void ejbCreate() {
        try {
            this.mappingHome = TagPositionMappingUtil.getLocalHome();
            this.eventFacadeLocal = EventFacadeUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"ejbCreate() runs into", (Throwable)ex);
            throw new EJBException("ejb reference problem", ex);
        }
    }

    public void handleEvent(RFIDValue event) {
        this.createPositionEvent(event);
    }

    public void createPositionEvent(RFIDValue event) {
        try {
            TagPositionMappingLocal tagPositionMapping = this.getTagPosition(event.getRfidTag());
            GeoStruct geoEvent = new GeoStruct(event.getUnitID(), event.getTimeStamp(), System.currentTimeMillis(), tagPositionMapping.getLatMSEC(), tagPositionMapping.getLongMSEC(), true, AbstractTagPositionMappingValue.formatTagId(event.getRfidTag()));
            this.eventFacadeLocal.generateGeoEvent(geoEvent);
        }
        catch (ObjectNotFoundException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("createPositionEvent() no position mapping defined for " + event));
            }
        }
        catch (FinderException ex) {
            log.error((Object)"createPositionEvent() runs into", (Throwable)ex);
            throw new EJBException("finder problem", (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"createPositionEvent() runs into", (Throwable)ex);
        }
    }

    private TagPositionMappingLocal getTagPosition(long rfidTagId) throws FinderException {
        TagPositionMappingPK pk = new TagPositionMappingPK(rfidTagId);
        return this.mappingHome.findByPrimaryKey(pk);
    }

    public void addTagPositionMapping(TagPositionMappingValue mapping) throws CreateException {
        this.mappingHome.create(mapping);
    }

    public void removeTagPositionMapping(long rfidTagId) throws FinderException, RemoveException {
        TagPositionMappingPK pk = new TagPositionMappingPK(rfidTagId);
        this.mappingHome.findByPrimaryKey(pk).remove();
    }

    public TagPositionMappingValue getTagPositionMapping(long rfidTagId) throws FinderException {
        TagPositionMappingPK pk = new TagPositionMappingPK(rfidTagId);
        return this.mappingHome.findByPrimaryKey(pk).getTagPositionMappingValue();
    }

    public void saveTagPositionMapping(TagPositionMappingValue value) throws FinderException {
        TagPositionMappingPK pk = new TagPositionMappingPK(value.getTagId());
        this.mappingHome.findByPrimaryKey(pk).setTagPositionMappingValue(value);
    }

    public Collection<TagPositionMappingValue> getTagPositionMappings() throws FinderException {
        Collection mappings = this.mappingHome.findAll();
        ArrayList<TagPositionMappingValue> values = new ArrayList<TagPositionMappingValue>(mappings.size());
        for (TagPositionMappingLocal mapping : mappings) {
            values.add(mapping.getTagPositionMappingValue());
        }
        return values;
    }
}

