/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.notify;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.helper.BaseHelperUtil;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.notify.event.NotifyEvent;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCachePK;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.exception.NotifyWriteException;
import de.proveo.wwt.logic.ejb.dataIn.notify.helper.NotifyHistoryHelperUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationLocalHome;
import de.proveo.wwt.logic.ejb.general.notification.NotificationPK;
import de.proveo.wwt.logic.ejb.general.notification.NotificationUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotifyFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(NotifyFacadeBean.class);
    private CurrentNotifyCacheLocalHome cacheHome;
    private NotifyHistoryLocalHome historyHome;
    private NotificationAdministrationFacadeLocal notificationFacade;
    private GrouphistoryLocalHome grouphistoryHome;
    private UseUserLocalHome useUserHome;
    private AreaLocalHome areaHome;
    private NotificationLocalHome notificationLocalHome;

    public void ejbCreate() throws CreateException {
        try {
            this.cacheHome = CurrentNotifyCacheUtil.getLocalHome();
            this.historyHome = NotifyHistoryUtil.getLocalHome();
            this.notificationFacade = NotificationAdministrationFacadeUtil.getLocalHome().create();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
            this.notificationLocalHome = NotificationUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup other beans into", (Throwable)ex);
            throw new CreateException("can't find Entity Beans: " + ex.getMessage());
        }
    }

    public SerializableEventWrapper event(Properties event, long unitId, int areaId) throws ImplicitRollbackException {
        CurrentNotifyCacheValue notifyCacheValue = new CurrentNotifyCacheValue();
        notifyCacheValue.setMessageId(Long.parseLong(event.getProperty("nm")));
        notifyCacheValue.setEntry(Integer.parseInt(event.getProperty("ne")) == 1);
        notifyCacheValue.setCreateTime(Long.parseLong(event.getProperty("t")));
        notifyCacheValue.setReceiveTime(System.currentTimeMillis());
        notifyCacheValue.setUnitId(unitId);
        String userKey = event.getProperty("nuu");
        if (userKey != null) {
            notifyCacheValue.setRemark(userKey);
        }
        if ((areaId = Integer.parseInt(event.getProperty("areaId", Integer.toString(areaId)))) == 0 && event.getProperty("area") != null) {
            try {
                areaId = this.areaHome.guessAreaIdByAreaName(event.getProperty("area"));
            }
            catch (ObjectNotFoundException ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("area: '" + event.getProperty("area") + "' not found"));
                }
            }
            catch (FinderException ex) {
                log.error((Object)"runs during guess area into", (Throwable)ex);
            }
        }
        AreaLocal areaLocal = null;
        if (areaId != 0) {
            try {
                areaLocal = this.areaHome.findByPrimaryKey(new AreaPK(areaId));
            }
            catch (ObjectNotFoundException ex) {
                notifyCacheValue.setRemark(Integer.toString(areaId));
            }
            catch (FinderException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }
        CurrentNotifyCacheLocal cache = null;
        SerializableEventWrapper wrapper = null;
        try {
            cache = this.writeCache(notifyCacheValue, userKey);
            if (cache != null) {
                cache.setArea(areaLocal);
                NotifyHistoryValue historyValue = this.writeHistory(notifyCacheValue, cache);
                cache.setHistoryId(historyValue.getId());
                long messageId = notifyCacheValue.getMessageId();
                String message = "";
                NotificationValue value = this.notificationFacade.getNotificationById((int)messageId);
                if (value != null) {
                    message = value.getDefaultName();
                }
                NotifyEvent notifyEvent = new NotifyEvent(notifyCacheValue.getUnitId(), notifyCacheValue.getMessageId(), message, notifyCacheValue.getEntry(), notifyCacheValue.getCreateTime(), notifyCacheValue.getReceiveTime());
                wrapper = new SerializableEventWrapper((Serializable)notifyEvent, (Serializable)historyValue);
                wrapper.set_notifyHistoryId(historyValue.getId());
                wrapper.set_typeOfEvent("InfomanNotifyMessages");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("event() duplicate transmission: " + event));
            }
            return wrapper;
        }
        catch (NotifyWriteException e) {
            throw new ImplicitRollbackException(e.toString());
        }
    }

    public NotifyHistoryValue writeHistory(CurrentNotifyCacheValue event, CurrentNotifyCacheLocal cache) throws NotifyWriteException {
        NotifyHistoryValue struct = new NotifyHistoryValue();
        struct.setUnitId(event.getUnitId());
        struct.setMessageId(event.getMessageId());
        struct.setCreateTime(event.getCreateTime());
        struct.setEntry(event.getEntry());
        struct.setReceiveTime(event.getReceiveTime());
        struct.setRemark(event.getRemark());
        try {
            NotifyHistoryLocal history;
            try {
                history = this.historyHome.create(struct);
            }
            catch (DuplicateKeyException ex) {
                log.debug((Object)"writeHistory() duplicate key");
                this.historyHome.reorganizeSequence();
                history = this.historyHome.create(struct);
                log.debug((Object)"writeHistory() succesful after sequence fixed");
            }
            history.setGroupHistoryId(cache.getGroupHistoryId());
            history.setUseUser(cache.getUseUser());
            history.setArea(cache.getArea());
            long daystamp = BaseHelperUtil.roundToDaystamp((long)struct.getCreateTime());
            long groupHistoryId = 0L;
            GrouphistoryLocal grouphistoryLocal = history.getGroupHistoryId();
            if (grouphistoryLocal != null) {
                groupHistoryId = grouphistoryLocal.getGroupHistoryId();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating helper: (" + history.getNotifyHistoryValue().getId() + ", " + daystamp + ", " + struct.getUnitId() + ", " + groupHistoryId + ");"));
            }
            NotifyHistoryHelperUtil.getLocalHome().create(history.getNotifyHistoryValue().getId(), daystamp, struct.getUnitId(), groupHistoryId);
            return history.getNotifyHistoryValue();
        }
        catch (Exception ex) {
            String msg = "writeHistory() runs druing create into " + ex.toString();
            log.error((Object)msg);
            throw new NotifyWriteException(msg);
        }
    }

    protected CurrentNotifyCacheLocal writeCache(CurrentNotifyCacheValue event, String userKey) throws NotifyWriteException {
        CurrentNotifyCachePK pk = new CurrentNotifyCachePK(event.getUnitId(), event.getMessageId());
        CurrentNotifyCacheLocal cache = null;
        UseUserLocal useUser = null;
        if (userKey != null) {
            try {
                Collection users = this.useUserHome.findByKey(userKey);
                if (users.size() > 0) {
                    useUser = (UseUserLocal)users.iterator().next();
                } else {
                    event.setRemark(userKey);
                }
            }
            catch (FinderException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }
        try {
            cache = this.cacheHome.findByPrimaryKey(pk);
            if (event.getCreateTime() <= cache.getCreateTime()) {
                return null;
            }
            if (cache.change(event)) {
                cache.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(event.getUnitId(), event.getCreateTime()));
                cache.setUseUser(useUser);
                return cache;
            }
            return null;
        }
        catch (FinderException findEx) {
            try {
                cache = this.cacheHome.create(event);
                cache.setGroupHistoryId(this.grouphistoryHome.getGrouphistoryForUnit(event.getUnitId(), event.getCreateTime()));
                cache.setUseUser(useUser);
                return cache;
            }
            catch (Exception ex) {
                String msg = "writeCache() runs during create into" + ex.toString();
                log.error((Object)msg, (Throwable)ex);
                throw new NotifyWriteException(msg);
            }
        }
    }

    public Collection getNotifiesFromHistory(long unitId, long startTime, long endTime) {
        try {
            return this.historyHome.findByUnitId(unitId, startTime, endTime);
        }
        catch (Exception ex) {
            log.error((Object)("getNotifiesFromHistory() runs during looking for unitId=" + unitId + ".and startTime=" + startTime + ".and endTime" + endTime + " into"), (Throwable)ex);
            throw new EJBException("getNotifiesFromHistory() runs during looking for unitId=" + unitId + ".and startTime=" + startTime + ".and endTime" + endTime + " into " + ex.getMessage());
        }
    }

    public NotifyHistoryValue getNotifyHistoryValue(long historyId) {
        try {
            NotifyHistoryLocal notifyHistoryLocal = this.historyHome.findByPrimaryKey(new NotifyHistoryPK(historyId));
            return notifyHistoryLocal.getNotifyHistoryValue();
        }
        catch (FinderException e) {
            return null;
        }
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        Collection currentNotifyCaches = unitModel.getCurrentNotifyCaches();
        CurrentNotifyCacheLocal[] currArr = currentNotifyCaches.toArray(new CurrentNotifyCacheLocal[currentNotifyCaches.size()]);
        for (int k = 0; k != currArr.length; ++k) {
            CurrentNotifyCacheLocal currentNotifyLocal = currArr[k];
            try {
                if (currentNotifyLocal == null) continue;
                currentNotifyLocal.remove();
                continue;
            }
            catch (EJBException e) {
                log.error((Object)"runs into", (Throwable)e);
                continue;
            }
            catch (RemoveException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return true;
    }

    public ArrayList<CurrentNotifyCacheValue> getAllUnitEventsFromCacheSortedByHistoryId() {
        ArrayList<CurrentNotifyCacheValue> values = new ArrayList<CurrentNotifyCacheValue>();
        try {
            Collection col = this.cacheHome.findAllSortedByHistoryId();
            for (CurrentNotifyCacheLocal cache : col) {
                try {
                    CurrentNotifyCacheValue value = cache.getCurrentNotifyCacheValue();
                    values.add(value);
                }
                catch (NullPointerException e) {
                    log.error((Object)"getCurrentNotifyCacheValue() runs into ", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return values;
    }

    public String getNotificationTextById(long id) {
        NotificationValue value = null;
        try {
            value = this.notificationLocalHome.findByPrimaryKey(new NotificationPK(id)).getNotificationValue();
            return value.getDefaultName();
        }
        catch (FinderException e) {
            log.error((Object)("no notify message found for notifyMessageID: " + id));
            return null;
        }
    }
}

