/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.informant;

import de.proveo.util.connection.ServletConnection;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import java.io.Serializable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InformantFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(InformantFacadeBean.class);
    private final String INFORMANT_TYPE_LOCAL = "local";
    private final String INFORMANT_TYPE_DISTRIBUTED = "distributed";
    private ConfigurationLocal _configurationBean;
    private ObservableFacadeLocal _observer;
    private String host = "localhost";
    private int port = 8080;
    private String type = "local";
    private boolean proxyUse = false;
    private String proxyHost = "";
    private int proxyPort = 0;
    private String proxyUser = "";
    private String proxyPass = "";
    private String proxyDomain = "";
    private ServletConnection _servletConnection = null;
    private static long lastPkGdataHistory = 0L;

    public void ejbCreate() throws CreateException {
        try {
            this._observer = ObservableFacadeUtil.getLocalHome().create();
            this._configurationBean = ConfigurationUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            log.error((Object)"Runs during ejb lookup into", (Throwable)ex);
            throw new EJBException("Runs during ejb lookup into", (Exception)ex);
        }
        this.getConfiguration();
    }

    public void notify(SerializableEventWrapper wrapper, String kindOfEvent) {
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
            long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
            if (pkGdataHistoryPre < lastPkGdataHistory) {
                log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
            }
            lastPkGdataHistory = pkGdataHistoryPre;
        }
        if (this.type.equals("local")) {
            log.debug((Object)"Local notification selected!");
            this._observer.notifyClients(wrapper, kindOfEvent);
        } else if (this.type.equals("distributed")) {
            log.error((Object)"Selected notification not full implemented!");
        } else {
            log.error((Object)("Selected notification of type '" + this.type + "'not implemented!"));
        }
    }

    public void notify(String message, String kindOfEvent) {
        SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)message));
        wrapper.set_typeOfEvent(kindOfEvent);
        long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
        if (pkGdataHistoryPre < lastPkGdataHistory) {
            log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
        }
        lastPkGdataHistory = pkGdataHistoryPre;
        if (this.type.equals("local")) {
            log.debug((Object)"Local notification selected!");
            this._observer.notifyClients(wrapper, kindOfEvent);
        } else if (this.type.equals("distributed")) {
            log.error((Object)"Selected notification not full implemented!");
        } else {
            log.error((Object)("Selected notification of type '" + this.type + "'not implemented!"));
        }
    }

    private void getConfiguration() {
        try {
            this.type = this._configurationBean.getParameter("observable.informant.type");
            if (this.type.equals("distributed")) {
                log.debug((Object)"Distributed notification selected!");
                this.host = this._configurationBean.getParameter("observable.informant.host");
                this.port = Integer.parseInt(this._configurationBean.getParameter("observable.informant.port"));
                this._servletConnection = new ServletConnection(this.host, this.port, "http");
                this.proxyUse = Boolean.parseBoolean(this._configurationBean.getParameter("observable.informant.proxy"));
                if (this.proxyUse) {
                    this.proxyHost = this._configurationBean.getParameter("observable.informant.proxy.host");
                    this.proxyPort = Integer.parseInt(this._configurationBean.getParameter("observable.informant.proxy.port"));
                    this.proxyUser = this._configurationBean.getParameter("observable.informant.proxy.user");
                    this.proxyPass = this._configurationBean.getParameter("observable.informant.proxy.pass");
                    this.proxyDomain = this._configurationBean.getParameter("observable.informant.proxy.domain");
                    this._servletConnection.setupProxy(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPass, this.proxyDomain);
                }
                this._servletConnection.connect();
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"getConfiguration runs into NumberFormatException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"getConfiguration runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
    }
}

