/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.fisFlight;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Timestamp {
    private static final Log log = LogFactory.getLog(Timestamp.class);
    private long unixTimestamp;

    public Timestamp() {
        TimeZone timezone = TimeZone.getDefault();
        if (log.isDebugEnabled()) {
            log.debug((Object)("timezone: " + timezone.getDisplayName() + " DST: " + timezone.useDaylightTime()));
        }
        this.unixTimestamp = System.currentTimeMillis();
    }

    public Timestamp(String ufisTimestamp) {
        this.unixTimestamp = this.parseUfisTimestamp(ufisTimestamp);
    }

    public Timestamp(long unixTimestamp) {
        this.unixTimestamp = unixTimestamp;
    }

    private long parseUfisTimestamp(String ufisTimestamp) {
        if (ufisTimestamp.trim().length() == 0) {
            return 0L;
        }
        if (ufisTimestamp.trim().length() < 14) {
            log.error((Object)(ufisTimestamp + " is no valid timestamp (too short)"));
            return 0L;
        }
        if (ufisTimestamp.length() == 14) {
            ufisTimestamp = ufisTimestamp + "000";
        }
        log.debug((Object)("ufisTimestamp: " + ufisTimestamp));
        try {
            int year = Integer.parseInt(ufisTimestamp.substring(0, 4));
            int month = Integer.parseInt(ufisTimestamp.substring(4, 6)) - 1;
            int day = Integer.parseInt(ufisTimestamp.substring(6, 8));
            int h = Integer.parseInt(ufisTimestamp.substring(8, 10));
            int min = Integer.parseInt(ufisTimestamp.substring(10, 12));
            int sec = Integer.parseInt(ufisTimestamp.substring(12, 14));
            int msec = Integer.parseInt(ufisTimestamp.substring(14, 17));
            if (log.isDebugEnabled()) {
                log.debug((Object)("year: " + year));
                log.debug((Object)("month: " + (month + 1)));
                log.debug((Object)("day: " + day));
                log.debug((Object)("h: " + h));
                log.debug((Object)("min: " + min));
                log.debug((Object)("sec: " + sec));
                log.debug((Object)("msec: " + msec));
            }
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            cal.set(11, h);
            cal.set(12, min);
            cal.set(13, sec);
            cal.set(14, msec);
            log.debug((Object)("unixTimestamp: " + cal.getTimeInMillis()));
            return cal.getTimeInMillis();
        }
        catch (IndexOutOfBoundsException e) {
            log.error((Object)(ufisTimestamp + " is no valid timestamp (too short)"));
            return 0L;
        }
    }

    private String createUfisTimestamp(long unixTimestamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date(unixTimestamp));
        StringBuffer buf = new StringBuffer();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int h = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        int msec = cal.get(14);
        buf.append(year);
        buf.append(month < 10 ? "0" + month : Integer.valueOf(month));
        buf.append(day < 10 ? "0" + day : Integer.valueOf(day));
        buf.append(h < 10 ? "0" + h : Integer.valueOf(h));
        buf.append(min < 10 ? "0" + min : Integer.valueOf(min));
        buf.append(sec < 10 ? "0" + sec : Integer.valueOf(sec));
        buf.append(msec < 10 ? "00" + msec : (msec < 100 ? "0" + msec : Integer.valueOf(msec)));
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = "";
            do {
                System.out.println("Enter Timestamp: ");
                line = br.readLine();
                if (line.length() == 0) return;
                Timestamp timestamp = null;
                if (line.equals("now")) {
                    timestamp = new Timestamp();
                }
                if (line.length() == 13) {
                    timestamp = new Timestamp(Long.parseLong(line));
                }
                if (line.length() == 14) {
                    timestamp = new Timestamp(line + "000");
                }
                if (line.length() == 17) {
                    timestamp = new Timestamp(line);
                }
                System.out.println("Unix: " + timestamp.getUnixTimestamp());
                System.out.println("Ufis: " + timestamp.getUfisTimestamp());
                TimeZone localTimeZone = TimeZone.getDefault();
                Date date = new Date(timestamp.getUnixTimestamp());
                DateFormat df = DateFormat.getDateTimeInstance(3, 1);
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                System.out.println(df.format(date));
                df.setTimeZone(localTimeZone);
                System.out.println(df.format(date) + "(" + localTimeZone.getDisplayName() + ")");
                System.out.println();
            } while (line.length() > 0);
            return;
        }
        catch (IOException e) {
            System.out.println("Error while reading from keyboard");
        }
    }

    public String getUfisTimestamp() {
        return this.createUfisTimestamp(this.unixTimestamp);
    }

    public void setUfisTimestamp(String ufisTimestamp) {
        this.unixTimestamp = this.parseUfisTimestamp(ufisTimestamp);
    }

    public long getUnixTimestamp() {
        return this.unixTimestamp;
    }

    public void setUnixTimestamp(long unixTimestamp) {
        this.unixTimestamp = unixTimestamp;
    }
}

