/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.fisFlight;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.fis.jaxb.flight.MSG;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.Timestamp;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import java.io.Reader;
import java.io.StringReader;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FisFlightTransformBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(FisFlightTransformBean.class);
    private static final int MIN = 60000;
    private FisFlightFacadeLocal fisFlightFacadeBean;

    public void ejbCreate() throws CreateException {
        super.ejbCreate();
    }

    public MSG getMSGFromXMLString(String xml) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"de.proveo.util.fis.jaxb.flight", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            return (MSG)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException e) {
            log.error((Object)"runs into ", (Throwable)e);
            return null;
        }
    }

    public FisFlightCacheValue updateFlightCacheValueByMSG(FisFlightCacheValue fisFlightCacheValue, MSG msg) {
        String pstn;
        String via8;
        String via7;
        String via6;
        String via5;
        String via4;
        String via3;
        String via2;
        String via1;
        String ofbl;
        String airb;
        String onbl;
        String land;
        String act5;
        String act3;
        String ttyp;
        String ftyp;
        String org3;
        String des3;
        String csgn;
        String regn;
        Timestamp receiveTimestamp = new Timestamp();
        MSG.MSGSTREAMOUT.INFOBJGENERICFLIGHT header = msg.getMSGSTREAMOUT().getINFOBJGENERICFLIGHT();
        String timestamp = header.getTIMESTAMP();
        log.info((Object)("timestamp: " + timestamp));
        String actiontype = header.getACTIONTYPE();
        log.info((Object)("actiontype: " + actiontype));
        String uaft = header.getUAFT();
        log.info((Object)("uaft: " + uaft));
        long unixTime = new Timestamp(timestamp).getUnixTimestamp();
        fisFlightCacheValue.setCustomerCreateTime(unixTime);
        fisFlightCacheValue.setUniqueFlightNumber(uaft);
        MSG.MSGSTREAMOUT.MSGOBJECTS.INFOBJFLIGHT body = msg.getMSGSTREAMOUT().getMSGOBJECTS().getINFOBJFLIGHT();
        fisFlightCacheValue.setReceiveTime(receiveTimestamp.getUnixTimestamp());
        log.debug((Object)("set receiveTimestamp to " + receiveTimestamp.getUnixTimestamp()));
        String flno = body.getFLNO();
        if (flno != null) {
            fisFlightCacheValue.setFlightNumberSemantics(flno);
            log.info((Object)("flno: " + flno));
        } else {
            log.warn((Object)"FLNO is missing");
        }
        String alc2 = body.getALC2();
        if (alc2 != null) {
            fisFlightCacheValue.setIataAirlineCode(alc2);
            log.info((Object)("alc2: " + alc2));
        } else {
            log.warn((Object)"ALC2 is missing");
        }
        String alc3 = body.getALC3();
        if (alc3 != null) {
            fisFlightCacheValue.setIcaoAirlineCode(alc3);
            log.info((Object)("alc3: " + alc3));
        } else {
            log.warn((Object)"ALC3 is missing");
        }
        String fltn = body.getFLTN();
        if (fltn != null) {
            fisFlightCacheValue.setFlightNumber(fltn);
            log.info((Object)("fltn: " + fltn));
        } else {
            log.warn((Object)"FLTN is missing");
        }
        String flns = body.getFLNS();
        if (flns != null) {
            fisFlightCacheValue.setFlightNumberSuffix(flns);
            log.info((Object)("flns: " + flns));
        } else {
            log.warn((Object)"FLNS is missing");
        }
        String adid = body.getADID();
        if (adid != null) {
            fisFlightCacheValue.setArrivalDeparture(adid);
            log.info((Object)("adid: " + adid));
        } else {
            log.warn((Object)"ADID is missing");
        }
        String stoa = body.getSTOA();
        log.debug((Object)("stoa: " + stoa));
        if (stoa != null) {
            unixTime = new Timestamp(stoa).getUnixTimestamp();
            log.debug((Object)("STOA unixTimestamp: " + unixTime));
            fisFlightCacheValue.setScheduledTimeOfArrival(unixTime);
            log.info((Object)("stoa: " + stoa));
        } else if (adid.equals("A")) {
            log.warn((Object)"STOA is missing");
        }
        String stod = body.getSTOD();
        log.debug((Object)("stod: " + stod));
        if (stod != null) {
            unixTime = new Timestamp(stod).getUnixTimestamp();
            fisFlightCacheValue.setScheduledTimeOfDeparture(unixTime);
            log.info((Object)("stod: " + stod));
        } else if (adid.equals("D")) {
            log.warn((Object)"STOD is missing");
        }
        String rkey = body.getRKEY();
        if (rkey != null) {
            fisFlightCacheValue.setRotationKey(rkey);
            log.info((Object)("rkey: " + rkey));
        }
        if ((regn = body.getREGN()) != null) {
            fisFlightCacheValue.setRegistration(regn);
            log.info((Object)("regn: " + regn));
        }
        if ((csgn = body.getCSGN()) != null) {
            fisFlightCacheValue.setCallSign(csgn);
            log.info((Object)("csgn: " + csgn));
        }
        String etai = body.getETAI();
        log.debug((Object)("etai: " + etai));
        if (etai != null) {
            unixTime = new Timestamp(etai).getUnixTimestamp();
            fisFlightCacheValue.setEstimatedTimeOfArrival(unixTime);
            log.info((Object)("etai: " + etai));
        }
        String etdi = body.getETDI();
        log.debug((Object)("etdi: " + etdi));
        if (etdi != null) {
            unixTime = new Timestamp(etdi).getUnixTimestamp();
            fisFlightCacheValue.setEstimatedTimeOfDeparture(unixTime);
            log.info((Object)("etdi: " + etdi));
        }
        if ((des3 = body.getDES3()) != null) {
            fisFlightCacheValue.setDestination3LetterCode(des3);
            log.info((Object)("des3: " + des3));
        }
        if ((org3 = body.getORG3()) != null) {
            fisFlightCacheValue.setOrigin3LetterCode(org3);
            log.info((Object)("org3: " + org3));
        }
        if ((ftyp = body.getFTYP()) != null) {
            fisFlightCacheValue.setFlightStatus(ftyp);
            log.info((Object)("ftyp: " + ftyp));
        }
        if ((ttyp = body.getTTYP()) != null) {
            fisFlightCacheValue.setFlightNature(ttyp);
            log.info((Object)("ttyp: " + ttyp));
        }
        if ((act3 = body.getACT3()) != null) {
            fisFlightCacheValue.setAircraftType3LetterCode(act3);
            log.info((Object)("act3: " + act3));
        }
        if ((act5 = body.getACT5()) != null) {
            fisFlightCacheValue.setAircraftType5LetterCode(act5);
            log.info((Object)("act5: " + act5));
        }
        if ((land = body.getLAND()) != null) {
            unixTime = new Timestamp(land).getUnixTimestamp();
            fisFlightCacheValue.setLandingTime(unixTime);
            log.info((Object)("land: " + land));
        }
        if ((onbl = body.getONBL()) != null) {
            long now;
            unixTime = new Timestamp(onbl).getUnixTimestamp();
            if (unixTime - (now = System.currentTimeMillis()) > 300000L) {
                log.warn((Object)("ONBL of flight " + uaft + " is more than 5 min in the future"));
            } else {
                fisFlightCacheValue.setOnBlockTime(unixTime);
                log.info((Object)("onbl: " + onbl));
            }
        }
        if ((airb = body.getAIRB()) != null) {
            unixTime = new Timestamp(airb).getUnixTimestamp();
            fisFlightCacheValue.setTakeOffTime(unixTime);
            log.info((Object)("airb: " + airb));
        }
        if ((ofbl = body.getOFBL()) != null) {
            long now;
            unixTime = new Timestamp(ofbl).getUnixTimestamp();
            if (unixTime - (now = System.currentTimeMillis()) > 300000L) {
                log.warn((Object)("OFBL of flight " + uaft + " is more than 5 min in the future"));
            } else {
                fisFlightCacheValue.setOffBlockTime(unixTime);
                log.info((Object)("ofbl: " + ofbl));
            }
        }
        if ((via1 = body.getVIA1()) != null) {
            fisFlightCacheValue.setVia1AirportCode(via1);
            log.info((Object)("via1: " + via1));
        }
        if ((via2 = body.getVIA2()) != null) {
            fisFlightCacheValue.setVia2AirportCode(via2);
            log.info((Object)("via2: " + via2));
        }
        if ((via3 = body.getVIA3()) != null) {
            fisFlightCacheValue.setVia3AirportCode(via3);
            log.info((Object)("via3: " + via3));
        }
        if ((via4 = body.getVIA4()) != null) {
            fisFlightCacheValue.setVia4AirportCode(via4);
            log.info((Object)("via4: " + via4));
        }
        if ((via5 = body.getVIA5()) != null) {
            fisFlightCacheValue.setVia5AirportCode(via5);
            log.info((Object)("via5: " + via5));
        }
        if ((via6 = body.getVIA6()) != null) {
            fisFlightCacheValue.setVia6AirportCode(via6);
            log.info((Object)("via6: " + via6));
        }
        if ((via7 = body.getVIA7()) != null) {
            fisFlightCacheValue.setVia7AirportCode(via7);
            log.info((Object)("via7: " + via7));
        }
        if ((via8 = body.getVIA8()) != null) {
            fisFlightCacheValue.setVia8AirportCode(via8);
            log.info((Object)("via8: " + via8));
        }
        if ((pstn = body.getPSTN()) != null) {
            fisFlightCacheValue.setParkingStand(pstn);
            log.info((Object)("pstn: " + pstn));
        }
        this.updateMatchingTurnaroundFlight(fisFlightCacheValue, act5, ttyp, regn, pstn);
        return fisFlightCacheValue;
    }

    private void updateMatchingTurnaroundFlight(FisFlightCacheValue fisFlightCacheValue, String act5, String ttyp, String regn, String pstn) {
        if (this.fisFlightFacadeBean == null) {
            try {
                this.fisFlightFacadeBean = FisFlightFacadeUtil.getLocalHome().create();
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
                this.fisFlightFacadeBean = null;
                return;
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
                this.fisFlightFacadeBean = null;
                return;
            }
        }
        try {
            if (this.fisFlightFacadeBean.isTurnaroundFlight(fisFlightCacheValue.getUniqueFlightNumber())) {
                String matchingTurnaroundFlightNumber = this.fisFlightFacadeBean.getMatchingTurnaroundFlightNumber(fisFlightCacheValue.getUniqueFlightNumber());
                FisFlightCacheValue other = this.fisFlightFacadeBean.getFlightCacheValue(matchingTurnaroundFlightNumber);
                other.setAircraftType5LetterCode(act5);
                other.setFlightNature(ttyp);
                other.setRegistration(regn);
                other.setParkingStand(pstn);
                this.fisFlightFacadeBean.updateFlight(other);
            }
        }
        catch (Exception e) {
            log.debug((Object)("could not update common fields of matching turnaround flight for flight " + fisFlightCacheValue.getUniqueFlightNumber()), (Throwable)e);
        }
    }
}

