/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event;

import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.EventUtil;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.rts.configuration.infoman.InfomanEventServiceUtil;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.rts.configuration.monitor.MonitoringUtil;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.app.rfid.RFIDValue;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.StateModelFactory;
import de.proveo.wwt.logic.app.state.aviation.AviationStateModelProxy;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.app.state.exception.ChangeNotAllowedException;
import de.proveo.wwt.logic.app.state.exception.InternalStateModelException;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.rfid.TagEventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.rfid.TagEventFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelUtil;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeUtil;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeUtil;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveInFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveInFacadeUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeUtil;
import de.proveo.wwt.logic.ejb.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.statesum.StateSummarizeUtil;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EventFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(EventFacadeBean.class);
    protected static final String CONFIG_GEN_USE = "events.use.serverside";
    protected static final String CONFIG_GEN_USE_USER_ID = "events.use.serverside.defaultUserId";
    protected static final String CONFIG_GEN_USE_STATEMODEL_ID = "events.use.serverside.triggerStateModelId";
    protected static final String CONFIG_GEN_USE_LOGIN_STATE_ID = "events.use.serverside.loginTriggerStateId";
    protected static final String CONFIG_GEN_USE_LOGOFF_STATE_ID = "events.use.serverside.logoffTriggerStateId";
    private boolean createUseEvents = false;
    private long defaultUserId;
    private long triggerStateModelId;
    private long[] loginTriggerStateIds;
    private long[] logoffTriggerStateIds;
    private UnitModelLocalHome unitModelHome;
    private GdataFacadeLocal gdataFacade;
    private ScanmanMsgFacadeLocal scanmanMsgFacade;
    private NotifyFacadeLocal notifyFacade;
    private KeepAliveInFacadeLocal keepAliveInFacade;
    private UseUserLocalHome useUserHome;
    private UseFacadeLocal useFacade;
    private UnitUserLocal userUser;
    private GeofencingUpdateFacadeLocal geofUpdateFacade;
    private GeofUnitModelLocalHome geofUnitModelHome;
    private CurrentStateFacadeLocal currentStateFacade;
    private InformantFacadeLocal informantFacade;
    private TagEventFacadeLocal tagEventFacadeLocal;
    private InfomanSetupFacadeLocal infomanSetupFacade;
    private static long lastPkGdataHistory = 0L;
    private boolean eventTimestampFix;
    private long eventTimestampFixMaxFuture = 5400000L;
    private static final long DEFAULT_EVENT_TIMESTAMP_FIX_MAX_FUTURE = 5400000L;
    private InfomanEventServiceMBean infomanEventService;
    private MonitoringMBean eventConter;
    private MonitoringMBean useEventCounter;
    private MonitoringMBean stateEventCounter;
    private MonitoringMBean geoEventCounter;
    private MonitoringMBean counterEventCounter;
    private MonitoringMBean scanmanMsgEventCounter;
    private MonitoringMBean keepAliveEventCounter;
    private MonitoringMBean notifyEventCounter;
    private MonitoringMBean rfidEventCounter;
    private MonitoringMBean testEventCounter;

    public void ejbCreate() throws CreateException {
        ConfigurationLocal config;
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
            this.gdataFacade = GdataFacadeUtil.getLocalHome().create();
            this.scanmanMsgFacade = ScanmanMsgFacadeUtil.getLocalHome().create();
            this.notifyFacade = NotifyFacadeUtil.getLocalHome().create();
            this.keepAliveInFacade = KeepAliveInFacadeUtil.getLocalHome().create();
            this.useFacade = UseFacadeUtil.getLocalHome().create();
            this.currentStateFacade = CurrentStateFacadeUtil.getLocalHome().create();
            this.informantFacade = InformantFacadeUtil.getLocalHome().create();
            this.userUser = UnitUserUtil.getLocalHome().create();
            this.geofUpdateFacade = GeofencingUpdateFacadeUtil.getLocalHome().create();
            this.geofUnitModelHome = GeofUnitModelUtil.getLocalHome();
            config = ConfigurationUtil.getLocalHome().create();
            this.infomanSetupFacade = InfomanSetupFacadeUtil.getLocalHome().create();
            this.infomanEventService = InfomanEventServiceUtil.getMBean();
            this.eventConter = MonitoringUtil.getMBean((String)"Events");
            this.useEventCounter = MonitoringUtil.getMBean((String)"UseEvents");
            this.stateEventCounter = MonitoringUtil.getMBean((String)"StateEvents");
            this.geoEventCounter = MonitoringUtil.getMBean((String)"GeoEvents");
            this.counterEventCounter = MonitoringUtil.getMBean((String)"CounterEvents");
            this.scanmanMsgEventCounter = MonitoringUtil.getMBean((String)"ScanmanMsgEvents");
            this.keepAliveEventCounter = MonitoringUtil.getMBean((String)"KeepAliveEvents");
            this.notifyEventCounter = MonitoringUtil.getMBean((String)"NotifyEvents");
            this.rfidEventCounter = MonitoringUtil.getMBean((String)"RFIDEvents");
            this.testEventCounter = MonitoringUtil.getMBean((String)"TestEvents");
        }
        catch (Exception ex) {
            log.error((Object)"ejbCreate() runs into", (Throwable)ex);
            throw new EJBException("ejb reference problem", ex);
        }
        this.eventTimestampFix = Boolean.parseBoolean(config.getParameter("events.timestamp.fix", Boolean.FALSE.toString()));
        if (this.eventTimestampFix) {
            try {
                this.eventTimestampFixMaxFuture = Long.parseLong(config.getParameter("events.timestamp.fix.maxFuture", Long.toString(5400000L)));
            }
            catch (NumberFormatException ex) {
                log.error((Object)"runs during parse 'events.timestamp.fix.maxFuture' into", (Throwable)ex);
                this.eventTimestampFixMaxFuture = 5400000L;
            }
        }
        try {
            this.createUseEvents = Boolean.parseBoolean(config.getParameter(CONFIG_GEN_USE));
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"ejbCreate() paramter events.use.serverside not found. Servers side use events are disabled", (Throwable)ex);
            }
            this.createUseEvents = false;
        }
        if (this.createUseEvents) {
            try {
                this.defaultUserId = Long.parseLong(config.getParameter(CONFIG_GEN_USE_USER_ID));
                this.triggerStateModelId = Long.parseLong(config.getParameter(CONFIG_GEN_USE_STATEMODEL_ID));
                this.loginTriggerStateIds = config.getLongArray(CONFIG_GEN_USE_LOGIN_STATE_ID);
                this.logoffTriggerStateIds = config.getLongArray(CONFIG_GEN_USE_LOGOFF_STATE_ID);
                Arrays.sort(this.loginTriggerStateIds);
                Arrays.sort(this.logoffTriggerStateIds);
            }
            catch (Exception ex) {
                log.error((Object)"ejbCreate() due to an configuration error servers side use events are disabled", (Throwable)ex);
                this.createUseEvents = false;
            }
        }
    }

    protected void fixTimestamp(Properties event, long[] unitIds) {
        event.setProperty("oldTimestamp", event.getProperty("t"));
        long newTimestamp = System.currentTimeMillis();
        event.setProperty("t", Long.toString(newTimestamp));
        ScanmanMsgHistoryValue struct = new ScanmanMsgHistoryValue();
        if (unitIds.length > 0) {
            struct.setUnitId(unitIds[0]);
        }
        struct.setCreateTime(newTimestamp);
        struct.setType(70);
        struct.setMsgToString(event.toString());
        this.scanmanMsgFacade.event(struct);
    }

    public EventResponse handleEvent(Properties event) throws NoSuchElementException {
        String ping;
        EventResponse eventResponse = new EventResponse();
        if (this.infomanEventService.isEventsDisabled()) {
            eventResponse.setEventResponse(false);
            return eventResponse;
        }
        boolean success = false;
        boolean geofSuccess = false;
        if (event.size() == 0) {
            log.warn((Object)"handleEvent() event contains no data");
            return eventResponse;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleEvent() " + event));
        }
        if ((ping = event.getProperty("p")) != null && ping.equals("ejb")) {
            eventResponse.setEventResponse(true);
            return eventResponse;
        }
        long[] unitIds = EventUtil.getUnitIds((Properties)event);
        if (this.infomanEventService.isUnitIdBlocking(unitIds)) {
            eventResponse.setEventResponse(false);
            return eventResponse;
        }
        int eventType = this.getEventType(event);
        if (!event.containsKey("t")) {
            log.debug((Object)"handleEvent() add timestamp for timeless (simulated) events");
            event.setProperty("t", Long.toString(System.currentTimeMillis()));
        }
        if (!this.isInsideTimeframe(event, eventType)) {
            log.debug((Object)"handleEvent() event is outside timeframe, fix it");
            this.fixTimestamp(event, unitIds);
        }
        this.eventConter.increment(unitIds.length);
        for (int i = 0; i < unitIds.length; ++i) {
            UnitModelLocal unitModel = null;
            GeofUnitModelLocal geofUnitModel = null;
            try {
                try {
                    unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitIds[i]));
                }
                catch (ObjectNotFoundException ex) {
                    throw new UnitNotFoundException(unitIds[i], (Exception)((Object)ex));
                }
                if (!unitModel.getBasic()) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("cannot accept an event of a group unit: " + event));
                    }
                    throw new EJBException("cannot accept an event of a group unit");
                }
                geofUnitModel = unitModel.getGeofUnitModel();
                geofSuccess = true;
                if (geofUnitModel == null) {
                    geofSuccess = false;
                }
                if (!eventResponse.isVPN() && !this.infomanEventService.isCallbackDisabled()) {
                    eventResponse.setVPN(unitModel.getCallback());
                }
                int areaId = 0;
                if (this.isPositionEvent(event)) {
                    SerializableEventWrapper wrapper = this.handleGeoEvent(event, unitIds[i]);
                    success = true;
                    try {
                        if (wrapper != null) {
                            areaId = ((GeoStruct)wrapper.get_cacheValue()).getAreaId();
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)"handleEvent() unable to get area", (Throwable)ex);
                    }
                }
                UseUserValue user = null;
                if (this.isUseEvent(event)) {
                    user = this.handleUseEvent(event, unitIds[i], areaId);
                    success = true;
                }
                switch (eventType) {
                    case 7: {
                        success = this.handleRFIDEvent(event, unitIds[i]);
                        break;
                    }
                    case 1: {
                        success = this.handleStateEvent(event, unitIds[i], areaId, user);
                        break;
                    }
                    case 2: {
                        success = this.handleScanmanmessageEvent(event, unitIds[i]);
                        break;
                    }
                    case 3: {
                        success = this.handleKeepaliveEvent(event, unitIds[i]);
                        break;
                    }
                    case 4: {
                        success = this.handleNotifyEvent(event, unitIds[i], areaId);
                        break;
                    }
                    case 6: {
                        success = this.handleACLRequest(unitIds[i]);
                        break;
                    }
                    case 8: {
                        success = this.handleGEOFRequest(unitIds[i]);
                        break;
                    }
                    case 0: 
                    case 5: {
                        break;
                    }
                    case 99: {
                        success = this.handleTestEvent(event, unitIds[i]);
                        break;
                    }
                    default: {
                        if (log.isDebugEnabled()) {
                            log.error((Object)("handleEvent() unknown event type: " + event));
                        }
                        break;
                    }
                }
            }
            catch (UnitNotFoundException ex) {
                log.error((Object)("handleEvent() unkown unit. unitId: " + ex.getUnitId()));
                success = false;
            }
            catch (FinderException ex) {
                log.error((Object)("handleEvent() runs into: " + event), (Throwable)ex);
                success = false;
            }
            if (!success || eventType == 99) continue;
            EventPayload payload = this.infomanSetupFacade.getUpdatePayload(unitIds[i]);
            if (payload != null) {
                eventResponse.setConfigurationUpdateAvailable(true);
                eventResponse.setSoftwareUpdateAvailable(true);
                eventResponse.addPayload(payload);
            }
            if ((payload = this.infomanSetupFacade.getRequestConfigurationPayload(unitModel)) != null) {
                eventResponse.addPayload(payload);
            }
            if (i != 0) continue;
            if (this.userUser.isACLUpdateNecessary(unitModel)) {
                eventResponse.setUserACLChanged(true);
                payload = this.userUser.startACLUpdate(unitModel);
                eventResponse.addPayload(payload);
            }
            if (!geofSuccess || !this.geofUpdateFacade.isGeofAreasUpdateNecessary(geofUnitModel)) continue;
            eventResponse.setGeoAreasChanged(true);
            payload = this.geofUpdateFacade.startGeofAreasUpdate(geofUnitModel);
            eventResponse.addPayload(payload);
        }
        eventResponse.setEventResponse(success);
        return eventResponse;
    }

    protected boolean isInsideTimeframe(Properties event, int eventType) {
        if (eventType != 3 && this.eventTimestampFix) {
            String t = event.getProperty("t");
            if (t != null) {
                try {
                    long timestamp = Long.parseLong(t);
                    long timeDiff = timestamp - System.currentTimeMillis();
                    return timeDiff < this.eventTimestampFixMaxFuture;
                }
                catch (NumberFormatException ex) {
                    log.error((Object)("isInsideTimeframe() timestamp is not a number" + event), (Throwable)ex);
                    return true;
                }
            }
            log.warn((Object)("isInsideTimeframe() cannot check timeframe. Event has no timeframe: " + event));
            return true;
        }
        return true;
    }

    public void resetCallback(Properties event) {
        long[] unitIds = EventUtil.getUnitIds((Properties)event);
        for (int index = 0; index < unitIds.length; ++index) {
            UnitModelPK pk = new UnitModelPK(unitIds[index]);
            try {
                UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(pk);
                unitModel.setCallback(false);
                continue;
            }
            catch (FinderException ex) {
                log.error((Object)("resetCallback() unkown unitId " + unitIds[index]), (Throwable)ex);
            }
        }
    }

    public boolean isPositionEvent(Properties event) {
        return event.containsKey("r");
    }

    public boolean isUseEvent(Properties event) {
        return event.containsKey("uu") || event.containsKey("nuu");
    }

    private int getEventType(Properties event) {
        if (event.containsKey("rf")) {
            return 7;
        }
        if (event.containsKey("m")) {
            return 1;
        }
        if (event.containsKey("st")) {
            return 2;
        }
        if (event.containsKey("nm")) {
            return 4;
        }
        if (event.containsKey("uu")) {
            return 5;
        }
        if (event.containsKey("req")) {
            if (event.getProperty("req").equals("acl")) {
                return 6;
            }
            if (event.getProperty("req").equals("gf")) {
                return 8;
            }
            return -1;
        }
        if (event.containsKey("r")) {
            return 0;
        }
        if (event.containsKey("test")) {
            return 99;
        }
        if (event.containsKey("u") || event.containsKey("u1")) {
            return 3;
        }
        return -1;
    }

    private boolean handleTestEvent(Properties event, long unitId) {
        this.testEventCounter.increment();
        String testType = event.getProperty("test");
        if (testType != null && testType.equals("geoA1")) {
            try {
                StringBuffer cause = new StringBuffer("A1");
                long timestamp = Long.parseLong(event.getProperty("t"));
                double latitude = Double.parseDouble(event.getProperty("aLat"));
                double longitude = Double.parseDouble(event.getProperty("aLong"));
                boolean trusted = Integer.parseInt(event.getProperty("aCF")) == 2 && Integer.parseInt(event.getProperty("aFS")) != 0;
                cause.append(" ");
                cause.append(event.getProperty("aI"));
                int latitudeMSec = (int)(latitude * 60.0 * 60.0 * 1000.0 + 0.5);
                int longitudeMSec = (int)(longitude * 60.0 * 60.0 * 1000.0 + 0.5);
                float speed = (float)Integer.parseInt(event.getProperty("aV")) / 10.0f;
                GeoStruct geoEvent = new GeoStruct(unitId, timestamp, System.currentTimeMillis(), latitudeMSec, longitudeMSec, trusted, cause.toString());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("time", event.getProperty("t"));
                params.put("status", trusted ? "A" : "V");
                params.put("latitude", Long.toString(latitudeMSec));
                params.put("longitude", Long.toString(longitudeMSec));
                params.put("speed", Float.toString(speed));
                params.put("trackMadeGood", Float.toString((float)Integer.parseInt(event.getProperty("aHe")) / 10.0f));
                String record = GPSPosition.createNMEArecord((String)"RMC", params);
                geoEvent.setRmcRec(record);
                params = new HashMap();
                params.put("time", event.getProperty("t"));
                params.put("latitude", Long.toString(latitudeMSec));
                params.put("longitude", Long.toString(longitudeMSec));
                params.put("quality", trusted ? "1" : "0");
                params.put("sats", event.getProperty("aS"));
                params.put("altitude", event.getProperty("aAt"));
                record = GPSPosition.createNMEArecord((String)"GGA", params);
                geoEvent.setGgaRec(record);
                this.generateGeoEvent(geoEvent);
                return true;
            }
            catch (Exception ex) {
                log.error((Object)"handleTestEvent() runs during parse into", (Throwable)ex);
                return false;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("handleTestEvent() unkown test event: " + event));
        }
        return true;
    }

    private boolean handleRFIDEvent(Properties event, long unitId) {
        log.trace((Object)"handleRFIDEvent()");
        this.rfidEventCounter.increment();
        long timestamp = Long.parseLong(event.getProperty("t"));
        long rfidTag = Long.parseLong(event.getProperty("rf"));
        RFIDValue rfidEvent = new RFIDValue(unitId, rfidTag, timestamp);
        if (this.tagEventFacadeLocal == null) {
            try {
                this.tagEventFacadeLocal = TagEventFacadeUtil.getLocalHome().create();
            }
            catch (Exception ex) {
                throw new EJBException(ex);
            }
        }
        this.tagEventFacadeLocal.handleEvent(rfidEvent);
        return true;
    }

    public SerializableEventWrapper generateGeoEvent(GeoStruct geoEvent) {
        SerializableEventWrapper wrapper = this.gdataFacade.event(geoEvent);
        if (wrapper != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("h: " + wrapper.get_historyValue()));
                log.debug((Object)("c: " + wrapper.get_cacheValue()));
            }
            if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
                long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
                if (pkGdataHistoryPre < lastPkGdataHistory && log.isWarnEnabled()) {
                    log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
                }
                lastPkGdataHistory = pkGdataHistoryPre;
            }
            try {
                this.informantFacade.notify(wrapper, "GeoStructHistoryAndCache");
            }
            catch (Exception ex) {
                log.error((Object)"generateGeoEvent() runs into Exception: ", (Throwable)ex);
            }
        }
        return wrapper;
    }

    protected boolean isGeoEventTrusted(Properties event) {
        return Integer.parseInt(event.getProperty("v")) == 1;
    }

    private SerializableEventWrapper handleGeoEvent(Properties event, long unitId) {
        GPSPosition pos;
        log.debug((Object)"handleGeoEvent() new event of type 'GEO'");
        this.geoEventCounter.increment();
        long timestamp = Long.parseLong(event.getProperty("t"));
        long receiveTime = System.currentTimeMillis();
        String rmc = event.getProperty("r");
        String gga = event.getProperty("g");
        boolean trusted = this.isGeoEventTrusted(event);
        String reason = event.getProperty("x");
        if (trusted && !(pos = new GPSPosition(rmc, gga)).isValid()) {
            trusted = false;
        }
        GeoStruct geoEvent = new GeoStruct(unitId, timestamp, receiveTime, rmc, gga, trusted, reason);
        return this.generateGeoEvent(geoEvent);
    }

    private boolean handleStateEvent(Properties event, long unitId, int areaId, UseUserValue user) {
        boolean success = false;
        log.debug((Object)"handleStateEvent() new event of type 'unit state'...");
        this.stateEventCounter.increment();
        long stateModelId = Long.parseLong(event.getProperty("m"));
        long stateId = Long.parseLong(event.getProperty("s"));
        long timestamp = Long.parseLong(event.getProperty("t"));
        long receiveTime = System.currentTimeMillis();
        String remark = event.getProperty("c");
        AviationStateModelProxy stateModelProxy = new AviationStateModelProxy(unitId);
        stateModelProxy.removeAll();
        if (stateModelId == 2050L && stateModelProxy.getOutOfServiceStateModel().getCurrentStateId() != 2091L && stateModelProxy.getOutOfServiceStateModel().getCurrentStateId() != -1L) {
            log.debug((Object)"handleStateEvent() event discarded. (OperationState event not accepted while OutOfServiceState is not OPERATIVE or INITIAL)");
            return true;
        }
        StateModelFactory stateModelFactory = new StateModelFactory();
        try {
            StateModel stateModel = stateModelFactory.getStateModel(stateModelId, unitId);
            StateEvent stateEvent = new StateEvent(unitId, stateModelId, stateId, timestamp, receiveTime, remark);
            stateEvent.setAreaId(areaId);
            if (areaId != 0) {
                stateEvent.setAreaTrusted(this.isGeoEventTrusted(event));
            }
            stateEvent.setUser(user);
            SerializableEventWrapper wrapper = stateModel.changeState(stateEvent);
            if (log.isDebugEnabled()) {
                log.debug((Object)("h: " + wrapper.get_historyValue()));
                log.debug((Object)("c: " + wrapper.get_cacheValue()));
            }
            this.sendDependendStateModels(wrapper);
            try {
                this.updateDependendStateModels(stateEvent, (StateHistoryValue)wrapper.get_historyValue());
            }
            catch (Exception ex) {
                String msg = "changeState() runs into Exception " + ex.toString();
                log.error((Object)msg, (Throwable)ex);
                throw new ImplicitRollbackException(msg);
            }
            success = true;
        }
        catch (Exception ex) {
            log.error((Object)"handleStateEvent() runs into ", (Throwable)ex);
        }
        if (this.createUseEvents) {
            if (stateModelId == this.triggerStateModelId) {
                this.handleAutoGenUseEvent(event, receiveTime, unitId, areaId);
            } else {
                log.debug((Object)"handleStateEvent() creating use event not necessary");
            }
        } else {
            log.debug((Object)"handleStateEvent() creating use event disabled");
        }
        return success;
    }

    protected void updateDependendStateModels(StateEvent event, StateHistoryValue previousStateValue) throws StateModelNotFoundException, ChangeNotAllowedException, InternalStateModelException {
        if (event.getStateModelId() == 2090L) {
            AviationStateModelProxy stateModelProxy;
            String currentRemark;
            long stateId = event.getStateId();
            long newGseAssignmentState = 9999L;
            if (stateId == 2092L || stateId == 2094L || stateId == 2093L || stateId == 2095L || stateId == 2096L) {
                log.debug((Object)"change GSE assignment state to unserviceable");
                newGseAssignmentState = 2124L;
            }
            if (stateId == 2091L) {
                log.debug((Object)"change GSE assignment state to available");
                newGseAssignmentState = 2123L;
            }
            StateModelFactory stateModelFactory = new StateModelFactory();
            StateModel stateModel = stateModelFactory.getStateModel(2120L, event.getUnitId());
            try {
                CurrentStateFacadeStruct currentState = this.currentStateFacade.getCurrentState(event.getUnitId(), 2120L);
                currentRemark = currentState.getRemark();
            }
            catch (NoStateFoundException e) {
                currentRemark = "";
            }
            StateEvent depEvent = new StateEvent(event.getUnitId(), 2120L, newGseAssignmentState, event.getTimestamp(), event.getReceiveTime(), currentRemark);
            SerializableEventWrapper wrapper = stateModel.changeState(depEvent);
            this.sendDependendStateModels(wrapper);
            if (event.getStateId() != 2091L) {
                depEvent = new StateEvent(event.getUnitId(), 2050L, 2051L, event.getTimestamp(), event.getReceiveTime(), "");
                stateModelProxy = new AviationStateModelProxy(event.getUnitId());
                wrapper = stateModelProxy.getOperationStateModel().changeState(depEvent);
                this.sendDependendStateModels(wrapper);
            }
            if (event.getStateId() == 2091L) {
                depEvent = new StateEvent(event.getUnitId(), 2050L, 2054L, event.getTimestamp(), event.getReceiveTime(), "");
                stateModelProxy = new AviationStateModelProxy(event.getUnitId());
                wrapper = stateModelProxy.getOperationStateModel().changeState(depEvent);
                this.sendDependendStateModels(wrapper);
            }
        }
        if (event.getStateModelId() == 2050L && event.getStateId() != 2051L && previousStateValue.getStateId() == -1L) {
            log.debug((Object)"operation state changed from UNKNOWN to other..., change also service state to OPERATIVE");
            StateEvent depEvent = new StateEvent(event.getUnitId(), 2090L, 2091L, event.getTimestamp(), event.getReceiveTime(), "");
            AviationStateModelProxy stateModelProxy = new AviationStateModelProxy(event.getUnitId());
            SerializableEventWrapper wrapper = stateModelProxy.getOutOfServiceStateModel().changeState(depEvent);
            this.sendDependendStateModels(wrapper);
        }
    }

    private String getMessageInfoFromEvent(Properties event) {
        if (event.containsKey("si")) {
            return event.getProperty("si");
        }
        StringBuffer buffer = new StringBuffer();
        int index = 1;
        while (event.containsKey("si" + index)) {
            buffer.append(event.getProperty("si" + index));
            buffer.append(';');
            ++index;
        }
        return buffer.toString();
    }

    private boolean handleScanmanmessageEvent(Properties event, long unitId) {
        boolean success = false;
        log.debug((Object)"handleScanmanmessageEvent() new event of type 'scanman message' ");
        this.scanmanMsgEventCounter.increment();
        int smType = Integer.parseInt(event.getProperty("st"));
        String smInfo = this.getMessageInfoFromEvent(event);
        long timestamp = Long.parseLong(event.getProperty("t"));
        ScanmanMsgHistoryValue scanmanMsgHistoryValue = new ScanmanMsgHistoryValue();
        scanmanMsgHistoryValue.setUnitId(unitId);
        scanmanMsgHistoryValue.setCreateTime(timestamp);
        scanmanMsgHistoryValue.setType(smType);
        String msg = null;
        switch (smType) {
            case 10: {
                msg = "current IP: " + smInfo;
                break;
            }
            case 20: {
                msg = "reboot " + smInfo;
                break;
            }
            case 9: {
                msg = "begin event failed:  " + smInfo;
                break;
            }
            case 8: {
                msg = "end event failed";
                break;
            }
            case 11: {
                msg = "disconnect VPN";
                break;
            }
            default: {
                msg = smInfo;
            }
        }
        scanmanMsgHistoryValue.setMsgToString(msg);
        if (event.containsKey("binary")) {
            scanmanMsgHistoryValue.setBinaryPayload((byte[])event.get("binary"));
        }
        try {
            this.scanmanMsgFacade.event(scanmanMsgHistoryValue);
            success = true;
        }
        catch (Exception ex) {
            log.error((Object)"handleScanmanmessageEvent() runs into ", (Throwable)ex);
        }
        try {
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)scanmanMsgHistoryValue);
            eventWrapper.set_typeOfEvent("InfomanMessages");
            this.informantFacade.notify(eventWrapper, "InfomanMessages");
        }
        catch (Exception e) {
            log.error((Object)"handleScanmanmessageEvent runs into Exception: ", (Throwable)e);
        }
        return success;
    }

    private boolean handleNotifyEvent(Properties event, long unitId, int areaId) {
        boolean success = false;
        log.debug((Object)"handleNotifyEvent() new event of type 'notify'");
        this.notifyEventCounter.increment();
        try {
            SerializableEventWrapper wrapper = this.notifyFacade.event(event, unitId, areaId);
            if (wrapper != null) {
                wrapper.set_typeOfEvent("InfomanNotifyMessages");
                this.informantFacade.notify(wrapper, "InfomanNotifyMessages");
            }
            success = true;
        }
        catch (Exception ex) {
            log.error((Object)"handleNotifyEvent() runs into ", (Throwable)ex);
        }
        return success;
    }

    private boolean handleKeepaliveEvent(Properties event, long unitId) {
        long timestamp;
        log.debug((Object)"handleKeepaliveEvent() new event of type 'keep alive'");
        try {
            timestamp = Long.parseLong(event.getProperty("t"));
        }
        catch (NumberFormatException ex) {
            log.error((Object)"could not parse event time", (Throwable)ex);
            return false;
        }
        KeepAliveEvent keepAliveEvent = new KeepAliveEvent(unitId, timestamp);
        keepAliveEvent.setReceiveTimestamp(System.currentTimeMillis());
        this.keepAliveEventCounter.increment();
        try {
            boolean succesfuly = this.keepAliveInFacade.event(keepAliveEvent, unitId);
            if (!succesfuly) {
                return true;
            }
            Properties onlineState = new Properties();
            onlineState.putAll((Map<?, ?>)event);
            onlineState.setProperty("m", Long.toString(2110L));
            onlineState.setProperty("s", Long.toString(2112L));
            if (log.isTraceEnabled()) {
                log.trace((Object)("infoman wakup. switch online state: " + onlineState));
            }
            this.handleStateEvent(onlineState, unitId, 0, null);
        }
        catch (Exception ex) {
            log.error((Object)"handleKeepaliveEvent() runs into ", (Throwable)ex);
        }
        try {
            SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)keepAliveEvent);
            eventWrapper.set_typeOfEvent("KeepAlive");
            this.informantFacade.notify(eventWrapper, "KeepAlive");
        }
        catch (Exception e) {
            log.error((Object)"Error while notifying informantFaced!", (Throwable)e);
        }
        return this.sendKeepAliveEvent(keepAliveEvent);
    }

    protected boolean handleACLRequest(long unitId) {
        log.trace((Object)"handleACLRequest()");
        try {
            this.userUser.updateUnitModel(unitId, true);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"handleACLRequest() runs into", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"handleACLRequest() runs into", (Throwable)ex);
        }
        return true;
    }

    protected boolean handleGEOFRequest(long unitId) {
        log.trace((Object)"handleGEOFRequest()");
        try {
            this.geofUpdateFacade.updateGeofUnitModel(unitId, true);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"handleGEOFRequest() runs into", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"handleGEOFRequest() runs into", (Throwable)ex);
        }
        return true;
    }

    private UseUserValue handleUseEvent(Properties event, long unitId, int areaId) {
        this.useEventCounter.increment();
        UseEvent useEvent = new UseEvent();
        useEvent.setReceiveTime(System.currentTimeMillis());
        useEvent.setUnitId(unitId);
        useEvent.setUserKey(event.getProperty("uu"));
        useEvent.setTimestamp(Long.parseLong(event.getProperty("t")));
        if (event.containsKey("ul")) {
            if (Integer.parseInt(event.getProperty("ul")) == 1) {
                useEvent.setLogin(true);
            } else {
                useEvent.setLogin(false);
            }
        } else {
            useEvent.setLogin(useEvent.getUserKey() != null);
        }
        if (useEvent.getUserKey() == null) {
            useEvent.setUserKey(event.getProperty("nuu"));
        }
        UseUserValue useUser = null;
        if (useEvent.getUserKey() != null) {
            try {
                useUser = this.useFacade.getUser(useEvent.getUserKey());
                useEvent.setUserGroupId(useUser.getGroupId());
            }
            catch (UserNotFoundException ex) {
                log.warn((Object)"handleUseEvent() cannot get use groupId");
            }
        }
        if (event.containsKey("uu")) {
            this.useFacade.event(event, useEvent, areaId);
            try {
                SerializableEventWrapper wrapper = new SerializableEventWrapper();
                wrapper.set_cacheValue((Serializable)useEvent);
                wrapper.set_typeOfEvent("UseEvent");
                this.informantFacade.notify(wrapper, "UseEvent");
            }
            catch (Exception e) {
                log.error((Object)"handleUseEvent runs into Exception: ", (Throwable)e);
            }
        }
        return useUser;
    }

    protected boolean handleAutoGenUseEvent(Properties event, long receiveTime, long unitId, int areaId) {
        UseUserValue useUserValue;
        boolean logoff;
        long stateId = Long.parseLong(event.getProperty("s"));
        boolean login = Arrays.binarySearch(this.loginTriggerStateIds, stateId) >= 0;
        boolean bl = logoff = Arrays.binarySearch(this.logoffTriggerStateIds, stateId) >= 0;
        if (!login && !logoff) {
            return false;
        }
        if (login && logoff) {
            if (log.isErrorEnabled()) {
                log.error((Object)("handleAutoGenUseEvent() configuration problem get a event with stateId '" + stateId + "' and should trigger a login and a logoff at the same time?"));
            }
            return false;
        }
        try {
            UseUserPK pk = new UseUserPK(this.defaultUserId);
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(pk);
            useUserValue = useUser.getUseUserValue();
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Cannot get default user '" + this.defaultUserId + "'"), (Throwable)ex);
            }
            return false;
        }
        long timestamp = Long.parseLong(event.getProperty("t"));
        UseEvent useEvent = new UseEvent();
        useEvent.setLogin(login);
        useEvent.setUnitId(unitId);
        useEvent.setTimestamp(timestamp);
        useEvent.setReceiveTime(receiveTime);
        useEvent.setUserGroupId(useUserValue.getGroupId());
        useEvent.setUserKey(useUserValue.getKey());
        log.debug((Object)"handleAutoGenUseEvent() process autogenerated UseEvent");
        try {
            this.useFacade.event(event, useEvent, areaId);
            return true;
        }
        catch (Exception ex) {
            log.error((Object)"Cannot process UseEvent", (Throwable)ex);
            return false;
        }
    }

    private void sendDependendStateModels(SerializableEventWrapper wrapper) {
        try {
            this.informantFacade.notify(wrapper, "StateEventHistoryAndCache");
        }
        catch (Exception e) {
            log.error((Object)"handleStateEvent runs into Exception: ", (Throwable)e);
        }
    }

    private boolean sendKeepAliveEvent(KeepAliveEvent keepAliveEvent) {
        boolean success = false;
        try {
            QueueConnection connection = StateSummarizeUtil.getQueueConnection();
            QueueSession session = connection.createQueueSession(false, 1);
            Queue queue = StateSummarizeUtil.getQueue();
            QueueSender sender = session.createSender(queue);
            ObjectMessage message = session.createObjectMessage((Serializable)keepAliveEvent);
            sender.send((Message)message);
            connection.close();
            success = true;
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }
}

