/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.state;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.state.State;
import de.proveo.wwt.logic.app.state.StateFactory;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.app.state.exception.ChangeNotAllowedException;
import de.proveo.wwt.logic.app.state.exception.InternalStateModelException;
import de.proveo.wwt.logic.app.state.exception.StateUnkownInModelException;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacade;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeHome;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.state.exception.NoStateFoundException;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StateModel {
    private static final Log log = LogFactory.getLog(StateModel.class);
    private CurrentStateFacade currentState;
    private State state;
    private StateFactory stateFactory;
    private boolean dontValidate;
    private boolean persistent;
    private long stateModelId;
    private long unitId;

    protected StateModel(long stateModelId, StateFactory stateFactory, long unitId) {
        this.stateModelId = stateModelId;
        this.stateFactory = stateFactory;
        this.unitId = unitId;
        if (stateFactory == null) {
            throw new IllegalArgumentException("parameter stateFactory cannot be null");
        }
        if (this.stateFactory.getStateModelId() != this.stateModelId) {
            throw new IllegalArgumentException("StateModel Factory doesn't fit to stateModel");
        }
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("CurrentStateFacade");
            CurrentStateFacadeHome home = (CurrentStateFacadeHome)PortableRemoteObject.narrow((Object)ref, CurrentStateFacadeHome.class);
            this.currentState = home.create();
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("retrieve unit's current state for stateModel: " + this.getStateModelId()));
        }
        CurrentStateFacadeStruct current = this.getCurrentState(unitId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("after getCurrentState() stateId: " + current.getStateId() + ", stateModelId: " + current.getStateModelId()));
        }
        this.persistent = current.isPersistent();
        this.dontValidate = current.isDontValidateNext();
        try {
            this.state = this.stateFactory.getState(current.getStateId());
        }
        catch (StateUnkownInModelException ex) {
            log.error((Object)"can't instanciate the the current State", (Throwable)ex);
        }
    }

    public CurrentStateFacadeStruct getCurrentState(long unitId) {
        try {
            return this.getCurrentState(unitId, this.stateModelId);
        }
        catch (NoStateFoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getCurrentState(unitId) can't find a state for unitId: " + unitId + " in stateModel: " + ex.getStateModelId() + " -> init StateModel"));
            }
            return this.getInitState(unitId);
        }
    }

    public long getCurrentStateId() {
        return this.state.getStateId();
    }

    public boolean isDontValidate() {
        return this.dontValidate;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public long getStateModelId() {
        return this.stateModelId;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public SerializableEventWrapper changeState(StateEvent stateEvent) throws ChangeNotAllowedException, InternalStateModelException {
        boolean stateIsEqual;
        State oldState = this.state;
        this.state = this.state.changeState(stateEvent, this.dontValidate);
        StateEvent myStateEvent = stateEvent;
        SerializableEventWrapper wrapper = null;
        if (this.stateModelId != stateEvent.getStateModelId()) {
            myStateEvent = new StateEvent(stateEvent.getUnitId(), this.stateModelId, this.state.getStateId(), stateEvent.getTimestamp(), stateEvent.getReceiveTime(), stateEvent.getRemark());
        }
        if ((stateIsEqual = this.state.equals(oldState)) && !this.persistent) {
            try {
                wrapper = this.currentState.changeState(myStateEvent);
            }
            catch (Exception ex) {
                throw new ChangeNotAllowedException(myStateEvent.getStateModelId(), stateEvent.getStateId(), this.state.getStateId());
            }
        }
        if (!stateIsEqual) {
            int loopCounter;
            int MAX_LOOP = 100;
            for (loopCounter = 0; !this.state.equals(oldState) && loopCounter <= 100; ++loopCounter) {
                oldState.leave(myStateEvent);
                oldState = this.state;
                this.state = this.state.enter(myStateEvent);
            }
            if (loopCounter > 100) {
                log.error((Object)("changeState() never Ending Loop? check stateModel: " + this.getName() + " State.enter(). stateEvent ->" + myStateEvent));
            }
            if (this.state.getStateId() != oldState.getStateId()) {
                myStateEvent = new StateEvent(myStateEvent.getUnitId(), myStateEvent.getStateModelId(), this.state.getStateId(), myStateEvent.getTimestamp(), myStateEvent.getReceiveTime(), myStateEvent.getRemark());
            }
            try {
                wrapper = this.currentState.changeState(myStateEvent);
            }
            catch (Exception ex) {
                log.error((Object)"runs into", (Throwable)ex);
                throw new ChangeNotAllowedException(myStateEvent.getStateModelId(), myStateEvent.getStateId(), this.state.getStateId());
            }
        }
        wrapper.set_typeOfEvent("StateEventHistoryAndCache");
        return wrapper;
    }

    public void doPersistent(long unitId, long timestamp) throws InternalStateModelException {
        if (!this.persistent) {
            StateEvent evt = new StateEvent(unitId, this.stateModelId, this.state.getStateId(), timestamp, timestamp, null);
            try {
                this.currentState.changeState(evt);
            }
            catch (Exception ex) {
                throw new InternalStateModelException(evt.getStateModelId(), evt.getStateId(), evt, "Cant't persist StateModel");
            }
        }
    }

    protected abstract String getName();

    protected State getCurrentState() {
        return this.state;
    }

    protected CurrentStateFacadeStruct getCurrentState(long unitId, long otherStateModelId) throws NoStateFoundException {
        log.debug((Object)"getCurrentState(long unitId, long otherStateModelId)");
        try {
            return this.currentState.getCurrentState(unitId, otherStateModelId);
        }
        catch (RemoteException ex) {
            log.error((Object)"getCurrentState(unitId, stateModelId) runs during get State from CurrentState SessionBean into", (Throwable)ex);
            throw new NoStateFoundException(unitId, otherStateModelId, "runs into", ex);
        }
    }

    protected abstract CurrentStateFacadeStruct getInitState(long var1);

    protected StateFactory getStateFactory() {
        return this.stateFactory;
    }

    public String toString() {
        return this.getName() + ", id: " + this.getStateModelId();
    }

    public abstract long[] getPossibleStates();
}

