/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.state;

import de.proveo.wwt.logic.app.state.StateFactory;
import de.proveo.wwt.logic.app.state.event.StateEvent;
import de.proveo.wwt.logic.app.state.exception.ChangeNotAllowedException;
import de.proveo.wwt.logic.app.state.exception.InternalStateModelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class State {
    private static final transient Log log = LogFactory.getLog(State.class);
    private StateFactory stateFactory;
    private long stateId;
    private long stateModelId;

    protected State(long stateId, long stateModelId, StateFactory stateFactory) {
        this.stateId = stateId;
        this.stateModelId = stateModelId;
        this.stateFactory = stateFactory;
        if (this.stateFactory == null) {
            throw new IllegalArgumentException("parameter stateFactory cannot be null");
        }
        if (this.stateFactory.getStateModelId() != this.stateModelId) {
            throw new IllegalArgumentException("StateModel Factory doesn't fit to stateModel");
        }
    }

    public abstract String getName();

    public long getStateId() {
        return this.stateId;
    }

    public State changeState(StateEvent stateEvent, boolean dontValidate) throws ChangeNotAllowedException, InternalStateModelException {
        if (this.stateModelId == stateEvent.getStateModelId()) {
            try {
                return this.stateFactory.getState(stateEvent.getStateId());
            }
            catch (Exception ex) {
                throw new InternalStateModelException(this.stateModelId, this.stateId, stateEvent, "I can't instanciate the new state", ex);
            }
        }
        throw new InternalStateModelException(this.stateModelId, this.stateId, stateEvent, "No Implementation for this Event");
    }

    public State enter(long unitId) {
        return this;
    }

    public State enter(StateEvent event) {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof State) {
            State that = (State)obj;
            return this.equals(that);
        }
        return false;
    }

    public boolean equals(State that) {
        return this.stateId == that.stateId && this.stateModelId == that.stateModelId;
    }

    public void leave(long unitId) {
    }

    public void leave(StateEvent event) {
    }

    protected StateFactory getStateFactory() {
        return this.stateFactory;
    }

    protected long getStateModelId() {
        return this.stateModelId;
    }

    public String toString() {
        return this.getName() + ", id: " + this.getStateId();
    }
}

