/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFilter {
    private static final Log log = LogFactory.getLog(MapFilter.class);
    private final boolean STAMP_PASSED = true;
    private final boolean STAMP_NOT_PASSED = false;
    Map filter = new HashMap();

    public void setFilter(Map theFilter) {
        this.filter = theFilter;
    }

    public Map getFilter() {
        return this.filter;
    }

    public boolean isFilterSet() {
        return this.filter != null && this.filter.size() >= 1;
    }

    public Map markStamp(Map singleStamp) {
        if (this.isFilterSet()) {
            HashSet<HashMap<String, Object>> allStampsDummySet = new HashSet<HashMap<String, Object>>();
            allStampsDummySet.add((HashMap<String, Object>)singleStamp);
            HashMap<Long, HashMap<String, Object>> filteredStamp = this.filterData(allStampsDummySet);
            if (filteredStamp.size() == 0) {
                singleStamp.put("FilterPassed", this.STAMP_NOT_PASSED);
            } else {
                singleStamp.put("FilterPassed", this.STAMP_PASSED);
            }
        } else {
            singleStamp.put("FilterPassed", this.STAMP_PASSED);
        }
        return singleStamp;
    }

    public HashMap markData(HashMap allStampsMap) {
        String method = "markData(): ";
        if (allStampsMap == null) {
            log.error((Object)(method + "allStampsMap ==null, no stamps to mark"));
            return null;
        }
        if (this.isFilterSet()) {
            this.markStamps(allStampsMap, false);
            HashMap<Long, HashMap<String, Object>> filteredStamps = this.filterData(new HashSet<HashMap<String, Object>>(allStampsMap.values()));
            allStampsMap.putAll(filteredStamps);
        } else {
            this.markStamps(allStampsMap, true);
        }
        return allStampsMap;
    }

    public HashMap<Long, HashMap<String, Object>> filterData(Set<HashMap<String, Object>> allStamps) {
        String method = "filterData(): ";
        HashMap<Long, HashMap<String, Object>> filteredStamps = new HashMap<Long, HashMap<String, Object>>();
        if (allStamps == null) {
            log.warn((Object)(method + "allStamps==null, no stamps up to now"));
            return filteredStamps;
        }
        if (!this.isFilterSet()) {
            return this.fastCopy(allStamps);
        }
        long now = System.currentTimeMillis();
        List requestedUnitIds = this.getParameters("unitId");
        List requestedUnitKinds = this.getParameters("unitKind");
        List requestedGseAssignmentstates = this.getParameters("gseAssignmentState");
        List requestedOperationstates = this.getParameters("operationState");
        List requestedMotorstates = this.getParameters("motorState");
        List requestedServicestates = this.getParameters("serviceState");
        List requestedAssignedstates = this.getParameters("assignedState");
        List requestedFuelstates = this.getParameters("fuelState");
        List requestedConnectorstates = this.getParameters("connectorState");
        List requestedFlag1states = this.getParameters("flag1State");
        List requestedFlag2states = this.getParameters("flag2State");
        List requestedFlag3states = this.getParameters("flag3State");
        List requestedOnlinestates = this.getParameters("onlineState");
        String requestedIsAlive = (String)this.filter.get("isAlive");
        String requestedIsAliveTimeout = (String)this.filter.get("isAliveTimeout");
        if (requestedOnlinestates.size() > 0 && requestedIsAlive != null && requestedIsAlive.length() > 0) {
            log.error((Object)"mixed use of 'onlineState' (new) and 'isAlive' (old) not allowed in URL! Check client configuration!");
        }
        long unitId = 0L;
        String unitType = "";
        String unitName = "";
        int stampNo = 0;
        Iterator<HashMap<String, Object>> it = allStamps.iterator();
        while (it.hasNext()) {
            ++stampNo;
            HashMap<String, Object> originalStamp = it.next();
            if (originalStamp == null) {
                log.error((Object)(method + "HashMap 'allStamps' contain a stamp=null!, stampNo=" + stampNo + ", allStamps.size=" + allStamps.size()));
                continue;
            }
            HashMap<String, Object> filteredStamp = new HashMap<String, Object>();
            Object objectVal = this.getStampValue(originalStamp, "UnitId");
            if (objectVal == null) {
                log.error((Object)(method + " originalStamp does not contain an unit ID!"));
                continue;
            }
            unitId = (Long)objectVal;
            filteredStamp.put("UnitId", objectVal);
            objectVal = this.getStampValue(originalStamp, "UnitType");
            if (objectVal == null) {
                log.error((Object)(method + " originalStamp does not contain an unit type!"));
                continue;
            }
            unitType = (String)objectVal;
            filteredStamp.put("UnitType", objectVal);
            unitName = (String)this.getStampValue(originalStamp, "UnitName");
            filteredStamp.put("UnitName", unitName);
            if (requestedUnitIds.size() > 0 && !requestedUnitIds.contains(Long.toString(unitId)) || requestedUnitKinds.size() > 0 && !requestedUnitKinds.contains(unitType) || requestedIsAlive != null && requestedIsAlive.length() > 0 && !this.matchFilterKeepalive(requestedIsAlive, requestedIsAliveTimeout, now, originalStamp, filteredStamp, unitId, unitName) || requestedOnlinestates.size() > 0 && !this.matchFilterOnlinestate(requestedOnlinestates, requestedIsAliveTimeout, now, originalStamp, filteredStamp, unitId, unitName) || requestedGseAssignmentstates.size() > 0 && !this.matchFilterGSEAssignmentState(requestedGseAssignmentstates, originalStamp, filteredStamp) || !this.matchFilter(requestedOperationstates, originalStamp, filteredStamp, "OperationState") || !this.matchFilter(requestedMotorstates, originalStamp, filteredStamp, "MotorState") || !this.matchFilter(requestedServicestates, originalStamp, filteredStamp, "ServiceState") || !this.matchFilter(requestedAssignedstates, originalStamp, filteredStamp, "AssignedState") || !this.matchFilter(requestedFuelstates, originalStamp, filteredStamp, "FuelState") || !this.matchFilter(requestedConnectorstates, originalStamp, filteredStamp, "ConnectorState") || !this.matchFilter(requestedFlag1states, originalStamp, filteredStamp, "Flag1State") || !this.matchFilter(requestedFlag2states, originalStamp, filteredStamp, "Flag2State") || !this.matchFilter(requestedFlag3states, originalStamp, filteredStamp, "Flag3State")) continue;
            for (String key : originalStamp.keySet()) {
                Object obj = originalStamp.get(key);
                if (filteredStamp.containsKey(key)) continue;
                filteredStamp.put(key, obj);
            }
            filteredStamp.put("FilterPassed", this.STAMP_PASSED);
            filteredStamps.put(unitId, filteredStamp);
        }
        return filteredStamps;
    }

    public List getParameters(HttpServletRequest request, String key) {
        ArrayList<String> list = new ArrayList<String>();
        String par = request.getParameter(key);
        if (par != null) {
            StringTokenizer st = new StringTokenizer(par, ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                list.add(str);
            }
        }
        return list;
    }

    private List getParameters(String key) {
        ArrayList<String> list = new ArrayList<String>();
        String par = (String)this.filter.get(key);
        if (par != null) {
            StringTokenizer st = new StringTokenizer(par, ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                list.add(str);
            }
        }
        return list;
    }

    private Object getStampValue(HashMap<String, Object> stamp, String key) {
        return this.getStampValue(stamp, key, false);
    }

    private Object getStampValue(HashMap<String, Object> stamp, String key, boolean optional) {
        if (stamp == null) {
            log.error((Object)("getStampValue(): stamp HashMap is NULL! Can not search for key '" + key + "' !"));
            return null;
        }
        if (stamp.containsKey(key)) {
            return stamp.get(key);
        }
        if (!optional) {
            log.error((Object)("stamp HashMap doesn't contain a value for key '" + key + "' !"));
        }
        return null;
    }

    private boolean matchFilter(List reqList, HashMap stamp, HashMap fStamp, String stampKey) {
        if (reqList.size() == 0) {
            return true;
        }
        Object oVal = this.getStampValue(stamp, stampKey);
        if (oVal != null && reqList.contains(oVal.toString())) {
            fStamp.put(stampKey, oVal);
            return true;
        }
        return false;
    }

    private boolean matchFilterGSEAssignmentState(List reqList, HashMap stamp, HashMap fStamp) {
        String stampKey = "GseAssignmentState";
        Object oVal = this.getStampValue(stamp, stampKey, true);
        if (oVal == null) {
            oVal = new Long(-1L);
        }
        if (reqList.contains(oVal.toString())) {
            fStamp.put(stampKey, oVal);
            return true;
        }
        return false;
    }

    private boolean matchFilterKeepalive(String requestedIsAlive, String requestedIsAliveTimeout, long now, HashMap stamp, HashMap fStamp, long unitId, String unitName) {
        if (requestedIsAlive == null || requestedIsAlive != null && requestedIsAlive.length() == 0) {
            return true;
        }
        if (requestedIsAlive.equals("true,false") || requestedIsAlive.equals("false,true")) {
            return true;
        }
        String method = "matchFilterKeepalive: ";
        Object oVal = this.getStampValue(stamp, "KeepaliveTimestamp");
        if (oVal == null) {
            return Boolean.parseBoolean(requestedIsAlive);
        }
        boolean timeout = true;
        long lastKeepaliveTimestamp = (Long)oVal;
        if (lastKeepaliveTimestamp == 0L) {
            timeout = false;
        } else if (requestedIsAliveTimeout != null) {
            long requestedTimeout = Long.parseLong(requestedIsAliveTimeout);
            timeout = now - lastKeepaliveTimestamp > requestedTimeout;
        } else {
            oVal = this.getStampValue(stamp, "KeepaliveTimeout");
            if (oVal != null) {
                timeout = (Boolean)oVal;
            }
        }
        if (timeout && (oVal = this.getStampValue(stamp, "InfomanOnlineState", true)) != null && Long.parseLong(oVal.toString()) == 2111L) {
            timeout = false;
        }
        if (Boolean.parseBoolean(requestedIsAlive) == !timeout) {
            if (lastKeepaliveTimestamp > 0L) {
                fStamp.put("KeepaliveTimeout", new Boolean(timeout));
                fStamp.put("KeepaliveTimestamp", new Long(lastKeepaliveTimestamp));
            }
            return true;
        }
        return false;
    }

    private boolean matchFilterOnlinestate(List reqOnlinestates, String requestedIsAliveTimeout, long now, HashMap originalStamp, HashMap filteredStamp, long unitId, String unitName) {
        if (reqOnlinestates.size() == 0) {
            return true;
        }
        String method = "matchFilterOnlinestate: ";
        boolean onlineStateExist = true;
        long onlineState = 0L;
        long stateTimestamp = 0L;
        Object oVal = this.getStampValue(originalStamp, "InfomanOnlineState", true);
        if (oVal != null) {
            onlineState = (Long)oVal;
            oVal = this.getStampValue(originalStamp, "InfomanOnlineStateBegin");
            stateTimestamp = (Long)oVal;
        } else {
            onlineStateExist = false;
        }
        if (!onlineStateExist || onlineState != 2111L) {
            oVal = this.getStampValue(originalStamp, "KeepaliveTimestamp");
            if (oVal == null) {
                onlineState = 2112L;
            } else {
                stateTimestamp = (Long)oVal;
                if (stateTimestamp == 0L) {
                    onlineState = 2112L;
                } else if (requestedIsAliveTimeout != null) {
                    long requestedTimeout = Long.parseLong(requestedIsAliveTimeout);
                    onlineState = now - stateTimestamp > requestedTimeout ? 2113L : 2112L;
                } else {
                    oVal = this.getStampValue(originalStamp, "KeepaliveTimeout");
                    if (oVal != null) {
                        onlineState = ((Boolean)oVal).booleanValue() ? 2113L : 2112L;
                    } else {
                        log.error((Object)(method + "MapClientStamp: key '" + "KeepaliveTimestamp" + "' exists in stamp, but '" + "KeepaliveTimeout" + "' is missing !"));
                        onlineState = 2112L;
                    }
                }
            }
        }
        if (reqOnlinestates.contains(Long.toString(onlineState))) {
            if (stateTimestamp > 0L) {
                filteredStamp.put("InfomanOnlineState", new Long(onlineState));
                filteredStamp.put("InfomanOnlineStateBegin", new Long(stateTimestamp));
            }
            return true;
        }
        return false;
    }

    private HashMap<Long, HashMap<String, Object>> fastCopy(Set<HashMap<String, Object>> allStamps) {
        String method = "fastCopy(): ";
        HashMap<Long, HashMap<String, Object>> copiedStamps = new HashMap<Long, HashMap<String, Object>>();
        int stampNo = 0;
        Iterator<HashMap<String, Object>> it = allStamps.iterator();
        while (it.hasNext()) {
            ++stampNo;
            HashMap<String, Object> singleStamp = it.next();
            if (singleStamp == null) {
                log.error((Object)(method + "Set 'allStamps' contain a stamp=null!, stampNo=" + stampNo + ", allStamps.size=" + allStamps.size()));
                continue;
            }
            Object oVal = this.getStampValue(singleStamp, "UnitId");
            if (oVal == null) {
                log.error((Object)(method + " singleStamp does not contain an unit ID!"));
                continue;
            }
            copiedStamps.put((Long)oVal, singleStamp);
        }
        return copiedStamps;
    }

    private void markStamps(Map stamps, boolean marker) {
        for (HashMap singleStamp : stamps.values()) {
            singleStamp.put("FilterPassed", marker);
        }
    }
}

