/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.options.generaleditor.Model;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeneralEditorPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private boolean listen = false;
    private JCheckBox cbCamelCaseBehavior;
    private JCheckBox cbFoldImports;
    private JCheckBox cbFoldInitialComments;
    private JCheckBox cbFoldInnerClasses;
    private JCheckBox cbFoldJavadocComments;
    private JCheckBox cbFoldMethods;
    private JCheckBox cbFoldTags;
    private JCheckBox cbUseCodeFolding;
    private JComboBox cboEditorSearchType;
    private JComboBox cboRemoveTrailingWhitespace;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JLabel lCamelCaseBehavior;
    private JLabel lCamelCaseBehaviorExample;
    private JLabel lCodeFolding;
    private JLabel lCollapseByDefault;
    private JLabel lEditorSearchType;
    private JLabel lRemoveTrailingWhitespace;
    private JLabel lSearch;
    private JLabel lSearchtypeTooltip;
    private JLabel lUseCodeFolding;
    private JLabel lWhenSavingFiles;
    private Model model;

    public GeneralEditorPanel() {
        this.initComponents();
        GeneralEditorPanel.loc(this.lCodeFolding, "Code_Folding");
        GeneralEditorPanel.loc(this.lUseCodeFolding, "Code_Folding_Section");
        GeneralEditorPanel.loc(this.lCollapseByDefault, "Fold_by_Default");
        GeneralEditorPanel.loc(this.cbUseCodeFolding, "Use_Folding");
        GeneralEditorPanel.loc(this.cbFoldMethods, "Fold_Methods");
        GeneralEditorPanel.loc(this.cbFoldInnerClasses, "Fold_Classes");
        GeneralEditorPanel.loc(this.cbFoldImports, "Fold_Imports");
        GeneralEditorPanel.loc(this.cbFoldJavadocComments, "Fold_JavaDoc");
        GeneralEditorPanel.loc(this.cbFoldInitialComments, "Fold_Licence");
        GeneralEditorPanel.loc(this.cbFoldTags, "Fold_Tags");
        GeneralEditorPanel.loc(this.lCamelCaseBehavior, "Camel_Case_Behavior");
        GeneralEditorPanel.loc(this.cbCamelCaseBehavior, "Enable_Camel_Case_In_Java");
        GeneralEditorPanel.loc(this.lCamelCaseBehaviorExample, "Camel_Case_Behavior_Example");
        GeneralEditorPanel.loc(this.lWhenSavingFiles, "When_Saving_Files");
        GeneralEditorPanel.loc(this.lRemoveTrailingWhitespace, "Remove_Trailing_Whitespace");
        GeneralEditorPanel.loc(this.cboRemoveTrailingWhitespace, "Remove_Trailing_Whitespace");
        GeneralEditorPanel.loc(this.lSearch, "Search");
        GeneralEditorPanel.loc(this.lEditorSearchType, "Editor_Search_Type");
        GeneralEditorPanel.loc(this.cboEditorSearchType, "Editor_Search_Type");
        this.cbUseCodeFolding.setMnemonic(NbBundle.getMessage(GeneralEditorPanel.class, (String)"MNEMONIC_Use_Folding").charAt(0));
        this.cboRemoveTrailingWhitespace.setRenderer(new RemoveTrailingWhitespaceRenderer(this.cboRemoveTrailingWhitespace.getRenderer()));
        this.cboRemoveTrailingWhitespace.setModel(new DefaultComboBoxModel<Object>(new Object[]{"never", "always", "modified-lines"}));
        this.cboEditorSearchType.setRenderer(new EditorSearchTypeRenderer(this.cboEditorSearchType.getRenderer()));
        this.cboEditorSearchType.setModel(new DefaultComboBoxModel<Object>(new Object[]{"default", "closing"}));
        this.cboEditorSearchType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneralEditorPanel.this.cboEditorSearchType.getSelectedItem().equals("default")) {
                    Mnemonics.setLocalizedText((JLabel)GeneralEditorPanel.this.lSearchtypeTooltip, (String)NbBundle.getMessage(GeneralEditorPanel.class, (String)"Editor_Search_Type_Tooltip_default"));
                } else {
                    Mnemonics.setLocalizedText((JLabel)GeneralEditorPanel.this.lSearchtypeTooltip, (String)NbBundle.getMessage(GeneralEditorPanel.class, (String)"Editor_Search_Type_Tooltip_closing"));
                }
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lSearchtypeTooltip, (String)NbBundle.getMessage(GeneralEditorPanel.class, (String)"Editor_Search_Type_Tooltip_closing"));
    }

    private void initComponents() {
        this.lCodeFolding = new JLabel();
        this.lUseCodeFolding = new JLabel();
        this.lCollapseByDefault = new JLabel();
        this.cbUseCodeFolding = new JCheckBox();
        this.cbFoldMethods = new JCheckBox();
        this.cbFoldInnerClasses = new JCheckBox();
        this.cbFoldImports = new JCheckBox();
        this.cbFoldJavadocComments = new JCheckBox();
        this.cbFoldInitialComments = new JCheckBox();
        this.cbFoldTags = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.lCamelCaseBehavior = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.cbCamelCaseBehavior = new JCheckBox();
        this.lCamelCaseBehaviorExample = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.lWhenSavingFiles = new JLabel();
        this.lRemoveTrailingWhitespace = new JLabel();
        this.cboRemoveTrailingWhitespace = new JComboBox();
        this.lEditorSearchType = new JLabel();
        this.jSeparator5 = new JSeparator();
        this.lSearch = new JLabel();
        this.cboEditorSearchType = new JComboBox();
        this.lSearchtypeTooltip = new JLabel();
        this.setForeground(new Color(99, 130, 191));
        this.lCodeFolding.setText("Code Folding");
        this.lUseCodeFolding.setLabelFor(this.cbUseCodeFolding);
        this.lUseCodeFolding.setText("Use Code Folding:");
        this.lCollapseByDefault.setText("Collapse by Default:");
        this.cbFoldMethods.setText("Methods");
        this.cbFoldInnerClasses.setText("Inner Classes");
        this.cbFoldImports.setText("Imports");
        this.cbFoldJavadocComments.setText("Javadoc Comments");
        this.cbFoldInitialComments.setText("Initial Comments");
        this.cbFoldTags.setText("Tags and Other Code Blocks");
        this.lCamelCaseBehavior.setText("Camel Case  Behavior");
        this.cbCamelCaseBehavior.setText("Enable Camel Case Navigation");
        this.lCamelCaseBehaviorExample.setText("<html>Example: Caret stops at J, T, N in \"JavaTypeName\"<br>when using next/previous word acctions</html>");
        this.lWhenSavingFiles.setText("When Saving Files");
        this.lRemoveTrailingWhitespace.setLabelFor(this.cboRemoveTrailingWhitespace);
        this.lRemoveTrailingWhitespace.setText("Remove Trailing Whitespace:");
        this.cboRemoveTrailingWhitespace.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lEditorSearchType.setLabelFor(this.cboRemoveTrailingWhitespace);
        this.lEditorSearchType.setText("Editor Search Type:");
        this.lSearch.setText("Search");
        this.cboEditorSearchType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lSearchtypeTooltip.setText("<html>In Closing type Enter accepts search match, Esc jumps to start. Both close searchbar. <br /> Default type closes searchbar by Esc or button. Enter means find a new instance.</html>");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lWhenSavingFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4)).addGroup(layout.createSequentialGroup().addComponent(this.lCamelCaseBehavior).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3)).addGroup(layout.createSequentialGroup().addComponent(this.lCodeFolding).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addComponent(this.lCollapseByDefault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbFoldMethods).addComponent(this.cbFoldInnerClasses).addComponent(this.cbFoldImports).addComponent(this.cbUseCodeFolding)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbFoldJavadocComments).addComponent(this.cbFoldInitialComments).addComponent(this.cbFoldTags))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lUseCodeFolding).addComponent(this.lRemoveTrailingWhitespace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lCamelCaseBehaviorExample, -2, -1, -2).addComponent(this.cboRemoveTrailingWhitespace, -2, -1, -2))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(155, 155, 155).addComponent(this.cbCamelCaseBehavior))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap(24, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lEditorSearchType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lSearchtypeTooltip, -2, -1, -2).addComponent(this.cboEditorSearchType, -2, -1, -2)).addContainerGap()));
        layout.linkSize(0, this.cbFoldImports, this.cbFoldInitialComments, this.cbFoldInnerClasses, this.cbFoldJavadocComments, this.cbFoldMethods);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lCodeFolding).addComponent(this.jSeparator1, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbUseCodeFolding).addComponent(this.lUseCodeFolding)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lCollapseByDefault).addComponent(this.cbFoldMethods).addComponent(this.cbFoldJavadocComments)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbFoldInnerClasses).addComponent(this.cbFoldInitialComments)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbFoldImports).addComponent(this.cbFoldTags)).addGap(18, 18, 18).addComponent(this.jSeparator3, -2, 10, -2)).addComponent(this.lCamelCaseBehavior)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.cbCamelCaseBehavior).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lCamelCaseBehaviorExample, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSeparator4, -2, 10, -2)).addComponent(this.lWhenSavingFiles)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lRemoveTrailingWhitespace).addComponent(this.cboRemoveTrailingWhitespace, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lSearch).addComponent(this.jSeparator5, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lEditorSearchType).addComponent(this.cboEditorSearchType, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lSearchtypeTooltip, -2, -1, -2).addContainerGap(33, Short.MAX_VALUE)));
    }

    private static String loc(String key) {
        return NbBundle.getMessage(GeneralEditorPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(GeneralEditorPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(GeneralEditorPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)GeneralEditorPanel.loc("CTL_" + key));
        } else if (c instanceof JLabel) {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)GeneralEditorPanel.loc("CTL_" + key));
        }
    }

    void update() {
        this.listen = false;
        if (this.model == null) {
            this.model = new Model();
            this.cbUseCodeFolding.addActionListener(this);
            this.cbFoldMethods.addActionListener(this);
            this.cbFoldInnerClasses.addActionListener(this);
            this.cbFoldImports.addActionListener(this);
            this.cbFoldJavadocComments.addActionListener(this);
            this.cbFoldInitialComments.addActionListener(this);
            this.cbCamelCaseBehavior.addActionListener(this);
            this.cbFoldTags.addActionListener(this);
            this.cboRemoveTrailingWhitespace.addActionListener(this);
            this.cboEditorSearchType.addActionListener(this);
        }
        this.cbUseCodeFolding.setSelected(this.model.isShowCodeFolding());
        this.cbFoldImports.setSelected(this.model.isFoldImports());
        this.cbFoldInitialComments.setSelected(this.model.isFoldInitialComment());
        this.cbFoldInnerClasses.setSelected(this.model.isFoldInnerClasses());
        this.cbFoldJavadocComments.setSelected(this.model.isFoldJavaDocComments());
        this.cbFoldMethods.setSelected(this.model.isFoldMethods());
        this.cbFoldTags.setSelected(this.model.isFoldTag());
        Boolean ccJava = this.model.isCamelCaseJavaNavigation();
        if (ccJava == null) {
            this.cbCamelCaseBehavior.setEnabled(false);
            this.cbCamelCaseBehavior.setSelected(false);
        } else {
            this.cbCamelCaseBehavior.setEnabled(true);
            this.cbCamelCaseBehavior.setSelected(ccJava);
        }
        this.cboRemoveTrailingWhitespace.setSelectedItem(this.model.getRemoveTrailingWhitespace());
        this.cboEditorSearchType.setSelectedItem(this.model.getEditorSearchType());
        this.updateEnabledState();
        this.listen = true;
    }

    void applyChanges() {
        if (this.model == null || !this.changed) {
            return;
        }
        this.model.setFoldingOptions(this.cbUseCodeFolding.isSelected(), this.cbFoldImports.isSelected(), this.cbFoldInitialComments.isSelected(), this.cbFoldInnerClasses.isSelected(), this.cbFoldJavadocComments.isSelected(), this.cbFoldMethods.isSelected(), this.cbFoldTags.isSelected());
        this.model.setCamelCaseNavigation(this.cbCamelCaseBehavior.isSelected());
        this.model.setRemoveTrailingWhitespace((String)this.cboRemoveTrailingWhitespace.getSelectedItem());
        this.model.setEditorSearchType((String)this.cboEditorSearchType.getSelectedItem());
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.cbUseCodeFolding) {
            this.updateEnabledState();
        }
        this.changed = true;
    }

    private void updateEnabledState() {
        boolean useCodeFolding = this.cbUseCodeFolding.isSelected();
        this.cbFoldImports.setEnabled(useCodeFolding);
        this.cbFoldInitialComments.setEnabled(useCodeFolding);
        this.cbFoldInnerClasses.setEnabled(useCodeFolding);
        this.cbFoldJavadocComments.setEnabled(useCodeFolding);
        this.cbFoldMethods.setEnabled(useCodeFolding);
        this.cbFoldTags.setEnabled(useCodeFolding);
    }

    private static final class EditorSearchTypeRenderer
    implements ListCellRenderer {
        private final ListCellRenderer defaultRenderer;

        public EditorSearchTypeRenderer(ListCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defaultRenderer.getListCellRendererComponent(list, NbBundle.getMessage(GeneralEditorPanel.class, (String)("EST_" + value)), index, isSelected, cellHasFocus);
        }
    }

    private static final class RemoveTrailingWhitespaceRenderer
    implements ListCellRenderer {
        private final ListCellRenderer defaultRenderer;

        public RemoveTrailingWhitespaceRenderer(ListCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defaultRenderer.getListCellRendererComponent(list, NbBundle.getMessage(GeneralEditorPanel.class, (String)("RTW_" + value)), index, isSelected, cellHasFocus);
        }
    }
}

