/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.UninstallationException;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.progress.CompositeProgress;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class UninstallAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(UninstallAction.class, "UA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(UninstallAction.class, "UA.description");
    public static final String DEFAULT_PROGRESS_UNINSTALL_TITLE_MESSAGE = ResourceUtils.getString(UninstallAction.class, "UA.progress.uninstall.title");
    public static final String DEFAULT_UNINSTALL_DEPENDENT_FAILED_MESSAGE = ResourceUtils.getString(UninstallAction.class, "UA.uninstall.dependent.failed");
    public static final String PROGRESS_UNINSTALL_TITLE_PROPERTY = "progress.uninstall.title";
    public static final String UNINSTALL_DEPENDENT_FAILED_PROPERTY = "uninstall.dependent.failed";
    public static final int UNINSTALLATION_ERROR_CODE = 126;
    private CompositeProgress overallProgress;
    private Progress currentProgress;

    public UninstallAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(PROGRESS_UNINSTALL_TITLE_PROPERTY, DEFAULT_PROGRESS_UNINSTALL_TITLE_MESSAGE);
        this.setProperty(UNINSTALL_DEPENDENT_FAILED_PROPERTY, DEFAULT_UNINSTALL_DEPENDENT_FAILED_MESSAGE);
    }

    @Override
    public void execute() {
        LogManager.logIndent("Start products uninstallation");
        Registry registry = Registry.getInstance();
        List<Product> products = registry.getProductsToUninstall();
        int percentageChunk = 100 / products.size();
        int percentageLeak = 100 % products.size();
        this.overallProgress = new CompositeProgress();
        this.overallProgress.setPercentage(percentageLeak);
        this.overallProgress.synchronizeDetails(true);
        this.getWizardUi().setProgress(this.overallProgress);
        for (int i = 0; i < products.size(); ++i) {
            Product product = products.get(i);
            this.currentProgress = new Progress();
            this.overallProgress.addChild(this.currentProgress, percentageChunk);
            this.overallProgress.setTitle(StringUtils.format(this.getProperty(PROGRESS_UNINSTALL_TITLE_PROPERTY), product.getDisplayName()));
            try {
                product.uninstall(this.currentProgress);
                SystemUtils.sleep(200L);
                continue;
            }
            catch (UninstallationException e) {
                if (System.getProperties().get("nbi.exit.code") == null) {
                    System.getProperties().put("nbi.exit.code", new Integer(126));
                }
                product.setStatus(Status.INSTALLED);
                product.setUninstallationError(e);
                for (Product requirement : registry.getProducts()) {
                    if (requirement.getStatus() != Status.TO_BE_UNINSTALLED || !registry.satisfiesRequirement(requirement, product)) continue;
                    UninstallationException requirementError = new UninstallationException(StringUtils.format(this.getProperty(PROGRESS_UNINSTALL_TITLE_PROPERTY), requirement.getDisplayName(), product.getDisplayName()), e);
                    requirement.setStatus(Status.INSTALLED);
                    requirement.setUninstallationError(requirementError);
                    products.remove(requirement);
                }
                ErrorManager.notify(1, (Throwable)e);
            }
        }
        LogManager.logUnindent("... finished products uninstallation");
    }

    @Override
    public boolean canExecuteForward() {
        return Registry.getInstance().getProductsToUninstall().size() > 0;
    }

    @Override
    public boolean isPointOfNoReturn() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }
}

