/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.NetworkUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.ApplicationDescriptor;
import org.netbeans.installer.utils.helper.EnvironmentScope;
import org.netbeans.installer.utils.helper.ExecutionResults;
import org.netbeans.installer.utils.helper.FilesList;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.ShortcutLocationType;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.NativeUtils;
import org.netbeans.installer.utils.system.NativeUtilsFactory;
import org.netbeans.installer.utils.system.launchers.Launcher;
import org.netbeans.installer.utils.system.launchers.LauncherFactory;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.resolver.StringResolverUtil;
import org.netbeans.installer.utils.system.shortcut.LocationType;
import org.netbeans.installer.utils.system.shortcut.Shortcut;

public final class SystemUtils {
    private static Map<String, String> environment = new ProcessBuilder(new String[0]).environment();
    private static NativeUtils nativeUtils;
    public static final long MAX_EXECUTION_TIME = 600000L;
    public static final int MAX_DELAY = 50;
    public static final int INITIAL_DELAY = 5;
    public static final int DELTA_DELAY = 5;
    public static final String LINE_SEPARATOR;
    public static final String FILE_SEPARATOR;
    public static final String PATH_SEPARATOR;
    public static final String JAVA_HOME;
    public static final String USER_HOME;
    public static final String NO_SPACE_CHECK_PROPERTY = "no.space.check";

    public static String resolveString(String string) {
        return SystemUtils.resolveString(string, SystemUtils.class.getClassLoader());
    }

    public static String resolveString(String string, ClassLoader loader) {
        return StringResolverUtil.resolve(string, loader);
    }

    public static File resolvePath(String string) {
        return SystemUtils.resolvePath(string, SystemUtils.class.getClassLoader());
    }

    public static File resolvePath(String path, ClassLoader loader) {
        String separator = SystemUtils.getFileSeparator();
        String parsed = SystemUtils.resolveString(path, loader);
        parsed = parsed.replace("\\", separator);
        parsed = parsed.replace("/", separator);
        try {
            if (parsed.contains(separator + ".." + separator) || parsed.contains(separator + "." + separator) || parsed.endsWith(separator + "..") || parsed.endsWith(separator + ".")) {
                return new File(parsed).getCanonicalFile();
            }
        }
        catch (IOException e) {
            ErrorManager.notifyDebug("Could not get the cannonical path", e);
        }
        return new File(parsed).getAbsoluteFile();
    }

    @Deprecated
    public static File getUserHomeDirectory() {
        return new File(USER_HOME);
    }

    public static File getDefaultUserdirRoot() {
        String root = System.getProperty("netbeans.default_userdir_root", null);
        if (root != null && root.isEmpty()) {
            return new File(root);
        }
        return null;
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static boolean isCurrentUserAdmin() throws NativeException {
        return SystemUtils.getNativeUtils().isCurrentUserAdmin();
    }

    public static File getCurrentDirectory() {
        return new File(".");
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getDefaultApplicationsLocation() throws NativeException {
        return SystemUtils.getNativeUtils().getDefaultApplicationsLocation();
    }

    public static File getCurrentJavaHome() {
        return new File(JAVA_HOME);
    }

    public static boolean isCurrentJava64Bit() {
        String osArch = System.getProperty("os.arch");
        return "64".equals(System.getProperty("sun.arch.data.model")) || "64".equals(System.getProperty("com.ibm.vm.bitmode")) || osArch.equals("ia64") || osArch.toLowerCase(Locale.ENGLISH).equals("ia64w") || osArch.equals("PA_RISC2.0W") || osArch.equals("amd64") || osArch.equals("sparcv9") || osArch.equals("x86_64") || osArch.equals("ppc64");
    }

    public static File getPacker() {
        if (SystemUtils.isWindows()) {
            return new File(SystemUtils.getCurrentJavaHome(), "bin/pack200.exe");
        }
        return new File(SystemUtils.getCurrentJavaHome(), "bin/pack200");
    }

    public static File getUnpacker() {
        if (SystemUtils.isWindows()) {
            return new File(SystemUtils.getCurrentJavaHome(), "bin/unpack200.exe");
        }
        return new File(SystemUtils.getCurrentJavaHome(), "bin/unpack200");
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public static String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public static long getFreeSpace(File file) throws NativeException {
        File directory;
        for (directory = file; !(directory == null || directory.exists() && directory.isDirectory()); directory = directory.getParentFile()) {
        }
        long space = SystemUtils.getNativeUtils().getFreeSpace(directory);
        return space;
    }

    public static ExecutionResults executeCommand(String ... command) throws IOException {
        return SystemUtils.executeCommand(null, null, null, command);
    }

    public static ExecutionResults executeCommand(File workingDirectory, String ... command) throws IOException {
        return SystemUtils.executeCommand(null, null, workingDirectory, command);
    }

    public static ExecutionResults executeCommand(Progress progress, String[] supportedPrefixes, File workingDirectory, String ... command) throws IOException {
        String commandString = StringUtils.asString(command, " ");
        if (supportedPrefixes == null) {
            supportedPrefixes = new String[]{};
        }
        if (workingDirectory == null) {
            workingDirectory = SystemUtils.getCurrentDirectory();
        }
        LogManager.log(3, "executing command: " + commandString + ", in directory: " + workingDirectory);
        LogManager.indent();
        StringBuilder processStdOut = new StringBuilder();
        StringBuilder processStdErr = new StringBuilder();
        int errorLevel = Integer.MAX_VALUE;
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDirectory);
        builder.environment().clear();
        builder.environment().putAll(environment);
        SystemUtils.setDefaultEnvironment();
        Process process = builder.start();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 600000L;
        boolean doRun = true;
        long delay = 5L;
        while (doRun && System.currentTimeMillis() < endTime) {
            String line;
            BufferedReader reader;
            try {
                Thread.sleep(delay);
                if (delay < 50L) {
                    delay += 5L;
                }
            }
            catch (InterruptedException e) {
                ErrorManager.notifyDebug("Interrupted", e);
            }
            try {
                errorLevel = process.exitValue();
                doRun = false;
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            String string = StringUtils.readStream(process.getInputStream());
            if (string.length() > 0) {
                reader = new BufferedReader(new StringReader(string));
                line = reader.readLine();
                while (line != null) {
                    if (progress != null && !line.trim().isEmpty()) {
                        progress.setDetail(line);
                    }
                    LogManager.log(3, "[stdout]: " + line);
                    endTime = System.currentTimeMillis() + 600000L;
                    line = reader.readLine();
                }
                processStdOut.append(string);
            }
            if ((string = StringUtils.readStream(process.getErrorStream())).length() <= 0) continue;
            reader = new BufferedReader(new StringReader(string));
            line = reader.readLine();
            while (line != null) {
                if (progress != null && !(line = line.trim()).isEmpty()) {
                    for (String prefix : supportedPrefixes) {
                        if (!line.startsWith(prefix)) continue;
                        progress.setDetail(line.substring(prefix.length()));
                    }
                }
                LogManager.log(3, "[stderr]: " + line);
                endTime = System.currentTimeMillis() + 600000L;
                line = reader.readLine();
            }
            processStdErr.append(string);
        }
        LogManager.log(3, doRun ? "[return]: killed by timeout" : "[return]: " + errorLevel);
        process.destroy();
        LogManager.unindent();
        LogManager.log(3, "... command execution finished");
        return new ExecutionResults(errorLevel, processStdOut.toString(), processStdErr.toString());
    }

    public static boolean isPathValid(String path) {
        return SystemUtils.getNativeUtils().isPathValid(path);
    }

    public static boolean isPortAvailable(int port, int ... forbiddenPorts) {
        return NetworkUtils.isPortAvailable(port, forbiddenPorts);
    }

    public static int getAvailablePort(int basePort, int ... forbiddenPorts) {
        return NetworkUtils.getAvailablePort(basePort, forbiddenPorts);
    }

    public static boolean isDeletingAllowed(File file) {
        return SystemUtils.getNativeUtils().isDeletingAllowed(file);
    }

    @Deprecated
    private static LocationType toLocationType(ShortcutLocationType type) {
        LocationType tp = null;
        switch (type) {
            case CURRENT_USER_DESKTOP: {
                tp = LocationType.CURRENT_USER_DESKTOP;
                break;
            }
            case CURRENT_USER_START_MENU: {
                tp = LocationType.CURRENT_USER_START_MENU;
                break;
            }
            case ALL_USERS_DESKTOP: {
                tp = LocationType.ALL_USERS_DESKTOP;
                break;
            }
            case ALL_USERS_START_MENU: {
                tp = LocationType.ALL_USERS_START_MENU;
            }
        }
        return tp;
    }

    @Deprecated
    public static File getShortcutLocation(org.netbeans.installer.utils.helper.Shortcut shortcut, ShortcutLocationType locationType) throws NativeException {
        return SystemUtils.getNativeUtils().getShortcutLocation(shortcut, SystemUtils.toLocationType(locationType));
    }

    @Deprecated
    public static File createShortcut(org.netbeans.installer.utils.helper.Shortcut shortcut, ShortcutLocationType locationType) throws NativeException {
        return SystemUtils.getNativeUtils().createShortcut(shortcut, SystemUtils.toLocationType(locationType));
    }

    @Deprecated
    public static void removeShortcut(org.netbeans.installer.utils.helper.Shortcut shortcut, ShortcutLocationType locationType, boolean deleteEmptyParents) throws NativeException {
        SystemUtils.getNativeUtils().removeShortcut(shortcut, SystemUtils.toLocationType(locationType), deleteEmptyParents);
    }

    public static File getShortcutLocation(Shortcut shortcut, LocationType locationType) throws NativeException {
        return SystemUtils.getNativeUtils().getShortcutLocation(shortcut, locationType);
    }

    public static File createShortcut(Shortcut shortcut, LocationType locationType) throws NativeException {
        return SystemUtils.getNativeUtils().createShortcut(shortcut, locationType);
    }

    public static void removeShortcut(Shortcut shortcut, LocationType locationType, boolean deleteEmptyParents) throws NativeException {
        SystemUtils.getNativeUtils().removeShortcut(shortcut, locationType, deleteEmptyParents);
    }

    public static FilesList addComponentToSystemInstallManager(ApplicationDescriptor descriptor) throws NativeException {
        return SystemUtils.getNativeUtils().addComponentToSystemInstallManager(descriptor);
    }

    public static void removeComponentFromSystemInstallManager(ApplicationDescriptor descriptor) throws NativeException {
        SystemUtils.getNativeUtils().removeComponentFromSystemInstallManager(descriptor);
    }

    public static String getEnvironmentVariable(String name) throws NativeException {
        return SystemUtils.getEnvironmentVariable(name, EnvironmentScope.PROCESS, true);
    }

    public static String getEnvironmentVariable(String name, EnvironmentScope scope, boolean expand) throws NativeException {
        return SystemUtils.getNativeUtils().getEnvironmentVariable(name, scope, expand);
    }

    public static void setEnvironmentVariable(String name, String value) throws NativeException {
        SystemUtils.setEnvironmentVariable(name, value, EnvironmentScope.PROCESS, true);
    }

    public static void setEnvironmentVariable(String name, String value, EnvironmentScope scope, boolean expand) throws NativeException {
        SystemUtils.getNativeUtils().setEnvironmentVariable(name, value, scope, expand);
    }

    public static List<File> findIrrelevantFiles(File parent) throws IOException {
        return SystemUtils.getNativeUtils().findIrrelevantFiles(parent);
    }

    public static List<File> findIrrelevantFiles(File ... parents) throws IOException {
        LinkedList<File> list = new LinkedList<File>();
        for (File parent : parents) {
            list.addAll(SystemUtils.findIrrelevantFiles(parent));
        }
        return list;
    }

    public static void removeIrrelevantFiles(File parent) throws IOException {
        FileUtils.deleteFiles(SystemUtils.findIrrelevantFiles(parent));
    }

    public static void removeIrrelevantFiles(File ... parents) throws IOException {
        for (File file : parents) {
            SystemUtils.removeIrrelevantFiles(file);
        }
    }

    public static List<File> findExecutableFiles(File parent) throws IOException {
        return SystemUtils.getNativeUtils().findExecutableFiles(parent);
    }

    public static List<File> findExecutableFiles(File ... parents) throws IOException {
        LinkedList<File> list = new LinkedList<File>();
        for (File parent : parents) {
            list.addAll(SystemUtils.findExecutableFiles(parent));
        }
        return list;
    }

    public static void correctFilesPermissions(File parent) throws IOException {
        SystemUtils.getNativeUtils().correctFilesPermissions(parent);
    }

    public static void correctFilesPermissions(File ... parents) throws IOException {
        for (File file : parents) {
            SystemUtils.correctFilesPermissions(file);
        }
    }

    public static void setPermissions(File file, int mode, int change) throws IOException {
        SystemUtils.getNativeUtils().setPermissions(file, mode, change);
    }

    public static int getPermissions(File file) throws IOException {
        return SystemUtils.getNativeUtils().getPermissions(file);
    }

    public static Launcher createLauncher(LauncherProperties props, Progress progress) throws IOException {
        return SystemUtils.createLauncher(props, SystemUtils.getCurrentPlatform(), progress);
    }

    public static Launcher createLauncher(LauncherProperties props, Platform platform, Progress progress) throws IOException {
        Progress prg = progress == null ? new Progress() : progress;
        LogManager.log("Create native launcher for " + platform.toString());
        Launcher launcher = null;
        try {
            LogManager.indent();
            launcher = LauncherFactory.newLauncher(props, platform);
            long start = System.currentTimeMillis();
            launcher.initialize();
            launcher.create(prg);
            long seconds = System.currentTimeMillis() - start;
            LogManager.unindent();
            LogManager.log("[launcher] Time : " + seconds / 1000L + "." + seconds % 1000L + " seconds");
        }
        catch (IOException e) {
            LogManager.unindent();
            LogManager.log("[launcher] Build failed with the following exception :");
            LogManager.log(e);
            throw e;
        }
        return launcher;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            ErrorManager.notify(4, "Interrupted while sleeping", e);
        }
    }

    public static void setDefaultEnvironment() {
        environment = new ProcessBuilder(new String[0]).environment();
    }

    public static Map<String, String> getEnvironment() {
        return environment;
    }

    public static Platform getCurrentPlatform() {
        return SystemUtils.getNativeUtils().getCurrentPlatform();
    }

    public static String getHostName() {
        return NetworkUtils.getHostName();
    }

    public static List<File> getFileSystemRoots(String ... files) throws IOException {
        return SystemUtils.getNativeUtils().getFileSystemRoots(files);
    }

    public static boolean isWindows() {
        return SystemUtils.getCurrentPlatform().isCompatibleWith(Platform.WINDOWS);
    }

    public static boolean isMacOS() {
        return SystemUtils.getCurrentPlatform().isCompatibleWith(Platform.MACOSX);
    }

    public static boolean isLinux() {
        return SystemUtils.getCurrentPlatform().isCompatibleWith(Platform.LINUX);
    }

    public static boolean isSolaris() {
        return SystemUtils.getCurrentPlatform().isCompatibleWith(Platform.SOLARIS);
    }

    public static boolean isUnix() {
        return SystemUtils.getCurrentPlatform().isCompatibleWith(Platform.UNIX);
    }

    public static boolean intersects(List<? extends Object> list1, List<? extends Object> list2) {
        for (int i = 0; i < list1.size(); ++i) {
            for (int j = 0; j < list2.size(); ++j) {
                if (!list1.get(i).equals(list2.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> List<T> intersect(List<? extends T> list1, List<? extends T> list2) {
        LinkedList<T> intersection = new LinkedList<T>();
        for (T item : list1) {
            if (!list2.contains(item)) continue;
            intersection.add(item);
        }
        return intersection;
    }

    public static <T> List<T> substract(List<? extends T> list1, List<? extends T> list2) {
        LinkedList<T> result = new LinkedList<T>();
        for (T item1 : list1) {
            boolean found = false;
            for (T item2 : list2) {
                if (!item1.equals(item2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(item1);
        }
        return result;
    }

    public static synchronized NativeUtils getNativeUtils() {
        if (nativeUtils == null) {
            nativeUtils = NativeUtilsFactory.newNativeUtils();
        }
        return nativeUtils;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        FILE_SEPARATOR = System.getProperty("file.separator");
        PATH_SEPARATOR = System.getProperty("path.separator");
        JAVA_HOME = System.getProperty("java.home");
        USER_HOME = System.getProperty("user.home");
    }
}

