/*
 * Decompiled with CFR 0.152.
 */
package org.mycompany.installer.wizard.components.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.wizard.components.panels.ErrorMessagePanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class WelcomePanel
extends ErrorMessagePanel {
    private Registry bundledRegistry;
    private Registry defaultRegistry;
    public static final String DEFAULT_TITLE = ResourceUtils.getString(WelcomePanel.class, "WP.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(WelcomePanel.class, "WP.description");
    public static final String WELCOME_TEXT_PROPERTY = "welcome.text";
    public static final String WELCOME_ALREADY_INSTALLED_TEXT_PROPERTY = "welcome.already.installed.text";
    public static final String WELCOME_ALREADY_INSTALLED_NEXT_BUTTON_TEXT_PROPERTY = "welcome.already.installed.next.button.text";
    public static final String WELCOME_INCOMPATIBLE_PLATFORM_TEXT = ResourceUtils.getString(WelcomePanel.class, "WP.incompatible.platform.text");
    public static final String DEFAULT_WELCOME_ALREADY_INSTALLED_NEXT_BUTTON_TEXT = ResourceUtils.getString(WelcomePanel.class, "WP.already.installed.next.button.text");
    public static final String DEFAULT_WELCOME_TEXT = ResourceUtils.getString(WelcomePanel.class, "WP.welcome.text");
    public static final String DEFAULT_WELCOME_ALREADY_INSTALLED_TEXT = ResourceUtils.getString(WelcomePanel.class, "WP.already.installed.text");
    public static final String WELCOME_PAGE_LEFT_TOP_IMAGE_PROPERTY = "nbi.wizard.ui.swing.welcome.left.top.image";
    public static final String WELCOME_PAGE_LEFT_BOTTOM_IMAGE_PROPERTY = "nbi.wizard.ui.swing.welcome.left.bottom.image";

    public WelcomePanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(WELCOME_TEXT_PROPERTY, DEFAULT_WELCOME_TEXT);
        this.setProperty(WELCOME_ALREADY_INSTALLED_TEXT_PROPERTY, DEFAULT_WELCOME_ALREADY_INSTALLED_TEXT);
        this.setProperty(WELCOME_ALREADY_INSTALLED_NEXT_BUTTON_TEXT_PROPERTY, DEFAULT_WELCOME_ALREADY_INSTALLED_NEXT_BUTTON_TEXT);
        try {
            this.defaultRegistry = Registry.getInstance();
            this.bundledRegistry = new Registry();
            String bundledRegistryUri = System.getProperty("nbi.product.bundled.registry.uri");
            if (bundledRegistryUri != null) {
                this.bundledRegistry.loadProductRegistry(bundledRegistryUri);
            } else {
                this.bundledRegistry.loadProductRegistry("resource:data/registry.xml");
            }
        }
        catch (InitializationException e) {
            ErrorManager.notifyError("Cannot load bundled registry", e);
        }
    }

    Registry getBundledRegistry() {
        return this.bundledRegistry;
    }

    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new WelcomePanelUi(this);
        }
        return this.wizardUi;
    }

    public boolean canExecuteForward() {
        return this.canExecute();
    }

    public boolean canExecuteBackward() {
        return this.canExecute();
    }

    private boolean canExecute() {
        return this.bundledRegistry.getNodes().size() > 1;
    }

    public static class WelcomePanelSwingUi
    extends ErrorMessagePanel.ErrorMessagePanelSwingUi {
        protected WelcomePanel panel;
        private NbiTextPane textPane;
        private NbiPanel leftImagePanel;
        ErrorMessagePanel.ErrorMessagePanelSwingUi.ValidatingThread validatingThread;

        public WelcomePanelSwingUi(WelcomePanel component, SwingContainer container) {
            super(component, container);
            this.panel = component;
            this.initComponents();
        }

        public String getTitle() {
            return null;
        }

        protected void initializeContainer() {
            super.initializeContainer();
            this.container.getBackButton().setVisible(false);
        }

        protected void initialize() {
            List<Product> list;
            this.textPane.setContentType("text/html");
            this.textPane.setText(StringUtils.format(this.panel.getProperty(WelcomePanel.WELCOME_TEXT_PROPERTY), new Object[0]));
            List<Product> toInstall = Registry.getInstance().getProductsToInstall();
            if (toInstall.isEmpty() && (list = this.panel.getBundledRegistry().getProducts()).size() == 1) {
                if (SystemUtils.getCurrentPlatform().isCompatibleWith(list.get(0).getPlatforms())) {
                    File installationLocation = list.get(0).getInstallationLocation();
                    this.textPane.setText(StringUtils.format(this.panel.getProperty(WelcomePanel.WELCOME_ALREADY_INSTALLED_TEXT_PROPERTY), list.get(0).getDisplayName(), installationLocation.getAbsolutePath()));
                } else {
                    this.textPane.setText(StringUtils.format(WELCOME_INCOMPATIBLE_PLATFORM_TEXT, list.get(0).getDisplayName()));
                }
                this.container.getCancelButton().setVisible(false);
                this.container.getNextButton().setText(this.panel.getProperty(WelcomePanel.WELCOME_ALREADY_INSTALLED_NEXT_BUTTON_TEXT_PROPERTY));
            }
            super.initialize();
        }

        private void initComponents() {
            this.textPane = new NbiTextPane();
            this.leftImagePanel = new NbiPanel();
            int width = 0;
            int height = 0;
            String topLeftImage = SystemUtils.resolveString(System.getProperty(WelcomePanel.WELCOME_PAGE_LEFT_TOP_IMAGE_PROPERTY));
            String bottomLeftImage = SystemUtils.resolveString(System.getProperty(WelcomePanel.WELCOME_PAGE_LEFT_BOTTOM_IMAGE_PROPERTY));
            int bottomAnchor = 3;
            if (topLeftImage != null) {
                this.leftImagePanel.setBackgroundImage(topLeftImage, 1);
                width = this.leftImagePanel.getBackgroundImage(1).getIconWidth();
                height += this.leftImagePanel.getBackgroundImage(1).getIconHeight();
            }
            if (bottomLeftImage != null) {
                this.leftImagePanel.setBackgroundImage(bottomLeftImage, bottomAnchor);
                width = this.leftImagePanel.getBackgroundImage(bottomAnchor).getIconWidth();
                height += this.leftImagePanel.getBackgroundImage(bottomAnchor).getIconHeight();
            }
            this.leftImagePanel.setPreferredSize(new Dimension(width, height));
            this.leftImagePanel.setMaximumSize(new Dimension(width, height));
            this.leftImagePanel.setMinimumSize(new Dimension(width, 0));
            this.leftImagePanel.setSize(new Dimension(width, height));
            this.leftImagePanel.setOpaque(false);
            int dy = 0;
            this.add((Component)this.leftImagePanel, new GridBagConstraints(0, 0, 1, 100, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.textPane, new GridBagConstraints(1, dy++, 4, 1, 1.0, 0.0, 21, 2, new Insets(10, 11, 11, 11), 0, 0));
            NbiTextPane separatorPane = new NbiTextPane();
            separatorPane = new NbiTextPane();
            this.add((Component)separatorPane, new GridBagConstraints(3, dy, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            Component errorLabel = this.getComponent(0);
            this.getLayout().removeLayoutComponent(errorLabel);
            this.add(errorLabel, new GridBagConstraints(1, 99, 99, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 4, 0), 0, 0));
        }
    }

    public static class WelcomePanelUi
    extends ErrorMessagePanel.ErrorMessagePanelUi {
        protected WelcomePanel component;

        public WelcomePanelUi(WelcomePanel component) {
            super(component);
            this.component = component;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new WelcomePanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }
}

