/*
 * Decompiled with CFR 0.152.
 */
package org.mycompany.installer.wizard.components.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.border.EmptyBorder;
import org.mycompany.installer.utils.applications.NetBeansRCPUtils;
import org.netbeans.installer.Installer;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryNode;
import org.netbeans.installer.product.RegistryType;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.swing.NbiCheckBox;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.wizard.components.panels.ErrorMessagePanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class PreInstallSummaryPanel
extends ErrorMessagePanel {
    public static final String INSTALLATION_FOLDER_PROPERTY = "installation.folder";
    public static final String UNINSTALL_LABEL_TEXT_PROPERTY = "uninstall.list.label.text";
    public static final String INSTALLATION_SIZE_PROPERTY = "installation.size";
    public static final String DOWNLOAD_SIZE_PROPERTY = "download.size";
    public static final String ERROR_NOT_ENOUGH_SPACE_PROPERTY = "error.not.enough.space";
    public static final String ERROR_CANNOT_CHECK_SPACE_PROPERTY = "error.cannot.check.space";
    public static final String ERROR_LOGIC_ACCESS_PROPERTY = "error.logic.access";
    public static final String ERROR_FSROOTS_PROPERTY = "error.fsroots";
    public static final String ERROR_NON_EXISTENT_ROOT_PROPERTY = "error.non.existent.root";
    public static final String ERROR_CANNOT_WRITE_PROPERTY = "error.cannot.write";
    public static final String REMOVE_APP_USERDIR_PROPERTY = "remove.app.userdir";
    public static final String REMOVE_APP_USERDIR_TEXT_PROPERTY = "remove.app.userdir.text";
    public static final String REMOVE_APP_USERDIR_CHECKBOX_PROPERTY = "remove.app.userdir.checkbox";
    public static final String DEFAULT_TITLE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.description");
    public static final String DEFAULT_DESCRIPTION_UNINSTALL = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.description.uninstall");
    public static final String DEFAULT_INSTALLATION_FOLDER = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.installation.folder");
    public static final String DEFAULT_UNINSTALL_LABEL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.uninstall.list.label.text");
    public static final String DEFAULT_INSTALLATION_SIZE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.installation.size");
    public static final String DEFAULT_DOWNLOAD_SIZE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.download.size");
    public static final String DEFAULT_NEXT_BUTTON_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.next.button.text");
    public static final String DEFAULT_NEXT_BUTTON_TEXT_UNINSTALL = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.next.button.text.uninstall");
    public static final String DEFAULT_ERROR_NOT_ENOUGH_SPACE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.not.enough.space");
    public static final String DEFAULT_ERROR_CANNOT_CHECK_SPACE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.cannot.check.space");
    public static final String DEFAULT_ERROR_LOGIC_ACCESS = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.logic.access");
    public static final String DEFAULT_ERROR_FSROOTS = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.fsroots");
    public static final String DEFAULT_ERROR_NON_EXISTENT_ROOT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.non.existent.root");
    public static final String DEFAULT_ERROR_CANNOT_WRITE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.cannot.write");
    public static final String DEFAULT_REMOVE_APP_USERDIR_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.remove.app.userdir.text");
    public static final String DEFAULT_REMOVE_APP_USERDIR_CHECKBOX = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.remove.app.userdir.checkbox");
    public static final long REQUIRED_SPACE_ADDITION = 0xA00000L;

    public PreInstallSummaryPanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(INSTALLATION_FOLDER_PROPERTY, DEFAULT_INSTALLATION_FOLDER);
        this.setProperty(UNINSTALL_LABEL_TEXT_PROPERTY, DEFAULT_UNINSTALL_LABEL_TEXT);
        this.setProperty(INSTALLATION_SIZE_PROPERTY, DEFAULT_INSTALLATION_SIZE);
        this.setProperty(DOWNLOAD_SIZE_PROPERTY, DEFAULT_DOWNLOAD_SIZE);
        this.setProperty("next.button.text", DEFAULT_NEXT_BUTTON_TEXT);
        this.setProperty(ERROR_NOT_ENOUGH_SPACE_PROPERTY, DEFAULT_ERROR_NOT_ENOUGH_SPACE);
        this.setProperty(ERROR_CANNOT_CHECK_SPACE_PROPERTY, DEFAULT_ERROR_CANNOT_CHECK_SPACE);
        this.setProperty(ERROR_LOGIC_ACCESS_PROPERTY, DEFAULT_ERROR_LOGIC_ACCESS);
        this.setProperty(ERROR_FSROOTS_PROPERTY, DEFAULT_ERROR_FSROOTS);
        this.setProperty(ERROR_NON_EXISTENT_ROOT_PROPERTY, DEFAULT_ERROR_NON_EXISTENT_ROOT);
        this.setProperty(ERROR_CANNOT_WRITE_PROPERTY, DEFAULT_ERROR_CANNOT_WRITE);
        this.setProperty(REMOVE_APP_USERDIR_TEXT_PROPERTY, DEFAULT_REMOVE_APP_USERDIR_TEXT);
        this.setProperty(REMOVE_APP_USERDIR_CHECKBOX_PROPERTY, DEFAULT_REMOVE_APP_USERDIR_CHECKBOX);
    }

    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new PreInstallSummaryPanelUi(this);
        }
        return this.wizardUi;
    }

    public void initialize() {
        List<Product> toInstall = Registry.getInstance().getProductsToInstall();
        if (toInstall.size() > 0) {
            this.setProperty("next.button.text", DEFAULT_NEXT_BUTTON_TEXT);
            this.setProperty("description", DEFAULT_DESCRIPTION);
        } else {
            this.setProperty("next.button.text", DEFAULT_NEXT_BUTTON_TEXT_UNINSTALL);
            this.setProperty("description", DEFAULT_DESCRIPTION_UNINSTALL);
        }
    }

    public static class PreInstallSummaryPanelSwingUi
    extends ErrorMessagePanel.ErrorMessagePanelSwingUi {
        protected PreInstallSummaryPanel component;
        private NbiTextPane locationsPane;
        private NbiLabel uninstallListLabel;
        private NbiTextPane uninstallListPane;
        private NbiLabel installationSizeLabel;
        private NbiLabel installationSizeValue;
        private NbiLabel downloadSizeLabel;
        private NbiLabel downloadSizeValue;
        private NbiCheckBox removeUserdirCheckbox;
        private NbiTextPane removeUserdirPane;
        private NbiPanel spacer;
        private int gridy = 0;

        public PreInstallSummaryPanelSwingUi(PreInstallSummaryPanel component, SwingContainer container) {
            super(component, container);
            this.component = component;
            this.initComponents();
        }

        protected void initializeContainer() {
            super.initializeContainer();
            this.container.getNextButton().setText(this.panel.getProperty("next.button.text"));
        }

        protected void initialize() {
            Registry registry = Registry.getInstance();
            StringBuilder text = new StringBuilder();
            long installationSize = 0L;
            long downloadSize = 0L;
            for (Product product : registry.getProductsToInstall()) {
                installationSize += product.getRequiredDiskSpace();
                downloadSize += product.getDownloadSize();
            }
            for (Product product : registry.getProductsToInstall()) {
                text.append("\n");
                text.append(StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.INSTALLATION_FOLDER_PROPERTY), product.getDisplayName()));
                text.append("\n");
                text.append("    " + product.getInstallationLocation());
                text.append("\n");
            }
            this.locationsPane.setText(text);
            List<Product> toUninstall = registry.getProductsToUninstall();
            String uninstallLabelText = toUninstall.size() > 0 ? StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.UNINSTALL_LABEL_TEXT_PROPERTY), toUninstall.get(0).getDisplayName()) : "";
            this.uninstallListLabel.setText(uninstallLabelText);
            this.installationSizeLabel.setText(this.panel.getProperty(PreInstallSummaryPanel.INSTALLATION_SIZE_PROPERTY));
            this.installationSizeValue.setText(StringUtils.formatSize(installationSize));
            this.downloadSizeLabel.setText(this.panel.getProperty(PreInstallSummaryPanel.DOWNLOAD_SIZE_PROPERTY));
            this.downloadSizeValue.setText(StringUtils.formatSize(downloadSize));
            if (registry.getProductsToInstall().size() == 0) {
                this.locationsPane.setVisible(false);
                this.installationSizeLabel.setVisible(false);
                this.installationSizeValue.setVisible(false);
            } else {
                this.locationsPane.setVisible(true);
                this.installationSizeLabel.setVisible(true);
                this.installationSizeValue.setVisible(true);
            }
            if (registry.getProductsToUninstall().size() == 0) {
                this.uninstallListLabel.setVisible(false);
                this.uninstallListPane.setVisible(false);
            } else {
                this.uninstallListLabel.setVisible(true);
                this.uninstallListPane.setVisible(true);
            }
            this.downloadSizeLabel.setVisible(false);
            this.downloadSizeValue.setVisible(false);
            for (RegistryNode remoteNode : registry.getNodes(RegistryType.REMOTE)) {
                if (!remoteNode.isVisible()) continue;
                this.downloadSizeLabel.setVisible(true);
                this.downloadSizeValue.setVisible(true);
            }
            if (Boolean.getBoolean(PreInstallSummaryPanel.REMOVE_APP_USERDIR_PROPERTY)) {
                this.removeUserdirCheckbox.doClick();
            }
            this.removeUserdirCheckbox.setVisible(false);
            this.removeUserdirPane.setVisible(false);
            for (Product product : Registry.getInstance().getProductsToUninstall()) {
                try {
                    File installLocation = product.getInstallationLocation();
                    LogManager.log("... product installation directory: " + installLocation);
                    File userDir = NetBeansRCPUtils.getApplicationUserDirFile(installLocation);
                    LogManager.log("... product userdir: " + userDir);
                    if (!FileUtils.exists(userDir) || !FileUtils.canWrite(userDir)) break;
                    this.removeUserdirCheckbox.setText(StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.REMOVE_APP_USERDIR_CHECKBOX_PROPERTY), userDir.getAbsolutePath()));
                    this.removeUserdirCheckbox.setBorder(new EmptyBorder(0, 0, 0, 0));
                    this.removeUserdirCheckbox.setVisible(true);
                    this.removeUserdirPane.setVisible(true);
                    this.removeUserdirPane.setContentType("text/html");
                    this.removeUserdirPane.setText(StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.REMOVE_APP_USERDIR_TEXT_PROPERTY), product.getDisplayName()));
                    break;
                }
                catch (IOException e) {
                    LogManager.log(e);
                }
            }
            super.initialize();
        }

        protected String validateInput() {
            try {
                if (!Boolean.getBoolean("no.space.check")) {
                    List<File> roots = SystemUtils.getFileSystemRoots(new String[0]);
                    List<Product> toInstall = Registry.getInstance().getProductsToInstall();
                    HashMap<File, Long> spaceMap = new HashMap<File, Long>();
                    LogManager.log("Available roots : " + StringUtils.asString(roots));
                    File downloadDataDirRoot = FileUtils.getRoot(Installer.getInstance().getLocalDirectory(), roots);
                    long downloadSize = 0L;
                    for (Product product : toInstall) {
                        downloadSize += product.getDownloadSize();
                    }
                    spaceMap.put(downloadDataDirRoot, new Long(downloadSize));
                    long lastDataSize = 0L;
                    for (Product product : toInstall) {
                        File installLocation = product.getInstallationLocation();
                        File root = FileUtils.getRoot(installLocation, roots);
                        long productSize = product.getRequiredDiskSpace();
                        LogManager.log("    [" + root + "] <- " + installLocation);
                        if (root != null) {
                            Long ddSize = (Long)spaceMap.get(downloadDataDirRoot);
                            spaceMap.put(downloadDataDirRoot, ddSize - lastDataSize);
                            Long size = (Long)spaceMap.get(root);
                            size = (size != null ? size : 0L) + productSize;
                            spaceMap.put(root, size);
                            lastDataSize = product.getDownloadSize();
                            continue;
                        }
                        return StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.ERROR_NON_EXISTENT_ROOT_PROPERTY), product, installLocation);
                    }
                    for (File root : spaceMap.keySet()) {
                        try {
                            long requiredSpace;
                            long availableSpace = SystemUtils.getFreeSpace(root);
                            if (availableSpace >= (requiredSpace = (Long)spaceMap.get(root) + 0xA00000L)) continue;
                            return StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.ERROR_NOT_ENOUGH_SPACE_PROPERTY), root, StringUtils.formatSize(requiredSpace - availableSpace));
                        }
                        catch (NativeException e) {
                            ErrorManager.notifyError(this.panel.getProperty(PreInstallSummaryPanel.ERROR_CANNOT_CHECK_SPACE_PROPERTY), e);
                        }
                    }
                }
                List<Product> toUninstall = Registry.getInstance().getProductsToUninstall();
                for (Product product : toUninstall) {
                    if (FileUtils.canWrite(product.getInstallationLocation())) continue;
                    return StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.ERROR_CANNOT_WRITE_PROPERTY), product, product.getInstallationLocation());
                }
            }
            catch (IOException e) {
                ErrorManager.notifyError(this.panel.getProperty(PreInstallSummaryPanel.ERROR_FSROOTS_PROPERTY), e);
            }
            return null;
        }

        private void initComponents() {
            this.gridy = 0;
            this.locationsPane = new NbiTextPane();
            this.uninstallListPane = new NbiTextPane();
            this.uninstallListLabel = new NbiLabel();
            this.uninstallListLabel.setLabelFor(this.uninstallListPane);
            this.installationSizeValue = new NbiLabel();
            this.installationSizeLabel = new NbiLabel();
            this.installationSizeLabel.setLabelFor(this.installationSizeValue);
            this.downloadSizeValue = new NbiLabel();
            this.downloadSizeLabel = new NbiLabel();
            this.downloadSizeLabel.setLabelFor(this.downloadSizeValue);
            this.spacer = new NbiPanel();
            this.add((Component)this.locationsPane, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 19, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.uninstallListLabel, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 19, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.uninstallListPane, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 19, 2, new Insets(0, 11, 0, 11), 0, 0));
            int gridy0 = this.gridy++;
            this.removeUserdirPane = new NbiTextPane();
            this.add((Component)this.removeUserdirPane, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 19, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.removeUserdirCheckbox = new NbiCheckBox();
            this.add((Component)this.removeUserdirCheckbox, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 19, 2, new Insets(4, 20, 0, 11), 0, 0));
            this.removeUserdirCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.setProperty(PreInstallSummaryPanel.REMOVE_APP_USERDIR_PROPERTY, "" + PreInstallSummaryPanelSwingUi.this.removeUserdirCheckbox.isSelected());
                }
            });
            this.add((Component)this.installationSizeLabel, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 21, 2, new Insets(22, 11, 0, 11), 0, 0));
            this.add((Component)this.installationSizeValue, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 21, 2, new Insets(4, 22, 0, 11), 0, 0));
            this.add((Component)this.downloadSizeLabel, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 21, 2, new Insets(4, 11, 0, 11), 0, 0));
            this.add((Component)this.downloadSizeValue, new GridBagConstraints(0, this.gridy++, 1, 1, 1.0, 0.0, 21, 2, new Insets(4, 22, 0, 11), 0, 0));
            this.add((Component)this.spacer, new GridBagConstraints(0, this.gridy + 10, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 11, 0, 11), 0, 0));
        }
    }

    public static class PreInstallSummaryPanelUi
    extends ErrorMessagePanel.ErrorMessagePanelUi {
        protected PreInstallSummaryPanel component;

        public PreInstallSummaryPanelUi(PreInstallSummaryPanel component) {
            super(component);
            this.component = component;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new PreInstallSummaryPanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }
}

