/*
 * Decompiled with CFR 0.152.
 */
package org.mycompany.installer.wizard.components.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.components.ProductConfigurationLogic;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.helper.DetailedStatus;
import org.netbeans.installer.utils.helper.swing.NbiCheckBox;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.wizard.components.WizardPanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.containers.SwingFrameContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class PostInstallSummaryPanel
extends WizardPanel {
    public static final String MESSAGE_TEXT_SUCCESS_PROPERTY = "message.text.success";
    public static final String MESSAGE_CONTENT_TYPE_SUCCESS_PROPERTY = "message.content.type.success";
    public static final String MESSAGE_TEXT_WARNINGS_PROPERTY = "message.text.warnings";
    public static final String MESSAGE_CONTENT_TYPE_WARNINGS_PROPERTY = "message.content.type.warnings";
    public static final String MESSAGE_TEXT_ERRORS_PROPERTY = "message.text.errors";
    public static final String MESSAGE_CONTENT_TYPE_ERRORS_PROPERTY = "message.content.type.errors";
    public static final String MESSAGE_TEXT_SUCCESS_UNINSTALL_PROPERTY = "message.text.success.uninstall";
    public static final String MESSAGE_CONTENT_TYPE_SUCCESS_UNINSTALL_PROPERTY = "message.content.type.success.uninstall";
    public static final String MESSAGE_TEXT_WARNINGS_UNINSTALL_PROPERTY = "message.text.warnings.uninstall";
    public static final String MESSAGE_CONTENT_TYPE_WARNINGS_UNINSTALL_PROPERTY = "message.content.type.warnings.uninstall";
    public static final String MESSAGE_TEXT_ERRORS_UNINSTALL_PROPERTY = "message.text.errors.uninstall";
    public static final String MESSAGE_CONTENT_TYPE_ERRORS_UNINSTALL_PROPERTY = "message.content.type.errors.uninstall";
    public static final String DEFAULT_MESSAGE_TEXT_SUCCESS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.success");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE_SUCCESS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.content.type.success");
    public static final String DEFAULT_MESSAGE_TEXT_WARNINGS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.warnings");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE_WARNINGS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.content.type.warnings");
    public static final String DEFAULT_MESSAGE_TEXT_ERRORS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.errors");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE_ERRORS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.content.type.errors");
    public static final String DEFAULT_MESSAGE_TEXT_SUCCESS_UNINSTALL = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.success.uninstall");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE_SUCCESS_UNINSTALL = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.content.type.success.uninstall");
    public static final String DEFAULT_MESSAGE_TEXT_WARNINGS_UNINSTALL = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.warnings.uninstall");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE_WARNINGS_UNINSTALL = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.content.type.warnings.uninstall");
    public static final String DEFAULT_MESSAGE_TEXT_ERRORS_UNINSTALL = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.errors.uninstall");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE_ERRORS_UNINSTALL = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.content.type.errors.uninstall");
    public static final String DEFAULT_TITLE = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.description");
    public static final String DEFAULT_NEXT_BUTTON_TEXT = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.next.button.text");
    public static final String DEFAULT_MESSAGE_FINISH_PROCESS = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.finish");
    public static final String DEFAULT_MESSAGE_FINISH_PROCESS_CONTENT_TYPE = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.text.finish.content.type");
    public static final String DEFAULT_MESSAGE_LAUNCH_APPLICATION_NOW = ResourceUtils.getString(PostInstallSummaryPanel.class, "PoISP.message.run.application.now");

    public PostInstallSummaryPanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(MESSAGE_TEXT_SUCCESS_PROPERTY, DEFAULT_MESSAGE_TEXT_SUCCESS);
        this.setProperty(MESSAGE_CONTENT_TYPE_SUCCESS_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE_SUCCESS);
        this.setProperty(MESSAGE_TEXT_WARNINGS_PROPERTY, DEFAULT_MESSAGE_TEXT_WARNINGS);
        this.setProperty(MESSAGE_CONTENT_TYPE_WARNINGS_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE_WARNINGS);
        this.setProperty(MESSAGE_TEXT_ERRORS_PROPERTY, DEFAULT_MESSAGE_TEXT_ERRORS);
        this.setProperty(MESSAGE_CONTENT_TYPE_ERRORS_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE_ERRORS);
        this.setProperty(MESSAGE_TEXT_SUCCESS_UNINSTALL_PROPERTY, DEFAULT_MESSAGE_TEXT_SUCCESS_UNINSTALL);
        this.setProperty(MESSAGE_CONTENT_TYPE_SUCCESS_UNINSTALL_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE_SUCCESS_UNINSTALL);
        this.setProperty(MESSAGE_TEXT_WARNINGS_UNINSTALL_PROPERTY, DEFAULT_MESSAGE_TEXT_WARNINGS_UNINSTALL);
        this.setProperty(MESSAGE_CONTENT_TYPE_WARNINGS_UNINSTALL_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE_WARNINGS_UNINSTALL);
        this.setProperty(MESSAGE_TEXT_ERRORS_UNINSTALL_PROPERTY, DEFAULT_MESSAGE_TEXT_ERRORS_UNINSTALL);
        this.setProperty(MESSAGE_CONTENT_TYPE_ERRORS_UNINSTALL_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE_ERRORS_UNINSTALL);
        this.setProperty("next.button.text", DEFAULT_NEXT_BUTTON_TEXT);
    }

    public boolean isPointOfNoReturn() {
        return true;
    }

    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new PostInstallSummaryPanelUi(this);
        }
        return this.wizardUi;
    }

    public static class PostInstallSummaryPanelSwingUi
    extends WizardPanel.WizardPanelSwingUi {
        protected PostInstallSummaryPanel component;
        private NbiTextPane messagePaneInstall;
        private NbiTextPane messagePaneUninstall;
        private NbiTextPane messagePaneFinish;
        private NbiCheckBox runAppNow;
        private Product app;

        public PostInstallSummaryPanelSwingUi(PostInstallSummaryPanel component, SwingContainer container) {
            super(component, container);
            this.component = component;
            this.initComponents();
        }

        protected void initializeContainer() {
            super.initializeContainer();
            this.container.getBackButton().setVisible(false);
            this.container.getBackButton().setEnabled(false);
            this.container.getNextButton().setVisible(true);
            this.container.getNextButton().setEnabled(true);
            this.container.getNextButton().setText(this.component.getProperty("next.button.text"));
            this.container.getCancelButton().setVisible(false);
            this.container.getCancelButton().setEnabled(false);
        }

        public void evaluateNextButtonClick() {
            this.container.getNextButton().setEnabled(false);
            Product product = this.app;
            if (this.app != null) {
                File executable;
                ProductConfigurationLogic l = null;
                try {
                    l = this.app.getLogic();
                }
                catch (InitializationException e) {
                    // empty catch block
                }
                File file = executable = l != null ? new File(this.app.getInstallationLocation(), l.getExecutable()) : null;
                if (executable != null && this.runAppNow.isSelected()) {
                    LogManager.log("... running: " + executable.getAbsolutePath());
                    ProcessBuilder pb = new ProcessBuilder(executable.getAbsolutePath());
                    try {
                        pb.start();
                    }
                    catch (IOException e) {
                        LogManager.log(e);
                    }
                }
            }
            super.evaluateNextButtonClick();
        }

        protected void initialize() {
            Registry registry = Registry.getInstance();
            List<Product> successfulInstall = registry.getProducts(DetailedStatus.INSTALLED_SUCCESSFULLY);
            List<Product> warningInstall = registry.getProducts(DetailedStatus.INSTALLED_WITH_WARNINGS);
            List<Product> errorInstall = registry.getProducts(DetailedStatus.FAILED_TO_INSTALL);
            List<Product> successfulUninstall = registry.getProducts(DetailedStatus.UNINSTALLED_SUCCESSFULLY);
            List<Product> warningUninstall = registry.getProducts(DetailedStatus.UNINSTALLED_WITH_WARNINGS);
            List<Product> errorUninstall = registry.getProducts(DetailedStatus.FAILED_TO_UNINSTALL);
            if (errorInstall.size() > 0) {
                this.messagePaneInstall.setContentType(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_CONTENT_TYPE_ERRORS_PROPERTY));
                this.messagePaneInstall.setText(StringUtils.format(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_TEXT_ERRORS_PROPERTY), errorInstall.get(0).getDisplayName(), LogManager.getLogFile()));
            } else if (warningInstall.size() > 0) {
                this.messagePaneInstall.setContentType(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_CONTENT_TYPE_WARNINGS_PROPERTY));
                this.messagePaneInstall.setText(StringUtils.format(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_TEXT_WARNINGS_PROPERTY), warningInstall.get(0).getDisplayName(), LogManager.getLogFile()));
            } else if (successfulInstall.size() > 0) {
                this.messagePaneInstall.setContentType(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_CONTENT_TYPE_SUCCESS_PROPERTY));
                this.messagePaneInstall.setText(StringUtils.format(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_TEXT_SUCCESS_PROPERTY), successfulInstall.get(0).getDisplayName(), LogManager.getLogFile()));
            } else {
                this.messagePaneInstall.setVisible(false);
            }
            this.messagePaneFinish.setVisible(true);
            this.messagePaneFinish.setContentType(DEFAULT_MESSAGE_FINISH_PROCESS_CONTENT_TYPE);
            this.messagePaneFinish.setText(DEFAULT_MESSAGE_FINISH_PROCESS);
            if (errorUninstall.size() > 0) {
                this.messagePaneUninstall.setContentType(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_CONTENT_TYPE_ERRORS_UNINSTALL_PROPERTY));
                this.messagePaneUninstall.setText(StringUtils.format(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_TEXT_ERRORS_UNINSTALL_PROPERTY), errorUninstall.get(0).getDisplayName(), LogManager.getLogFile()));
            } else if (warningUninstall.size() > 0) {
                this.messagePaneUninstall.setContentType(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_CONTENT_TYPE_WARNINGS_UNINSTALL_PROPERTY));
                this.messagePaneUninstall.setText(StringUtils.format(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_TEXT_WARNINGS_UNINSTALL_PROPERTY), warningUninstall.get(0).getDisplayName(), LogManager.getLogFile()));
            } else if (successfulUninstall.size() > 0) {
                this.messagePaneUninstall.setContentType(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_CONTENT_TYPE_SUCCESS_UNINSTALL_PROPERTY));
                this.messagePaneUninstall.setText(StringUtils.format(this.component.getProperty(PostInstallSummaryPanel.MESSAGE_TEXT_SUCCESS_UNINSTALL_PROPERTY), successfulUninstall.get(0).getDisplayName(), LogManager.getLogFile()));
            } else {
                this.messagePaneUninstall.setVisible(false);
            }
            LinkedList<Product> products = new LinkedList<Product>();
            products.addAll(successfulInstall);
            products.addAll(warningInstall);
            this.runAppNow.setSelected(false);
            if (!products.isEmpty()) {
                this.runAppNow.setText(StringUtils.format(DEFAULT_MESSAGE_LAUNCH_APPLICATION_NOW, ((Product)products.get(0)).getDisplayName()));
                this.runAppNow.doClick();
                this.app = (Product)products.get(0);
            } else {
                this.runAppNow.setVisible(false);
            }
        }

        private void initComponents() {
            this.messagePaneInstall = new NbiTextPane();
            this.messagePaneUninstall = new NbiTextPane();
            this.messagePaneFinish = new NbiTextPane();
            this.runAppNow = new NbiCheckBox();
            this.add((Component)this.messagePaneInstall, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 19, 2, new Insets(31, 11, 0, 11), 0, 0));
            this.add((Component)this.messagePaneUninstall, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 19, 1, new Insets(31, 11, 0, 11), 0, 0));
            this.add((Component)this.messagePaneFinish, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 19, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.runAppNow, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 19, 2, new Insets(11, 11, 0, 11), 0, 0));
            if (this.container instanceof SwingFrameContainer) {
                final SwingFrameContainer sfc = (SwingFrameContainer)this.container;
                sfc.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent event) {
                        SwingUi currentUi = PostInstallSummaryPanelSwingUi.this.component.getWizardUi().getSwingUi(PostInstallSummaryPanelSwingUi.this.container);
                        if (currentUi != null && !PostInstallSummaryPanelSwingUi.this.container.getCancelButton().isEnabled() && !PostInstallSummaryPanelSwingUi.this.container.getCancelButton().isVisible() && !PostInstallSummaryPanelSwingUi.this.container.getBackButton().isVisible() && PostInstallSummaryPanelSwingUi.this.container.getNextButton().isVisible() && PostInstallSummaryPanelSwingUi.this.container.getNextButton().isEnabled()) {
                            currentUi.evaluateNextButtonClick();
                            sfc.removeWindowListener(this);
                        }
                    }
                });
            }
        }
    }

    public static class PostInstallSummaryPanelUi
    extends WizardPanel.WizardPanelUi {
        protected PostInstallSummaryPanel component;

        public PostInstallSummaryPanelUi(PostInstallSummaryPanel component) {
            super(component);
            this.component = component;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new PostInstallSummaryPanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }
}

