package usage;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.user.UseUser;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

/**
 *
 * @author jbader
 */
class IButtonUsageEventMapper implements EventMapper 
{
	private static final String NO_IBUTTON = "000000000000";
	
	public List createEFMevents(Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		List<Properties> efmEvents = new ArrayList<Properties>();
		String ibutton = (String) eventParameters.get("iButton");
		
		if((eventParameters.size()>1) && (ibutton!=null))
		{
			List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");

			Properties event = new Properties();
			EFMEventUtil.addGeneralParameters(event, efmUnitIds, (Long) eventParameters.get("timestamp"));

			UseCache useCache = facadeWrapper.getUseFacade().getCache(efmUnitIds.get(0));

			if(NO_IBUTTON.equals(ibutton))
			{				
				if(useCache!=null)
				{
					// if somebody is logged in => logoff
					String key = getUserKey(useCache, facadeWrapper);
					event.setProperty(EventConstants.ATTRIBUTE_USE_USER, key);
					event.setProperty(EventConstants.ATTRIBUTE_USE_LOGIN, "0");

					efmEvents.add(event);
				}
			}
			else
			{
				if((useCache==null) || (isUserChanged(ibutton, useCache, facadeWrapper)))
				{
					// if nobody is logged in or anybody else is logged in => login the new user
					event.setProperty(EventConstants.ATTRIBUTE_USE_USER, ibutton);
					event.setProperty(EventConstants.ATTRIBUTE_USE_LOGIN, "1");

					efmEvents.add(event);
				}
			}
		}
		
		return efmEvents;
	}
	
	String getUserKey(UseCache useCache, FacadeWrapper facadeWrapper)
	{
		Long userId = useCache.getUseUserId();
		UseUser user = facadeWrapper.getUseFacade().getUser(userId);
		return user.getKeyId();		
	}
	
	boolean isUserChanged(String newKey, UseCache useCache, FacadeWrapper facadeWrapper)
	{
		String oldKey = getUserKey(useCache, facadeWrapper);
		return !newKey.equals(oldKey);
	}
}

