package ercogener

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

/**
 *
 * @author <a href="mailto:jbader@zebra.com">Joachim Bader</a>
 * $Rev: 21138 $
 */
class TelicGenerEventMapper implements EventMapper {
    public List createEFMevents(Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		List<Properties> efmEvents = new ArrayList<Properties>();

		List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");

		if(eventParameters.size()>1)
		{
			Properties geoEvent = new Properties();
			EFMEventUtil.addGeneralParameters(geoEvent, efmUnitIds, (Long) eventParameters.get("timestamp"));
			geoEvent.setProperty(EventConstants.ATTRIBUTE_GEO_TRUSTED, "1");
			geoEvent.setProperty(EventConstants.ATTRIBUTE_GEO_RMC, (String) eventParameters.get("rmc"));
			geoEvent.setProperty(EventConstants.ATTRIBUTE_GEO_GGA, (String) eventParameters.get("gga"));
			efmEvents.add(geoEvent);

			event = (Properties) geoEvent.clone();
			event.setProperty(EventConstants.ATTRIBUTE_STATEMODEL, "2010");
			event.setProperty(EventConstants.ATTRIBUTE_STATEID, eventParameters.get("in1").equals(Boolean.TRUE)?"2012":"2011");
			efmEvents.add(event);

			event = (Properties) geoEvent.clone();
			event.setProperty(EventConstants.ATTRIBUTE_STATEMODEL, "2050");
			event.setProperty(EventConstants.ATTRIBUTE_STATEID, eventParameters.get("in2").equals(Boolean.TRUE)?"2053":"2054");
			efmEvents.add(event);

			event = (Properties) geoEvent.clone();
			event.setProperty(EventConstants.ATTRIBUTE_MEASUREMENT_TYPE, "99");
			event.setProperty(EventConstants.ATTRIBUTE_MEASUREMENT_VALUE, eventParameters.get("an1").toString());
			efmEvents.add(event);

			an2 = (Properties) geoEvent.clone();
			event.setProperty(EventConstants.ATTRIBUTE_MEASUREMENT_TYPE, "100");
			event.setProperty(EventConstants.ATTRIBUTE_MEASUREMENT_VALUE, eventParameters.get("an2").toString());
			efmEvents.add(event);
		}
		else
		{
			Properties keepAlive = new Properties();
			EFMEventUtil.addGeneralParameters(keepAlive, efmUnitIds, (Long) metainfo.get("efm.receiveTime"));
			efmEvents.add(keepAlive);
		}

		return efmEvents;        
    }

}

