package statemodels.motor.runsunnecessary;

import de.proveo.wwt.logic.ejb.state.server.*;
import de.proveo.wwt.logic.ejb.state.*;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.constants.server.JMSConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Server driven statemodel for entry point <code>server.statemodel</code>.
 * 
 * Switch motor statemodel to runs unnecessarily if motor is running for more then 5 minutes without 
 * driving or working.
 * 
 * Switch motor statemodel to runs necessarily if motor is running unnecessarily and operation 
 * status model changes to drive or work.
 * 
 * Switches only if a newer event is already received.
 *
 *
 * @author <a href="mailto:jbader@zebra.com">Joachim Bader</a>
 * $Rev: 21561 $
 */
public class MotorRunsUnnecessary implements ServerDrivenStateModel {

	/** logger instance for this class */
	private static final Log log = LogFactory.getLog(MotorRunsUnnecessary.class);	
	
	private static final int RUNS_UNNECESSARILY_TIMEOUT = 5*60*1000;
		
	public int getStateModelId()
	{
 		return 2010;
	}
        
    public GeneratedStateEvent onMessage(SerializableEventWrapper wrapper, CurrentStateFacadeLocal currentStateFacade)
    {
        String typeOfEvent = wrapper.get_typeOfEvent();
        switch(typeOfEvent)
        {
            //case JMSConstants.STATE_EVENT_HISTORY_AND_CACHE:
            //    return onStateEvent(wrapper, currentStateFacade);
            default:
				return onUnhandledMessage(wrapper, currentStateFacade);
        }
    }
	
	/**
	 * handle not used events, linke position events, ..., to update the statemodel
	 */
	GeneratedStateEvent onUnhandledMessage(SerializableEventWrapper wrapper, CurrentStateFacadeLocal currentStateFacade)
	{
		return onTimeTrigger(wrapper.get_historyValue().getUnitId(), wrapper.get_historyValue().getBeginTime(), currentStateFacade);
	}
    
	GeneratedStateEvent onStateEvent(SerializableEventWrapper wrapper, CurrentStateFacadeLocal currentStateFacade)
	{
		StateHistory stateHistory = (StateHistory) wrapper.get_historyValue();		
		
		switch(stateHistory.getStateModelId())
		{
			case 2050: // operation status event
				return onOperationStateEvent(stateHistory, currentStateFacade);
				break;
			
			default:
				return onUnhandledMessage(wrapper, currentStateFacade);
		}
	}
	
	GeneratedStateEvent onOperationStateEvent(StateHistory stateHistory, CurrentStateFacadeLocal currentStateFacade)
	{
		StateCache motorStatus = currentStateFacade.getCacheEntry(stateHistory.getUnitId(), 2010);
		
		log.trace(stateHistory);
        
        if(motorStatus==null)
        {
            return null;            
        }
        
		/* swithc back to runs necessarily should be done by the mapper script
		if(motorStatus.getStateId()==2013) // runs unnecessarily
		{
			switch(stateHistory.getStateId())
			{
				case 2053: // drive 
				case 2052: // work
					GeneratedStateEvent event = new GeneratedStateEvent();
					event.timestamp = stateHistory.getBeginTime();
					event.newStateId = 2012; // runs necessarily
				
					return event; 
			}		
		}*/
		
		return null;
	}
	
	public GeneratedStateEvent onTimeTrigger(long unitId, long lastEventTimestamp, CurrentStateFacadeLocal currentStateFacade)
	{
		StateCache motorStatus = currentStateFacade.getCacheEntry(unitId, 2010);
        
        if(motorStatus==null)
        {
            return null;            
        }
        
		if(motorStatus.getStateId()==2012)
		{
			// motor runs necessarily, check operation status
			StateCache operationStatus = currentStateFacade.getCacheEntry(unitId, 2050);
            if(operationStatus==null)
            {
                return null;            
            }            
						
			if((operationStatus.getStateId()!=2053) && (operationStatus.getStateId()!=2052))
			{
				final long motorRunTimeSinceLastOperation = 0;
				
				long referenceTimestamp;
				
				// motor is running and the vehicle is not driving or working
				// first of all we see if the engine status is the last event we received
				if((motorStatus.getTimestamp() - operationStatus.getTimestamp()) < 0)
				{
					// Now we must calculate with the operations status
					referenceTimestamp = operationStatus.getTimestamp();
					motorRunTimeSinceLastOperation = lastEventTimestamp-operationStatus.getTimestamp();
					
					if(log.isTraceEnabled())
					{
							log.trace("Unit ID = "+unitId+" operations Status State ID: "+operationStatus.getStateId()+" lastEventTimestamp= "+lastEventTimestamp+" OperationStatusTimestamp= "+operationStatus.getTimestamp()+ "MotorTimestamp= "+motorStatus.getTimestamp());
					}
				}
				else
				{
					/* Now we have to calculate with the lsast motor status, not operations status */
					referenceTimestamp = motorStatus.getTimestamp();
					motorRunTimeSinceLastOperation = lastEventTimestamp-motorStatus.getTimestamp();
					
					if(log.isTraceEnabled())
					{
							log.trace("Unit ID = "+unitId+" operations Status State ID: "+operationStatus.getStateId()+" lastEventTimestamp= "+lastEventTimestamp+" MotorStatusTimestamp= "+motorStatus.getTimestamp()+" OperationStatusTimestamp= "+operationStatus.getTimestamp());
					}
				}
				
				if(log.isTraceEnabled())
				{
						log.trace("Unit ID = "+unitId+" operations Status State ID: "+operationStatus.getStateId()+" MotorRunTime= "+motorRunTimeSinceLastOperation+"Timeiut= "+RUNS_UNNECESSARILY_TIMEOUT);
				}
				
				if(motorRunTimeSinceLastOperation > RUNS_UNNECESSARILY_TIMEOUT)
				{
					// motor runs unnecessarily!					
					if(log.isTraceEnabled())
					{
							log.trace("Unit ID = "+unitId+" set engine to runs unnecessary");
					}
					
					GeneratedStateEvent event = new GeneratedStateEvent();
					event.timestamp = referenceTimestamp+RUNS_UNNECESSARILY_TIMEOUT;
					event.newStateId = 2013;
					
					return event;
				}				
			}
		}
				
		return null;		
	}
}

