package infomanLite.fmgtest;

import infomanLite.BaseInfomanLiteEventMapper;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

import infomanLite.*;

import de.proveo.event.util.raw.ByteUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;

import org.apache.commons.logging.LogFactory;

/**
 * Event Mapper Scripts for InfomanLite FMG Test AT130 fuel measurement.
 * 
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 * 
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22144 $
 */
class AT130_fuel extends BaseInfomanLiteLiquidLevelMapping 
{
	public AT130_fuel()
	{
		super(LogFactory.getLog(AT130_fuel.class));
	}
	
	Float getAnalogValue(Map eventParameters)
	{
		return eventParameters.get("io.analog1");
	}
	
	Integer getVolumeStatusModel()
	{
		return 2030;
	}
	
	Integer getMeasurementEventType()
	{
		return 310;
	}
	
	ArrayList<Float> getRawValues()
	{
		// in volt
		return [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
	}
	
	ArrayList<Float> getVolumeValues()
	{
		// in liter
		return [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
	}
}