package infomanLite.fmgtest;

import infomanLite.BaseInfomanLiteEventMapper;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

import de.proveo.event.util.raw.ByteUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;


/**
 * Event Mapper Scripts for InfomanLite FMG Test AP242.
 *
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 * 
 * io.digitalIn0: aircraftConnector not plugged
 * io.digitalIn1: dc
 * io.digitalIn2: towingBarDown
 * io.digitalIn3: motorD+
 * io.digitalIn4: ac
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22109 $
 */
class AP242 extends BaseInfomanLiteEventMapper 
{
	Boolean isEngineOnCondition(Map eventParameters)
	{
		// motorD+
		return eventParameters.get("io.digitalIn3").equals(Boolean.TRUE);
	}
	
	Boolean isWorkCondition(Map eventParameters)
	{
		// aircraftConnector not plugged  
		if(eventParameters.get("io.digitalIn0").equals(Boolean.FALSE))
		{
			// aircraftconnector plugged
			return true;
		}		
		
		if(isEngineOnCondition(eventParameters))
		{
			// ac or dc
			return eventParameters.get("io.digitalIn4").equals(Boolean.TRUE) || eventParameters.get("io.digitalIn1").equals(Boolean.TRUE);
		}		
		
		return false;
	}
	
	Boolean isDriveCondition(Map eventParameters)
	{
		// towingBarDown
		return eventParameters.get("io.digitalIn2").equals(Boolean.TRUE);		
	}
	
	Integer getDistanceMeasurementType()
	{
		return 26;
	}
}