package infomanLite.fmgtest;

import infomanLite.BaseInfomanLiteEventMapper;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

import de.proveo.event.util.raw.ByteUtil;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;


/**
 * Event Mapper Scripts for InfomanLite FMG Test AF125.
 *
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 * 
 * io.digitalIn0: ignition
 * io.digitalIn1: handbrake open
 * io.digitalIn2: conveyorBeltUp
 * io.digitalIn3: conveyorBeltForward ????
 * io.digitalIn4: conveyorBeltBackward ????
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22109 $
 */
class AF125 extends BaseInfomanLiteEventMapper 
{
	Boolean isEngineOnCondition(Map eventParameters)
	{
		// ignition
		return eventParameters.get("io.digitalIn0").equals(Boolean.TRUE);
	}
	
	Boolean isWorkCondition(Map eventParameters)
	{
		if(isEngineOnCondition(eventParameters))
		{
			// conveyorBeltUp
			return eventParameters.get("io.digitalIn2").equals(Boolean.TRUE);
		}
		
		return false;
	}
	
	Boolean isDriveCondition(Map eventParameters)
	{
		if(isEngineOnCondition(eventParameters))
		{			
			// conveyorBeltForward or conveyorBeltBackward???? realy?????
			if(eventParameters.get("io.digitalIn3").equals(Boolean.TRUE) || eventParameters.get("io.digitalIn4").equals(Boolean.TRUE))
			{
				return true;
			}			
		}
		
		return false;
	}
	
	Integer getDistanceMeasurementType()
	{
		return 26;
	}
}