package infomanLite;

import de.proveo.wwt.logic.ejb.dataIn.event.mapper.*;
import de.proveo.wwt.datamodel.notify.*;
import de.proveo.wwt.logic.ejb.dataIn.notify.*;

import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.util.geo.GPSPosition;

import de.proveo.eventbase.EventConstants;

import java.util.*;

import java.text.*;

import de.proveo.event.util.raw.ByteUtil;

/**
 * Authorization Event Mapper
 *
 * Should be used for entry point <code>infoman.event.3rdparty.eventMapper</code>
 *
 * Handles authentication messages:
 * <ul>
 *		<li>login/logoff</li>
 *		<li>access denied</li>
 *		<li>unauthenticated usage</li>
 * </ul> 
 *
 * @author <a href="mailto:jbader@proveo.com">Joachim Bader</a>
 * $Rev: 22162 $
 */
class InfomanLiteAuthenticationEventMapper implements EventMapper 
{
	private static final int FT_DEBUG_MSG_ACL_ACCESS_DENIED = 1;
	
	private static final int ACCESS_DENIED_NOTIFICATION_ID = 800;
		
	private static final int UNAUTHENTICATED_USAGE_NOTIFICATION_ID = 554;	
	private static final int REFIRE_UNAUTHENTICATED_USAGE_NOTIFICATION_THRESHOLD = 15*60*1000;
	
	public List createEFMevents(Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		List<Properties> efmEvents = new ArrayList<Properties>();
		
		if(!eventParameters.isEmpty())
		{
			createAccessDeniedMessage(efmEvents, eventParameters, metainfo, facadeWrapper);
			
			createLoginLogoutMessage(efmEvents, eventParameters, metainfo, facadeWrapper);
			
			createUnauthenticatedUsageMessage(efmEvents, eventParameters, metainfo, facadeWrapper);
		}
		
		return efmEvents;
	}	
	
	void createUnauthenticatedUsageMessage(List<Properties> efmEvents, Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		Boolean login = (Boolean) eventParameters.get("io.authStatus.auth");
		Boolean usage = (Boolean) eventParameters.get("io.authStatus.use");
		
		if((login!=null) && (usage!=null))
		{
			if((!login.booleanValue()) && (usage.booleanValue()))
			{
				List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");
				
				List<NotifyCache> notifications = facadeWrapper.getNotifyFacade().findCacheByUnitIdAndMessageId(efmUnitIds.get(0), UNAUTHENTICATED_USAGE_NOTIFICATION_ID);
				boolean fireNecessary = true;

				Long timestamp = (Long) eventParameters.get("timestamp");
				
				if((notifications!=null) && (!notifications.isEmpty()))
				{
					NotifyCache notification = notifications.get(0);
					long diff = timestamp-notification.getCreateTime();
					fireNecessary = (diff>REFIRE_UNAUTHENTICATED_USAGE_NOTIFICATION_THRESHOLD);
				}
				
				if(fireNecessary)
				{					
					Properties event = new Properties();
					EFMEventUtil.addGeneralParameters(event, efmUnitIds, timestamp);
					event.setProperty(EventConstants.ATTRIBUTE_NOTIFY_MESSAGEID, Long.toString(UNAUTHENTICATED_USAGE_NOTIFICATION_ID));
					event.setProperty(EventConstants.ATTRIBUTE_NOTIFY_ENTRYFLAG, boolean2String(true));
					
					efmEvents.add(event);
				}
			}
		}		
	}

	void createLoginLogoutMessage(List<Properties> efmEvents, Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		if(eventParameters.containsKey("auth.userID"))
		{
			List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");			
			String userId = (String) eventParameters.get("auth.userID");
			boolean login = (Boolean) eventParameters.get("io.authStatus.auth");
			
			Properties event = new Properties();
			EFMEventUtil.addGeneralParameters(event, efmUnitIds, (Long) eventParameters.get("timestamp"));
			event.setProperty(EventConstants.ATTRIBUTE_USE_USER, userId);
			event.setProperty(EventConstants.ATTRIBUTE_USE_LOGIN, boolean2String(login)); 
			
			efmEvents.add(event);
		}
	}
	
	
	void createAccessDeniedMessage(List<Properties> efmEvents, Map eventParameters, Map metainfo, FacadeWrapper facadeWrapper)
	{
		if(new Integer(FT_DEBUG_MSG_ACL_ACCESS_DENIED).equals(eventParameters.get("debug.msgType")))
		{
			List<Long> efmUnitIds = (List<Long>) metainfo.get("efm.unitIds");
			String userId = eventParameters.get("debug.msg");
			
			Properties event = new Properties();
			EFMEventUtil.addGeneralParameters(event, efmUnitIds, (Long) eventParameters.get("timestamp"));
			event.setProperty(EventConstants.ATTRIBUTE_NOTIFY_MESSAGEID, Long.toString(ACCESS_DENIED_NOTIFICATION_ID));
			event.setProperty(EventConstants.ATTRIBUTE_NOTIFY_ENTRYFLAG, boolean2String(true));
			event.setProperty("n" + EventConstants.ATTRIBUTE_USE_USER, userId);
			
			efmEvents.add(event);
		}
	}
	
	protected String boolean2String(boolean flag)
	{
		return flag ? "1" : "0";
	}		
}