/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess;

import com.sun.jna.platform.WindowUtils;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.openide.util.Utilities;

public class NativeWindowSystemImpl
extends NativeWindowSystem {
    private static final Logger LOG = Logger.getLogger(NativeWindowSystemImpl.class.getName());

    public boolean isWindowAlphaSupported() {
        String version;
        if (Utilities.isMac() && null != (version = System.getProperty("java.version")) && version.startsWith("1.7")) {
            return false;
        }
        boolean res = false;
        try {
            res = WindowUtils.isWindowAlphaSupported();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (UnsatisfiedLinkError e) {
            LOG.log(Level.FINE, null, e);
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
        return res;
    }

    public void setWindowAlpha(Window w, float alpha) {
        GraphicsConfiguration gc = w.getGraphicsConfiguration();
        GraphicsDevice gd = gc.getDevice();
        if (gc.getDevice().getFullScreenWindow() != w && gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            try {
                w.setOpacity(alpha);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            WindowUtils.setWindowAlpha((Window)w, (float)alpha);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public void setWindowMask(Window w, Shape mask) {
        GraphicsConfiguration gc = w.getGraphicsConfiguration();
        GraphicsDevice gd = gc.getDevice();
        if (gc.getDevice().getFullScreenWindow() != w && gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            try {
                w.setShape(mask);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void setWindowMask(Window w, Icon mask) {
        try {
            WindowUtils.setWindowMask((Window)w, (Icon)mask);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public boolean isUndecoratedWindowAlphaSupported() {
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return config.getDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
    }
}

