/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.unit;

import de.proveo.util.events.NotifyEvent;
import de.proveo.util.geo.GPSPosition;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MapClientStampUtil {
    private static final Log log = LogFactory.getLog(MapClientStampUtil.class);
    private static final HashMap notifyLocks = new HashMap();

    private MapClientStampUtil() {
    }

    public static long getUnitId(Map mapClientStamp) {
        String method = "getUnitId(): ";
        if (mapClientStamp.containsKey("UnitId")) {
            return (Long)mapClientStamp.get("UnitId");
        }
        int size = mapClientStamp.size();
        log.error((Object)(method + "stamp doesn't contain a unit id! Stamp size = " + size));
        if (size > 0) {
            log.error((Object)(method + " - stamp contains some data: UnitName=" + mapClientStamp.get("UnitName") + ", UnitSymbolName=" + mapClientStamp.get("UnitKind")));
        }
        log.error((Object)(method + "generate stacktrace to find calling methods:"));
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            log.error((Object)(method + "Return 0."));
            return 0L;
        }
    }

    public static String getUnitName(Map mapClientStamp) {
        String name = MapClientStampUtil.stringValue(mapClientStamp, "UnitName");
        if (name == null) {
            String id = "" + MapClientStampUtil.getUnitId(mapClientStamp);
            log.error((Object)("No unit name defined for unit ID " + id + ", use unit ID as unit name."));
            name = "[" + id + "]";
        }
        return name;
    }

    public static String getLimitedUnitName(Map mapClientStamp, int limitedLength, boolean debug) {
        String name;
        String method = "getLimitedUnitName(): ";
        String limitedName = name = MapClientStampUtil.getUnitName(mapClientStamp);
        if (name.length() > limitedLength) {
            limitedName = name.substring(0, limitedLength);
            if (debug) {
                log.debug((Object)(method + "found name '" + name + "' is longer than allowed limitation of " + limitedLength + " character, cut to '" + limitedName + "'"));
            }
        }
        return limitedName;
    }

    public static String getUnitSymbolName(Map mapClientStamp) {
        String unitSymbolName = MapClientStampUtil.stringValue(mapClientStamp, "UnitKind");
        if (unitSymbolName == null || unitSymbolName.length() == 0) {
            unitSymbolName = "Unknown";
            log.error((Object)("No unit symbol name found for unit " + MapClientStampUtil.getUnitId(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + ", use '" + unitSymbolName + "' as symbol name."));
        }
        return unitSymbolName;
    }

    public static String getUnitTypeName(Map mapClientStamp) {
        String unitTypeName = MapClientStampUtil.stringValue(mapClientStamp, "UnitType");
        if (unitTypeName == null || unitTypeName.length() == 0) {
            unitTypeName = MapClientStampUtil.getUnitSymbolName(mapClientStamp);
            log.error((Object)("No user defined name for unit type found for unit " + MapClientStampUtil.getUnitId(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + ", use symbol name ('" + unitTypeName + "') as type name."));
        }
        return unitTypeName;
    }

    public static GPSPosition getGPSPosition(Map mapClientStamp) {
        long unitId = MapClientStampUtil.getUnitId(mapClientStamp);
        int longi = MapClientStampUtil.intValue(mapClientStamp, "GpsLongMsec");
        int lati = MapClientStampUtil.intValue(mapClientStamp, "GpsLatMsec");
        String rmc = MapClientStampUtil.stringValueNotNull(mapClientStamp, "GpsRmc");
        String gga = MapClientStampUtil.stringValueNotNull(mapClientStamp, "GpsGga");
        boolean trusted = MapClientStampUtil.booleanValue(mapClientStamp, "GpsTrusted");
        if ((longi != 0 || lati != 0) && rmc.length() == 0) {
            return new GPSPosition(longi, lati, trusted, unitId);
        }
        return new GPSPosition(rmc, gga, trusted, unitId);
    }

    public static Point2D getLongLat(Map mapClientStamp) {
        int latitude = MapClientStampUtil.intValue(mapClientStamp, "GpsLatMsec");
        int longitude = MapClientStampUtil.intValue(mapClientStamp, "GpsLongMsec");
        if (latitude != 0 && longitude != 0) {
            return new Point2D.Double(longitude, latitude);
        }
        GPSPosition pos = MapClientStampUtil.getGPSPosition(mapClientStamp);
        if (pos != null) {
            return new Point2D.Double(pos.getLongitudeMSec(), pos.getLatitudeMSec());
        }
        return null;
    }

    public static boolean containsGPSPosition(Map mapClientStamp) {
        return mapClientStamp.containsKey("GeoBegin");
    }

    public static String getArea(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "Area");
    }

    public static String getAreaName(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "AreaName");
    }

    public static long getLastKeepaliveTimestamp(Map mapClientStamp) {
        return MapClientStampUtil.longValue(mapClientStamp, "KeepaliveTimestamp");
    }

    public static long getRemainingKeepaliveTime(Map mapClientStamp, long keepaliveTimeout, long currentTime, boolean debug) {
        String method = "getRemainingKeepaliveTime(): ";
        if (debug) {
            log.debug((Object)(method + "use keep alive timeout of " + keepaliveTimeout / 1000L + "s (" + keepaliveTimeout / 60000L + "min.)"));
        }
        if (currentTime <= 0L) {
            log.error((Object)(method + "currentTime <= 0 ! unit: " + MapClientStampUtil.getUnitId(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp)));
            return keepaliveTimeout;
        }
        long lastKeepaliveTimestamp = MapClientStampUtil.getLastKeepaliveTimestamp(mapClientStamp);
        if (debug) {
            String unit = MapClientStampUtil.getUnitName(mapClientStamp) + "(" + MapClientStampUtil.getUnitId(mapClientStamp) + ")";
            log.debug((Object)(method + "unit " + unit + ", lastKeepaliveTimestamp=" + lastKeepaliveTimestamp + ", keepaliveTimeout=" + keepaliveTimeout + ", currentTime=" + currentTime));
        }
        if (lastKeepaliveTimestamp == 0L) {
            if (debug) {
                log.info((Object)(method + "no keep alive found, return 0 (unitSymbolName/unitName/unitId=" + MapClientStampUtil.getUnitSymbolName(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "/" + MapClientStampUtil.getUnitId(mapClientStamp) + ")"));
            }
            return 0L;
        }
        long remainingKeepaliveTime = lastKeepaliveTimestamp + keepaliveTimeout - currentTime + 500L;
        if (debug) {
            log.debug((Object)(method + "remainingKeepaliveTime = lastKeepaliveTimestamp + keepaliveTimeout - currentTime + 500"));
            log.debug((Object)(method + "-> " + remainingKeepaliveTime + " = " + lastKeepaliveTimestamp + " + " + keepaliveTimeout + " - " + currentTime + " + 500"));
            log.debug((Object)(method + "remainingKeepaliveTime = " + remainingKeepaliveTime / 1000L + "s or " + remainingKeepaliveTime / 60000L + "m or " + remainingKeepaliveTime / 3600000L + "h"));
        }
        if (remainingKeepaliveTime < 1L) {
            log.warn((Object)(method + "remaining time < 1, unit timed out?"));
        }
        return remainingKeepaliveTime;
    }

    public static boolean isKeepaliveTimeoutReached(Map mapClientStamp, long keepaliveTimeout, long currentTime) {
        String method = "isKeepaliveTimeoutReached(): ";
        if (currentTime <= 0L) {
            log.error((Object)(method + "currentTime <= 0 ! unit: " + MapClientStampUtil.getUnitId(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp)));
            return true;
        }
        long lastKeepaliveTimestamp = MapClientStampUtil.getLastKeepaliveTimestamp(mapClientStamp);
        if (lastKeepaliveTimestamp == 0L) {
            return true;
        }
        return currentTime - lastKeepaliveTimestamp > keepaliveTimeout;
    }

    public static boolean isFilterPassed(Map mapClientStamp) {
        boolean val;
        if (MapClientStampUtil.containsKey(mapClientStamp, "FilterPassed")) {
            val = MapClientStampUtil.booleanValue(mapClientStamp, "FilterPassed");
        } else {
            log.error((Object)("isFilterPassed(): no FILTER_PASSED information found for unit " + MapClientStampUtil.getUnitId(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "! Return FALSE (unit did not pass the filter). (unitSymbolName/unitName/unitId=" + MapClientStampUtil.getUnitSymbolName(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "/" + MapClientStampUtil.getUnitId(mapClientStamp) + ")"));
            val = false;
        }
        return val;
    }

    public static boolean isVisible(Map mapClientStamp, boolean debug) {
        boolean filterPassed = MapClientStampUtil.isFilterPassed(mapClientStamp);
        boolean containsGPSPosition = MapClientStampUtil.containsGPSPosition(mapClientStamp);
        if (debug) {
            log.debug((Object)("isVisible(): unit=" + MapClientStampUtil.getUnitId(mapClientStamp) + ", filterPassed=" + filterPassed + ", containsGPSPosition=" + containsGPSPosition));
            log.debug((Object)("isVisible(): unit=" + MapClientStampUtil.getUnitId(mapClientStamp) + ", isVisible=" + (filterPassed && containsGPSPosition)));
        }
        return filterPassed && containsGPSPosition;
    }

    public static String getLastIPMessage(Map mapClientStamp) {
        String msg = MapClientStampUtil.stringValue(mapClientStamp, "SmIpMessage");
        if (msg == null) {
            return "";
        }
        String search = "current IP: ";
        int index = msg.indexOf(search);
        if (index >= 0) {
            msg = msg.substring(search.length());
        }
        if ((index = msg.indexOf(search = "/")) >= 0) {
            msg = msg.substring(0, index);
        }
        return msg;
    }

    public static String getLastBootMessage(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "SmBootMessage");
    }

    public static String[] getLastBootMessageParts(Map mapClientStamp) {
        StringTokenizer st;
        String search;
        String snr = "";
        String versionLong = "";
        String versionShort = "";
        String infomanTypeShort = "";
        String msg = MapClientStampUtil.getLastBootMessage(mapClientStamp);
        int index = msg.indexOf(search = ";");
        if (index < 0) {
            int i;
            st = new StringTokenizer(msg, " ");
            if (st.hasMoreTokens()) {
                snr = st.nextToken();
            }
            for (i = 1; i <= 1; ++i) {
                if (!st.hasMoreTokens()) continue;
                snr = snr + " " + st.nextToken();
            }
            if (st.hasMoreTokens()) {
                versionLong = st.nextToken();
            }
            for (i = 1; i <= 6; ++i) {
                if (!st.hasMoreTokens()) continue;
                versionLong = versionLong + " " + st.nextToken();
            }
            if (st.hasMoreTokens()) {
                infomanTypeShort = st.nextToken();
            }
        } else {
            st = new StringTokenizer(msg, ";");
            if (st.hasMoreTokens()) {
                snr = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                versionLong = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                infomanTypeShort = st.nextToken();
            }
        }
        search = "boot: ";
        index = snr.indexOf(search);
        if (index >= 0) {
            snr = snr.substring(search.length());
        }
        if ((index = versionLong.indexOf(search = " - ")) >= 0) {
            versionShort = versionLong.substring(0, index);
        }
        String infomanTypeLong = infomanTypeShort.equals("P") ? "Phytec" : (infomanTypeShort.equals("P2") ? "Phytec II" : (infomanTypeShort.equals("T") ? "Toradex" : (infomanTypeShort.length() < 1 ? "(maybe Axotec)" : "[unknown type '" + infomanTypeShort + "']")));
        String[] parts = new String[]{snr, versionShort, versionLong, infomanTypeShort, infomanTypeLong};
        return parts;
    }

    public static String getDriverName(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "UseEventDriverName");
    }

    public static boolean isDriverLogin(Map mapClientStamp) {
        return MapClientStampUtil.booleanValue(mapClientStamp, "UseEventLogin");
    }

    public static String getStaffNo(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "UseEventPersonalNumber");
    }

    public static List<Integer> getStateModelIds(Map mapClientStamp) {
        return MapClientStampUtil.getIDs(mapClientStamp, "StateModel_");
    }

    public static List<Integer> getMeasurementDefnIds(Map mapClientStamp) {
        return MapClientStampUtil.getIDs(mapClientStamp, "Measurement_");
    }

    private static List<Integer> getIDs(Map mapClientStamp, String prefix) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Iterator ite = mapClientStamp.keySet().iterator();
        while (ite.hasNext()) {
            int smId;
            String key = ite.next().toString();
            if (!key.startsWith(prefix)) continue;
            try {
                smId = Integer.parseInt(StringUtils.removeStart((String)key, (String)prefix));
            }
            catch (Throwable ex) {
                continue;
            }
            ret.add(smId);
        }
        return ret;
    }

    public static Map<Integer, Map> getStateModels(Map mapClientStamp) {
        HashMap<Integer, Map> ret = new HashMap<Integer, Map>();
        Iterator ite = mapClientStamp.keySet().iterator();
        while (ite.hasNext()) {
            int smId;
            String key = ite.next().toString();
            if (!key.startsWith("StateModel_")) continue;
            try {
                smId = Integer.parseInt(StringUtils.removeStart((String)key, (String)"StateModel_"));
            }
            catch (Throwable ex) {
                continue;
            }
            Object val = mapClientStamp.get(key);
            Map stateMap = null;
            if (val != null && val instanceof Map) {
                stateMap = (Map)val;
            }
            ret.put(smId, stateMap);
        }
        return ret;
    }

    public static Integer getStateModelState(Map mapClientStamp, int stateModelId) {
        Object val;
        if (MapClientStampUtil.containsStateModelState(mapClientStamp, stateModelId) && (val = MapClientStampUtil.getValue(mapClientStamp, "StateModel_" + stateModelId)) != null && val instanceof Map) {
            Map stateMap = (Map)val;
            return MapClientStampUtil.intValue(stateMap, "StateId");
        }
        return null;
    }

    public static Long getStateModelBegin(Map mapClientStamp, int stateModelId) {
        Object val;
        if (MapClientStampUtil.containsStateModelState(mapClientStamp, stateModelId) && (val = MapClientStampUtil.getValue(mapClientStamp, "StateModel_" + stateModelId)) != null && val instanceof Map) {
            Map stateMap = (Map)val;
            return MapClientStampUtil.longValue(stateMap, "StateBegin");
        }
        log.warn((Object)("getStateModelBegin(): no begin time for state model '" + stateModelId + "' found! Return null. (unitSymbolName/unitName/unitId=" + MapClientStampUtil.getUnitSymbolName(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "/" + MapClientStampUtil.getUnitId(mapClientStamp) + ")"));
        return null;
    }

    public static String getStateModelRemark(Map mapClientStamp, int stateModelId) {
        Object val;
        if (MapClientStampUtil.containsStateModelState(mapClientStamp, stateModelId) && (val = MapClientStampUtil.getValue(mapClientStamp, "StateModel_" + stateModelId)) != null && val instanceof Map) {
            Map stateMap = (Map)val;
            return MapClientStampUtil.stringValue(stateMap, "StateRemark");
        }
        log.warn((Object)("getStateModelRemark(): no remark for state model '" + stateModelId + "' found! Return null. (unitSymbolName/unitName/unitId=" + MapClientStampUtil.getUnitSymbolName(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "/" + MapClientStampUtil.getUnitId(mapClientStamp) + ")"));
        return null;
    }

    public static String getMeasurementValue(Map mapClientStamp, int measurementDefnId, String pattern) {
        Object map;
        if (MapClientStampUtil.containsMeasurementValue(mapClientStamp, measurementDefnId) && (map = MapClientStampUtil.getValue(mapClientStamp, "Measurement_" + measurementDefnId)) != null && map instanceof Map) {
            Map measurmentMap = (Map)map;
            String val = MapClientStampUtil.stringValue(measurmentMap, "MeasurementValue");
            if (pattern != null && pattern.length() > 0) {
                DecimalFormat myFormatter = new DecimalFormat(pattern);
                try {
                    val = myFormatter.format(new Double(val));
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)("getMeasurementValue(): string '" + val + "' does not contain a parsable number"), (Throwable)nfe);
                }
                catch (IllegalArgumentException iae) {
                    log.error((Object)("getMeasurementValue(): invalid pattern '" + pattern + "', value '" + val + "'"), (Throwable)iae);
                }
            }
            return val;
        }
        log.warn((Object)("getMeasurementValue(): no value for  measurement defn '" + measurementDefnId + "' found! Return null. (unitSymbolName/unitName/unitId=" + MapClientStampUtil.getUnitSymbolName(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "/" + MapClientStampUtil.getUnitId(mapClientStamp) + ")"));
        return null;
    }

    public static Long getMeasurementBegin(Map mapClientStamp, int measurementDefnId) {
        Object val;
        if (MapClientStampUtil.containsMeasurementValue(mapClientStamp, measurementDefnId) && (val = MapClientStampUtil.getValue(mapClientStamp, "Measurement_" + measurementDefnId)) != null && val instanceof Map) {
            Map measurmentMap = (Map)val;
            return MapClientStampUtil.longValue(measurmentMap, "MeasurementBegin");
        }
        log.warn((Object)("getMeasurementBegin(): no begin time for measurement defn '" + measurementDefnId + "' found! Return null. (unitSymbolName/unitName/unitId=" + MapClientStampUtil.getUnitSymbolName(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + "/" + MapClientStampUtil.getUnitId(mapClientStamp) + ")"));
        return null;
    }

    public static String getInfomanSN(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanInfomanSN");
    }

    public static String getInfomanSWVersion(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanSoftwareVersion");
    }

    public static String getInfomanRootFSVersion(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanRootFSVersion");
    }

    public static String getInfomanKernelVersion(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanKernelVersion");
    }

    public static String getInfomanPowermanagementVersion(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanPMVersion");
    }

    public static String getInfomanJavaVMVersion(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanJavaVMVersion");
    }

    public static String getInfomanHardware(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanHardware");
    }

    public static String getInfomanHardwareSN(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanHardwareSN");
    }

    public static String getInfomanConfigurationName(Map mapClientStamp) {
        return MapClientStampUtil.stringValue(mapClientStamp, "infomanConfigurationName");
    }

    public static boolean isInfomanConfigurationUpToDate(Map mapClientStamp) {
        return MapClientStampUtil.booleanValue(mapClientStamp, "infomanConfigurationUpToDate");
    }

    public static long longValue(Map mapClientStamp, String key) {
        String method = "longValue(): ";
        Object val = MapClientStampUtil.getValue(mapClientStamp, key);
        if (val != null) {
            return Long.valueOf(val.toString());
        }
        return 0L;
    }

    public static int intValue(Map mapClientStamp, String key) {
        String method = "intValue(): ";
        Object val = MapClientStampUtil.getValue(mapClientStamp, key);
        if (val != null) {
            return Integer.valueOf(val.toString());
        }
        return 0;
    }

    public static boolean booleanValue(Map mapClientStamp, String key) {
        String method = "booleanValue(): ";
        Object val = MapClientStampUtil.getValue(mapClientStamp, key);
        if (val != null) {
            return Boolean.valueOf(val.toString());
        }
        return false;
    }

    public static String stringValue(Map mapClientStamp, String key) {
        String method = "stringValue(): ";
        Object val = MapClientStampUtil.getValue(mapClientStamp, key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public static String stringValueNotNull(Map mapClientStamp, String key) {
        String value = MapClientStampUtil.stringValue(mapClientStamp, key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static Object getValue(Map mapClientStamp, String key) {
        return mapClientStamp.get(key);
    }

    public static boolean containsKey(Map mapClientStamp, Object key) {
        return mapClientStamp.containsKey(key);
    }

    public static boolean containsStateModelState(Map mapClientStamp, int stateModelId) {
        Object val;
        if (MapClientStampUtil.containsKey(mapClientStamp, "StateModel_" + stateModelId) && (val = MapClientStampUtil.getValue(mapClientStamp, "StateModel_" + stateModelId)) != null && val instanceof Map) {
            Map stateMap = (Map)val;
            return stateMap.containsKey("StateId");
        }
        return false;
    }

    public static boolean containsStateModelBegin(Map mapClientStamp, int stateModelId) {
        Object val;
        if (MapClientStampUtil.containsKey(mapClientStamp, "StateModel_" + stateModelId) && (val = MapClientStampUtil.getValue(mapClientStamp, "StateModel_" + stateModelId)) != null && val instanceof Map) {
            Map stateMap = (Map)val;
            return stateMap.containsKey("StateBegin");
        }
        return false;
    }

    public static boolean containsStateModelRemark(Map mapClientStamp, int stateModelId) {
        Object val;
        if (MapClientStampUtil.containsKey(mapClientStamp, "StateModel_" + stateModelId) && (val = MapClientStampUtil.getValue(mapClientStamp, "StateModel_" + stateModelId)) != null && val instanceof Map) {
            Map stateMap = (Map)val;
            return stateMap.containsKey("StateRemark");
        }
        return false;
    }

    public static boolean containsMeasurementValue(Map mapClientStamp, int measurementDefnId) {
        Object val;
        if (MapClientStampUtil.containsKey(mapClientStamp, "Measurement_" + measurementDefnId) && (val = MapClientStampUtil.getValue(mapClientStamp, "Measurement_" + measurementDefnId)) != null && val instanceof Map) {
            Map measurementMap = (Map)val;
            return measurementMap.containsKey("MeasurementValue");
        }
        return false;
    }

    public static boolean containsMeasurementBegin(Map mapClientStamp, int measurementDefnId) {
        Object val;
        if (MapClientStampUtil.containsKey(mapClientStamp, "Measurement_" + measurementDefnId) && (val = MapClientStampUtil.getValue(mapClientStamp, "Measurement_" + measurementDefnId)) != null && val instanceof Map) {
            Map measurementMap = (Map)val;
            return measurementMap.containsKey("MeasurementBegin");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNotify(Map mapClientStamp, NotifyEvent ne) {
        long unitId = MapClientStampUtil.getUnitId(mapClientStamp);
        Object lock = notifyLocks.get(unitId);
        if (lock == null) {
            lock = new Object();
            notifyLocks.put(unitId, lock);
        }
        Object v = lock;
        synchronized (v) {
            TreeMap<Long, NotifyEvent> notifysMap = (TreeMap<Long, NotifyEvent>)mapClientStamp.get("NotifyEvents");
            if (notifysMap == null) {
                notifysMap = new TreeMap<Long, NotifyEvent>();
            }
            if (!notifysMap.containsValue(ne)) {
                long key = ne.getTimestamp();
                while (notifysMap.containsKey(key)) {
                    ++key;
                }
                notifysMap.put(key, new NotifyEvent(ne.getUnitId(), ne.getMessageId(), ne.getMessage(), ne.isEntry(), key, ne.getReceiveTime()));
                mapClientStamp.put("NotifyEvents", notifysMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNotify(Map mapClientStamp, NotifyEvent ne) {
        long unitId = MapClientStampUtil.getUnitId(mapClientStamp);
        Object lock = notifyLocks.get(unitId);
        if (lock == null) {
            lock = new Object();
            notifyLocks.put(unitId, lock);
        }
        Object v = lock;
        synchronized (v) {
            Map notifysMap = (Map)mapClientStamp.get("NotifyEvents");
            if (notifysMap != null) {
                notifysMap.remove(ne.getTimestamp());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, NotifyEvent> getNotifys(Map mapClientStamp) {
        Map ret;
        long unitId = MapClientStampUtil.getUnitId(mapClientStamp);
        Object lock = notifyLocks.get(unitId);
        if (lock == null) {
            lock = new Object();
            notifyLocks.put(unitId, lock);
        }
        Object v = lock;
        synchronized (v) {
            ret = (Map)mapClientStamp.get("NotifyEvents");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, NotifyEvent> getNotifysClone(Map mapClientStamp) {
        long unitId = MapClientStampUtil.getUnitId(mapClientStamp);
        Object lock = notifyLocks.get(unitId);
        if (lock == null) {
            lock = new Object();
            notifyLocks.put(unitId, lock);
        }
        TreeMap<Long, NotifyEvent> ret = null;
        Object v = lock;
        synchronized (v) {
            Map notifies = (Map)mapClientStamp.get("NotifyEvents");
            if (notifies != null) {
                ret = new TreeMap<Long, NotifyEvent>(notifies);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNotifys(Map mapClientStamp, Map<Long, NotifyEvent> notifies) {
        long unitId = MapClientStampUtil.getUnitId(mapClientStamp);
        Object lock = notifyLocks.get(unitId);
        if (lock == null) {
            lock = new Object();
            notifyLocks.put(unitId, lock);
        }
        Object v = lock;
        synchronized (v) {
            mapClientStamp.put("NotifyEvents", notifies);
        }
    }

    public static void updateFilterPassed(Map mapClientStamp, Map otherMapClientStamp) {
        mapClientStamp.put("FilterPassed", MapClientStampUtil.isFilterPassed(otherMapClientStamp));
    }

    public static String getStandId(Map data) {
        String method = "getStandId(): ";
        if (data.containsKey("fstd")) {
            return MapClientStampUtil.stringValue(data, "fstd");
        }
        log.error((Object)(method + "stamp doesn't contain a stand id! Return empty String."));
        return "";
    }

    public static void merge(Map mapClientStamp, Map event, boolean debug) {
        String method = "merge(): ";
        event = new HashMap(event);
        for (Object eventKey : event.keySet()) {
            Object eventVal = event.get(eventKey);
            if (eventKey.equals("UnitId")) continue;
            if (eventKey.equals("NotifyEvents")) {
                Map<Long, NotifyEvent> n = MapClientStampUtil.getNotifys(mapClientStamp);
                Map eventN = (Map)eventVal;
                if (n == null || n.size() <= 0 && eventN != null && eventN.size() > 0) {
                    TreeMap<Long, NotifyEvent> tmpMap = new TreeMap<Long, NotifyEvent>();
                    Iterator ite = eventN.keySet().iterator();
                    while (ite.hasNext()) {
                        NotifyEvent ne = (NotifyEvent)eventN.get(ite.next());
                        long key = ne.getTimestamp();
                        while (tmpMap.containsKey(key)) {
                            ++key;
                        }
                        if (key != ne.getTimestamp()) {
                            ne = new NotifyEvent(ne.getUnitId(), ne.getMessageId(), ne.getMessage(), ne.isEntry(), key, ne.getReceiveTime());
                        }
                        tmpMap.put(key, ne);
                    }
                    MapClientStampUtil.setNotifys(mapClientStamp, tmpMap);
                    continue;
                }
                if (n == null || n.size() <= 0 || eventN == null || eventN.size() <= 0) continue;
                Iterator ite = eventN.keySet().iterator();
                while (ite.hasNext()) {
                    MapClientStampUtil.addNotify(mapClientStamp, (NotifyEvent)eventN.get(ite.next()));
                }
                continue;
            }
            if (mapClientStamp.containsKey(eventKey)) {
                mapClientStamp.put(eventKey, eventVal);
                if (!debug) continue;
                log.debug((Object)(method + "'" + eventKey + "' updated"));
                continue;
            }
            mapClientStamp.put(eventKey, eventVal);
            if (!debug) continue;
            log.debug((Object)(method + "'" + eventKey + "'/'" + eventVal + "' not in stamp. Insert."));
        }
    }

    public static void debugStamp(Map mapClientStamp) {
        String method = "debugStamp(): ";
        Iterator it = mapClientStamp.keySet().iterator();
        log.debug((Object)(method + "for unit " + MapClientStampUtil.getUnitId(mapClientStamp) + "/" + MapClientStampUtil.getUnitName(mapClientStamp) + ":"));
        while (it.hasNext()) {
            Object key = it.next();
            Object val = mapClientStamp.get(key);
            log.debug((Object)(method + "\t'" + key + "' = '" + val + "'"));
        }
    }

    public static String toString(Map<String, Object> mapClientStamp) {
        StringBuilder ret = new StringBuilder();
        ret.append(mapClientStamp.toString());
        ret.append("[");
        Iterator<String> it = mapClientStamp.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object value = mapClientStamp.get(key);
            ret.append(key);
            ret.append("='");
            if (value != null) {
                if (value instanceof Map) {
                    ret.append(MapClientStampUtil.toString((Map)value));
                } else if (value instanceof Object[]) {
                    ret.append(Arrays.toString((Object[])value));
                } else if (value instanceof int[]) {
                    ret.append(Arrays.toString((int[])value));
                } else if (value instanceof long[]) {
                    ret.append(Arrays.toString((long[])value));
                } else if (value instanceof float[]) {
                    ret.append(Arrays.toString((float[])value));
                } else if (value instanceof double[]) {
                    ret.append(Arrays.toString((double[])value));
                } else if (value instanceof Collection) {
                    ret.append(Arrays.toString(((Collection)value).toArray()));
                } else {
                    ret.append(value);
                }
            } else {
                ret.append(value);
            }
            ret.append("'");
        }
        ret.append("]");
        return ret.toString();
    }
}

