/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.time;

import de.proveo.util.time.DurationUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurationConverter {
    private static final Log log = LogFactory.getLog(DurationConverter.class);
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    public static final long MILLIS_PER_MONTH = 2678400000L;
    public static final long MILLIS_PER_YEAR = 31536000000L;

    public static final long convert(DurationUnit sourceUnit, long duration, DurationUnit destinationUnit) {
        if (sourceUnit == destinationUnit) {
            return duration;
        }
        if (sourceUnit != DurationUnit.Millisecond) {
            duration *= DurationConverter.unitToMillisFactor(sourceUnit);
        }
        if (destinationUnit != DurationUnit.Millisecond) {
            duration /= DurationConverter.unitToMillisFactor(destinationUnit);
        }
        return duration;
    }

    private static final long unitToMillisFactor(DurationUnit unit) {
        long factor = 1L;
        switch (unit) {
            case Second: {
                factor = 1000L;
                break;
            }
            case Minute: {
                factor = 60000L;
                break;
            }
            case Hour: {
                factor = 3600000L;
                break;
            }
            case Day: {
                factor = 86400000L;
                break;
            }
            case Week: {
                factor = 604800000L;
                break;
            }
            case Month: {
                factor = 2678400000L;
                break;
            }
            case Year: {
                factor = 31536000000L;
                break;
            }
            default: {
                log.error((Object)"Invalid argument passed to unitToMillisFactor()");
            }
        }
        return factor;
    }
}

