/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.threadPool;

import de.proveo.util.threadPool.WorkerThread;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPool {
    private static final Log log = LogFactory.getLog(ThreadPool.class);
    protected Thread[] threads = null;
    protected int threadCount;
    protected volatile boolean shutdown;
    private final Object lock = new Object();
    private final Object shutdownLock = new Object();
    protected String identifier;
    LinkedList<Runnable> assignments = new LinkedList();

    public ThreadPool(int size, String identifier) {
        this.threadCount = size;
        this.shutdown = true;
        this.identifier = identifier;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assign(Runnable runnableObj) {
        Object object = this.lock;
        synchronized (object) {
            this.assignments.add(runnableObj);
            this.lock.notify();
            if (log.isDebugEnabled()) {
                int size = this.assignments.size();
                int availableWorkerThreads = 0;
                int workerThreadsNull = 0;
                int workerThreadsNotAlive = 0;
                int workerThreadsInterrupted = 0;
                if (this.threads != null) {
                    for (int i = 0; i < this.threads.length; ++i) {
                        Thread thread = this.threads[i];
                        if (thread == null) {
                            ++workerThreadsNull;
                            continue;
                        }
                        if (!thread.isAlive()) {
                            ++workerThreadsNotAlive;
                            continue;
                        }
                        if (thread.isInterrupted()) {
                            ++workerThreadsInterrupted;
                            continue;
                        }
                        ++availableWorkerThreads;
                    }
                }
                if (size > this.threadCount || availableWorkerThreads < this.threadCount) {
                    log.debug((Object)(this.identifier + " Thread pool size has been exceeded. Queue size is " + size + ". (Available WorkerThreads=" + availableWorkerThreads + ": null=" + workerThreadsNull + ", not alive=" + workerThreadsNotAlive + ", interrupted=" + workerThreadsInterrupted + ")"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean initialize() {
        Object object = this.shutdownLock;
        synchronized (object) {
            boolean result = false;
            if (this.shutdown) {
                this.shutdown = false;
                this.threads = new WorkerThread[this.threadCount];
                for (int i = 0; i < this.threads.length; ++i) {
                    this.threads[i] = new WorkerThread(this);
                    this.threads[i].start();
                }
                result = true;
                log.debug((Object)("Thread pool with " + this.threadCount + " threads has been initialized!"));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            boolean result = false;
            if (!this.shutdown) {
                this.shutdown = true;
                Object object2 = this.lock;
                synchronized (object2) {
                    this.lock.notifyAll();
                }
                this.threads = null;
                result = true;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getAssignment() {
        Runnable runnableObj = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                while (!this.shutdown && this.assignments.isEmpty()) {
                    this.lock.wait();
                    if (!this.shutdown) continue;
                    return null;
                }
                runnableObj = this.assignments.poll();
            }
            catch (InterruptedException e) {
                log.error((Object)"getAssignment runs into InterruptedException: ", (Throwable)e);
            }
        }
        return runnableObj;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

