/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.text;

public class DurationFormat {
    private static final int DAYS_PER_YEAR = 365;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MS_PER_SECOND = 1000;
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_HOUR = 3600000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_YEAR = 31536000000L;
    private static final int YEAR_INDEX = 5;
    private static final int DAY_INDEX = 4;
    private static final int HOUR_INDEX = 3;
    private static final int MINUTE_INDEX = 2;
    private static final int SECOND_INDEX = 1;
    private static final int MILLISECOND_INDEX = 0;
    private static final int TIME_COMPONENT_SIZE = 6;
    private String format;

    public DurationFormat() {
    }

    public DurationFormat(String format) {
        this.setFormat(format);
    }

    public String format(long duration) {
        return this.format(duration, this.getFormat());
    }

    public String format(long duration, String formatPattern) {
        long[] timeComponents = this.calculate(duration);
        boolean dayExist = false;
        boolean hourExist = false;
        boolean millisecondExist = false;
        boolean minuteExist = false;
        boolean secondExist = false;
        boolean yearExist = false;
        String[] replace = new String[formatPattern.length()];
        boolean optional = false;
        boolean skipOptional = false;
        boolean skipDecided = false;
        String optionalBuffer = "";
        int digitCount = 1;
        boolean literal = false;
        int lastChar = 0;
        for (int i = 0; i < replace.length; ++i) {
            char c = formatPattern.charAt(i);
            if (literal && c != '\'') {
                replace[i] = new Character(c).toString();
            } else if (literal && c == '\'') {
                literal = false;
                if (lastChar == 39) {
                    replace[i] = new Character(c).toString();
                }
            } else if (c == '\'') {
                literal = true;
            } else if (c == '[') {
                optional = true;
                skipOptional = false;
                skipDecided = false;
                optionalBuffer = "";
            } else if (c == ']') {
                optional = false;
                skipOptional = false;
                skipDecided = false;
                optionalBuffer = "";
            } else if (c == '0') {
                ++digitCount;
            } else if (c == 'y') {
                replace[i] = this.format(timeComponents[5], optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                yearExist = true;
            } else if (c == 'D') {
                if (!yearExist) {
                    timeComponents[4] = timeComponents[4] + timeComponents[5] * 365L;
                    timeComponents[5] = 0L;
                }
                replace[i] = this.format(timeComponents[4], optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                dayExist = true;
            } else if (c == 'H') {
                if (!yearExist) {
                    timeComponents[4] = timeComponents[4] + timeComponents[5] * 365L;
                    timeComponents[5] = 0L;
                }
                if (!dayExist) {
                    timeComponents[3] = timeComponents[3] + timeComponents[4] * 24L;
                    timeComponents[4] = 0L;
                }
                replace[i] = this.format(timeComponents[3], optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                hourExist = true;
            } else if (c == 'm') {
                if (!yearExist) {
                    timeComponents[4] = timeComponents[4] + timeComponents[5] * 365L;
                    timeComponents[5] = 0L;
                }
                if (!dayExist) {
                    timeComponents[3] = timeComponents[3] + timeComponents[4] * 24L;
                    timeComponents[4] = 0L;
                }
                if (!hourExist) {
                    timeComponents[2] = timeComponents[2] + timeComponents[3] * 60L;
                    timeComponents[3] = 0L;
                }
                replace[i] = this.format(timeComponents[2], optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                minuteExist = true;
            } else if (c == 's') {
                if (!yearExist) {
                    timeComponents[4] = timeComponents[4] + timeComponents[5] * 365L;
                    timeComponents[5] = 0L;
                }
                if (!dayExist) {
                    timeComponents[3] = timeComponents[3] + timeComponents[4] * 24L;
                    timeComponents[4] = 0L;
                }
                if (!hourExist) {
                    timeComponents[2] = timeComponents[2] + timeComponents[3] * 60L;
                    timeComponents[3] = 0L;
                }
                if (!minuteExist) {
                    timeComponents[1] = timeComponents[1] + timeComponents[2] * 60L;
                    timeComponents[2] = 0L;
                }
                replace[i] = this.format(timeComponents[1], optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                secondExist = true;
            } else if (c == 'S') {
                if (!yearExist) {
                    timeComponents[4] = timeComponents[4] + timeComponents[5] * 365L;
                    timeComponents[5] = 0L;
                }
                if (!dayExist) {
                    timeComponents[3] = timeComponents[3] + timeComponents[4] * 24L;
                    timeComponents[4] = 0L;
                }
                if (!hourExist) {
                    timeComponents[2] = timeComponents[2] + timeComponents[3] * 60L;
                    timeComponents[3] = 0L;
                }
                if (!minuteExist) {
                    timeComponents[1] = timeComponents[1] + timeComponents[2] * 60L;
                    timeComponents[2] = 0L;
                }
                if (!secondExist) {
                    timeComponents[0] = timeComponents[0] + timeComponents[1] * 1000L;
                    timeComponents[1] = 0L;
                }
                replace[i] = this.format(timeComponents[0], optional, digitCount);
                if (optional && replace[i].length() == 0) {
                    skipOptional = true;
                } else {
                    replace[i] = optionalBuffer + replace[i];
                }
                skipDecided = true;
                digitCount = 1;
                millisecondExist = true;
            } else if (!optional || optional && !skipOptional) {
                if (!optional) {
                    replace[i] = new Character(c).toString();
                }
                if (skipDecided) {
                    replace[i] = new Character(c).toString();
                } else if (optional) {
                    optionalBuffer = optionalBuffer + new Character(c).toString();
                }
            }
            lastChar = c;
        }
        String str = this.concat(replace);
        return str;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        if (format == null || format.length() == 0) {
            throw new IllegalArgumentException("parameter format cannot be empty");
        }
        this.format = format;
    }

    private long[] calculate(long duration) {
        long[] timeComponents = new long[6];
        timeComponents[5] = duration / 31536000000L;
        timeComponents[4] = (duration -= timeComponents[5] * 31536000000L) / 86400000L;
        timeComponents[3] = (duration -= timeComponents[4] * 86400000L) / 3600000L;
        timeComponents[2] = (duration -= timeComponents[3] * 3600000L) / 60000L;
        timeComponents[1] = (duration -= timeComponents[2] * 60000L) / 1000L;
        timeComponents[0] = duration -= timeComponents[1] * 1000L;
        return timeComponents;
    }

    private String concat(String[] str) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == null || str[i].length() <= 0) continue;
            buffer.append(str[i]);
        }
        return buffer.toString();
    }

    private String format(long value, boolean optional, int digitCount) {
        int digitDiv = 0;
        StringBuilder buffer = new StringBuilder();
        if (value > 0L || !optional) {
            buffer.append(value);
            digitDiv = digitCount - buffer.length();
            if (digitDiv > 0) {
                for (int i = 0; i < digitDiv; ++i) {
                    buffer.insert(0, "0");
                }
            }
        }
        return buffer.toString();
    }
}

