/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.servlet.secure;

import de.proveo.util.ByteUtil;
import de.proveo.util.servlet.ByteArrayServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class ContentHashFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String hash;
        ByteArrayServletResponseWrapper wrappedResponse = new ByteArrayServletResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        try {
            hash = this.calculateHash(wrappedResponse.toByteArray());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ServletException((Throwable)ex);
        }
        wrappedResponse.addHeader("Content-SHA1", hash);
        IOUtils.write((byte[])wrappedResponse.toByteArray(), (OutputStream)response.getOutputStream());
    }

    protected String calculateHash(byte[] content) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return ByteUtil.toHexString(md.digest(content));
    }

    public void init(FilterConfig filterConfig) {
    }
}

