/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.servlet.header;

import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HeaderFilterResponseWrapper
extends HttpServletResponseWrapper {
    private final Set<String> filteredHeaders;

    public HeaderFilterResponseWrapper(HttpServletResponse response, Set<String> filteredHeaders) {
        super(response);
        this.filteredHeaders = filteredHeaders;
    }

    protected boolean isHeaderUnwanted(String name) {
        return this.filteredHeaders.contains(name);
    }

    public void addHeader(String name, String value) {
        if (!this.isHeaderUnwanted(name)) {
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (!this.isHeaderUnwanted(name)) {
            super.setHeader(name, value);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!this.isHeaderUnwanted(name)) {
            super.addDateHeader(name, date);
        }
    }

    public void setDateHeader(String name, long date) {
        if (!this.isHeaderUnwanted(name)) {
            super.setDateHeader(name, date);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this.isHeaderUnwanted(name)) {
            super.addIntHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!this.isHeaderUnwanted(name)) {
            super.setIntHeader(name, value);
        }
    }
}

