/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.servlet.comp;

import de.proveo.util.servlet.comp.CompressionResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CompressionServletResponseWrapper
extends HttpServletResponseWrapper {
    protected static final String info = "CompressionServletResponseWrapper";
    protected HttpServletResponse origResponse = null;
    protected PrintWriter writer = null;
    protected ServletOutputStream stream = null;
    protected String contentType = null;
    protected int threshold = 0;
    private int debug = 0;

    public CompressionServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.origResponse = response;
        if (this.debug > 1) {
            System.out.println("CompressionServletResponseWrapper constructor gets called");
        }
    }

    public ServletOutputStream createOutputStream() throws IOException {
        if (this.debug > 1) {
            System.out.println("createOutputStream gets called");
        }
        CompressionResponseStream stream = new CompressionResponseStream(this.origResponse);
        stream.setDebugLevel(this.debug);
        stream.setBuffer(this.threshold);
        return stream;
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        if (this.debug > 1) {
            System.out.println("flush buffer @ CompressionServletResponseWrapper");
        }
        ((CompressionResponseStream)this.stream).flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        if (this.debug > 1) {
            System.out.println("stream is set to " + this.stream + " in getOutputStream");
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        if (this.debug > 1) {
            System.out.println("stream is set to " + this.stream + " in getWriter");
        }
        String charEnc = this.origResponse.getCharacterEncoding();
        if (this.debug > 1) {
            System.out.println("character encoding is " + charEnc);
        }
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, charEnc)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public void setCompressionThreshold(int threshold) {
        if (this.debug > 1) {
            System.out.println("setCompressionThreshold to " + threshold);
        }
        this.threshold = threshold;
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String contentType) {
        if (this.debug > 1) {
            System.out.println("setContentType to " + contentType);
        }
        this.contentType = contentType;
        this.origResponse.setContentType(contentType);
    }

    public void setDebugLevel(int debug) {
        this.debug = debug;
    }

    private static String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        String afterCharset = afterSemi.substring(charsetLocation + 8);
        String encoding = afterCharset.trim();
        return encoding;
    }
}

