/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.service;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceInterceptor
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(ServiceInterceptor.class);
    private boolean invokeMethods = false;

    public Object intercept(Object instance, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
        log.debug((Object)("intercept method " + method.getName()));
        try {
            if (this.invokeMethods) {
                log.debug((Object)("invoke method " + method.getName()));
                return proxy.invokeSuper(instance, arguments);
            }
        }
        catch (Throwable t) {
            log.debug((Object)("intercept " + method.getName() + " runs into"), t);
        }
        return this.createReturnValue(method);
    }

    private Object createReturnValue(Method method) throws InstantiationException, IllegalAccessException {
        Class<?> type = method.getReturnType();
        if (type.isPrimitive()) {
            if (Void.TYPE.equals(type)) {
                return null;
            }
            return Array.get(Array.newInstance(type, 1), 0);
        }
        return type.newInstance();
    }

    public boolean isInvokeMethods() {
        return this.invokeMethods;
    }

    public void setInvokeMethods(boolean invokeMethods) {
        this.invokeMethods = invokeMethods;
    }
}

