/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.service;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import de.proveo.util.service.ServiceInstantiationException;
import de.proveo.util.service.ServiceInterceptor;
import de.proveo.util.service.ServiceNotFoundException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.jms.TopicConnectionFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.mx.util.MBeanServerLocator;

public class ServiceFactory {
    private static final Log log = LogFactory.getLog(ServiceFactory.class);
    private static ServiceFactory instance = new ServiceFactory();
    private InitialContext ctx;

    private ServiceFactory() {
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static ServiceFactory getInstance() {
        return instance;
    }

    private static boolean isTestEnvironment() {
        String container = System.getProperty("container");
        boolean isTestEnvironment = "openEJB".equals(container);
        return isTestEnvironment;
    }

    public DataSource getDataSource() throws NamingException {
        log.debug((Object)"getDataSource");
        if (ServiceFactory.isTestEnvironment()) {
            MysqlDataSource mysqlDataSource = new MysqlDataSource();
            Properties dsProperties = new Properties();
            try {
                dsProperties.load(new FileInputStream("datasource.properties"));
                mysqlDataSource.setServerName(dsProperties.getProperty("dataSource.serverName"));
                mysqlDataSource.setDatabaseName(dsProperties.getProperty("dataSource.databaseName"));
                mysqlDataSource.setPortNumber(Integer.parseInt(dsProperties.getProperty("dataSource.portNumber")));
                mysqlDataSource.setUser(dsProperties.getProperty("dataSource.user"));
                mysqlDataSource.setPassword(dsProperties.getProperty("dataSource.password"));
            }
            catch (FileNotFoundException e) {
                log.error((Object)"reading datasource.properties runs into", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"reading datasource.properties runs into", (Throwable)e);
            }
            return mysqlDataSource;
        }
        return (DataSource)this.ctx.lookup("java:/wwt");
    }

    public <I> I getService(Class<I> interfaceClass) throws ServiceNotFoundException, ServiceInstantiationException {
        if (ServiceFactory.isTestEnvironment()) {
            Enhancer enhancer = new Enhancer();
            enhancer.setInterfaces(new Class[]{interfaceClass});
            ServiceInterceptor serviceInterceptor = new ServiceInterceptor();
            String serviceName = ServiceFactory.getFieldValue(interfaceClass, "SERVICE_NAME");
            if (serviceName != null) {
                try {
                    Class<?> impl;
                    try {
                        impl = Class.forName(interfaceClass.getPackage().getName() + "." + serviceName + "Mock");
                    }
                    catch (ClassNotFoundException e) {
                        impl = Class.forName(interfaceClass.getPackage().getName() + "." + serviceName);
                    }
                    if (impl != null) {
                        enhancer.setSuperclass(impl);
                        serviceInterceptor.setInvokeMethods(true);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.debug((Object)("implementation class not found: " + serviceName));
                }
            } else {
                log.warn((Object)("Interface has no SERVICE_NAME declared: " + interfaceClass.getName()));
            }
            enhancer.setCallback((Callback)serviceInterceptor);
            return (I)enhancer.create();
        }
        String jndiName = ServiceFactory.getFieldValue(interfaceClass, "JNDI_NAME");
        if (jndiName == null) {
            throw new ServiceNotFoundException(interfaceClass.getName());
        }
        try {
            return this.getMBeanProxy(interfaceClass, jndiName);
        }
        catch (Exception e) {
            log.debug((Object)"runs into", (Throwable)e);
            throw new ServiceInstantiationException(jndiName);
        }
    }

    public <I> I getServiceByObjectName(Class<I> interfaceClass, String objectName) throws ServiceNotFoundException, ServiceInstantiationException {
        if (ServiceFactory.isTestEnvironment()) {
            return this.getService(interfaceClass);
        }
        try {
            return this.getMBeanProxy(interfaceClass, objectName);
        }
        catch (Exception e) {
            log.debug((Object)"runs into", (Throwable)e);
            throw new ServiceInstantiationException(objectName);
        }
    }

    public <I> I getService(Class<I> interfaceClass, String serviceName) throws ServiceNotFoundException, ServiceInstantiationException {
        if (ServiceFactory.isTestEnvironment()) {
            return this.getService(interfaceClass);
        }
        String packageName = interfaceClass.getPackage().getName();
        StringBuffer objectName = new StringBuffer(packageName);
        objectName.append(":service=");
        objectName.append(serviceName);
        try {
            return this.getMBeanProxy(interfaceClass, objectName.toString());
        }
        catch (Exception e) {
            log.debug((Object)"runs into", (Throwable)e);
            throw new ServiceInstantiationException(objectName.toString());
        }
    }

    public TopicConnectionFactory getTopicConnectionFactory() throws NamingException {
        this.ctx = new InitialContext();
        String jndiName = ServiceFactory.isTestEnvironment() ? "openejb:Resource/ConnectionFactory" : "java:/ConnectionFactory";
        return (TopicConnectionFactory)this.ctx.lookup(jndiName);
    }

    private static String getFieldValue(Class interfaceClass, String fieldName) {
        try {
            Field field = interfaceClass.getDeclaredField(fieldName);
            return (String)field.get(null);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public <I> I getMBeanProxy(Class<I> interfaceClass, String objectName) throws MalformedObjectNameException {
        MBeanServer server = MBeanServerLocator.locate();
        return MBeanServerInvocationHandler.newProxyInstance(server, new ObjectName(objectName), interfaceClass, false);
    }

    public <I> I getMBeanProxyRemote(Class<I> interfaceClass, String objectName) throws MalformedObjectNameException, NamingException {
        MBeanServerConnection server = (MBeanServerConnection)this.ctx.lookup("jmx/invoker/RMIAdaptor");
        return MBeanServerInvocationHandler.newProxyInstance(server, new ObjectName(objectName), interfaceClass, false);
    }
}

