/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.rest.interfaces;

import de.proveo.domain.values.datasync.xml.DatasyncXMLResourceValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLStatusValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLTaskValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLTasksResourceValue;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="info/xml")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public interface DatasyncWebServiceClient {
    @POST
    @Path(value="/task")
    public DatasyncXMLStatusValue createDatasyncTask(DatasyncXMLTaskValue var1);

    @POST
    @Path(value="/tasks")
    public List<DatasyncXMLTaskValue> createBatchDatasyncTask(DatasyncXMLTasksResourceValue var1) throws Exception;

    @POST
    @Path(value="/task/update")
    public void updateTask(DatasyncXMLTaskValue var1) throws Exception;

    @GET
    @Path(value="/task/{id}")
    public DatasyncXMLTaskValue getTask(@PathParam(value="id") long var1) throws Exception;

    @PUT
    @Path(value="/task/status/{tid}")
    public DatasyncXMLStatusValue getTaskStatus(@PathParam(value="tid") long var1);

    @GET
    @Path(value="/task/{tid}/resource/{rid}")
    public byte[] getResourceContent(@PathParam(value="tid") long var1, @PathParam(value="rid") long var3) throws Exception;

    @GET
    @Path(value="/task/resource/{rid}")
    public byte[] getResourceContent(@PathParam(value="rid") long var1) throws Exception;

    @PUT
    @Path(value="/task/updateResource")
    public DatasyncXMLResourceValue updateResource(DatasyncXMLResourceValue var1) throws Exception;

    @GET
    @Path(value="/task/getAllOpenTasks")
    public List<DatasyncXMLTaskValue> getAllOpenTasks() throws Exception;

    @PUT
    @Path(value="/task/{tid}/resource/{rid}")
    public void putResourceContent(@PathParam(value="tid") long var1, @PathParam(value="rid") long var3, InputStream var5) throws Exception;

    @PUT
    @Path(value="/task/{tid}/addresource")
    public DatasyncXMLResourceValue attachResourceContent(@PathParam(value="tid") long var1, DatasyncXMLResourceValue var3) throws Exception;

    @PUT
    @Path(value="/task/createResource/{identifier}")
    public DatasyncXMLResourceValue createResource(@PathParam(value="identifier") String var1, DatasyncXMLResourceValue var2) throws Exception;

    @PUT
    @Path(value="/task/cancel/{tid}/{remark}")
    public DatasyncXMLStatusValue cancelTask(@PathParam(value="tid") long var1, @PathParam(value="remark") String var3) throws Exception;

    @PUT
    @Path(value="/task/close/{tid}/{remark}")
    public void closeTask(@PathParam(value="tid") long var1, @PathParam(value="remark") String var3) throws Exception;

    @GET
    @Path(value="/resource/infos")
    public List<DatasyncXMLResourceValue> getAllResourceInfos();

    @GET
    @Path(value="/resource/{metavalue}")
    public List<DatasyncXMLResourceValue> getAllResourceInfos(@PathParam(value="metavalue") String var1);

    @GET
    @Path(value="/resource/{rid}")
    public DatasyncXMLResourceValue getResourceById(@PathParam(value="rid") long var1) throws Exception;
}

