/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.reflection;

import de.proveo.util.container.ContainerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionUtil {
    private static final Log log = LogFactory.getLog(ReflectionUtil.class);

    public static Field[] getAllDeclaredFields(Class<?> type) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.addAll(ContainerUtil.asArrayList(type.getDeclaredFields()));
        Class<?> superclass = type.getSuperclass();
        while (superclass != Object.class) {
            fieldList.addAll(ContainerUtil.asArrayList(superclass.getDeclaredFields()));
            superclass = superclass.getClass().getSuperclass();
        }
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    public static Object getFieldContent(Field field, Object instance) {
        if (!Modifier.isStatic(field.getModifiers()) && instance == null) {
            return null;
        }
        Object result = null;
        try {
            field.setAccessible(true);
            result = field.get(instance);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return result;
    }

    public static void setFieldContent(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }

    public static Field[] getFields(Class<?> type) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ReflectionUtil.getFieldsRecursively(type, fieldList);
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    public static Object invokeMethod(Object instance, Method method, Object[] arguments) {
        Object result = null;
        try {
            boolean accessible = true;
            if (!method.isAccessible()) {
                method.setAccessible(true);
                accessible = false;
            }
            if (arguments == null) {
                arguments = new Object[]{};
            }
            result = method.invoke(instance, arguments);
            if (!accessible) {
                method.setAccessible(false);
            }
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return result;
    }

    public static Field[] getAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ReflectionUtil.getFieldsRecursively(type, fieldList);
        int size = fieldList.size();
        for (int i = size - 1; i >= 0; --i) {
            if (((Field)fieldList.get(i)).getAnnotation(annotation) != null) continue;
            fieldList.remove(i);
        }
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    private static void getFieldsRecursively(Class<?> startingClass, List<Field> fieldList) {
        Field[] fields;
        for (Field field : fields = startingClass.getDeclaredFields()) {
            fieldList.add(field);
        }
        Class<?> superclass = startingClass.getSuperclass();
        if (superclass != Object.class) {
            ReflectionUtil.getFieldsRecursively(superclass, fieldList);
        }
    }

    public static Method[] getAnnotatedMethods(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        ReflectionUtil.getMethodsRecursively(type, methodList);
        int size = methodList.size();
        for (int i = size - 1; i >= 0; --i) {
            if (((Method)methodList.get(i)).getAnnotation(annotation) != null) continue;
            methodList.remove(i);
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    private static void getMethodsRecursively(Class<?> startingClass, List<Method> methodList) {
        Method[] methods;
        for (Method method : methods = startingClass.getDeclaredMethods()) {
            methodList.add(method);
        }
        Class<?> superclass = startingClass.getSuperclass();
        if (superclass != Object.class) {
            ReflectionUtil.getMethodsRecursively(superclass, methodList);
        }
    }
}

