/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math.angle.impl;

import de.proveo.util.math.angle.AngleParser;
import de.proveo.util.math.angle.impl.DegreeAngleParser;
import de.proveo.util.math.angle.impl.DegreeMinuteAngleParser;
import de.proveo.util.math.angle.impl.DegreeMinuteSecondAngleParser;

public class UnversalAngleParser
implements AngleParser {
    private static final AngleParser degreeAP = new DegreeAngleParser();
    private static final AngleParser degreeMinuteAP = new DegreeMinuteAngleParser();
    private static final AngleParser degreeMinuteSecondAP = new DegreeMinuteSecondAngleParser();

    @Override
    public double parse(String angle) throws NumberFormatException {
        if (angle == null) {
            throw new IllegalArgumentException("parameter angle cannot be null");
        }
        if (angle.indexOf(34) > -1 || angle.indexOf("''") > -1) {
            return degreeMinuteSecondAP.parse(angle);
        }
        if (angle.indexOf(39) > -1) {
            return degreeMinuteAP.parse(angle);
        }
        return degreeAP.parse(angle);
    }

    @Override
    public int parseIntoMS(String angle) throws NumberFormatException {
        if (angle == null) {
            throw new IllegalArgumentException("parameter angle cannot be null");
        }
        if (angle.indexOf(34) > -1 || angle.indexOf("''") > -1) {
            return degreeMinuteSecondAP.parseIntoMS(angle);
        }
        if (angle.indexOf(39) > -1) {
            return degreeMinuteAP.parseIntoMS(angle);
        }
        return degreeAP.parseIntoMS(angle);
    }
}

