/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math.angle.impl;

import de.proveo.util.math.angle.AngleFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class PatternAngleFormat
implements AngleFormat {
    private static final String DEFAULT_PATTERN = "d\u00b0 m'";
    private static final int DEFAULT_DIGITS = 4;
    private String pattern;
    private int digits = 4;

    public PatternAngleFormat() {
        this(DEFAULT_PATTERN);
    }

    public PatternAngleFormat(String pattern) {
        this.setPattern(pattern);
    }

    @Override
    public String format(int angle) {
        StringBuilder buffer = new StringBuilder();
        boolean degreeDone = false;
        boolean minuteDone = false;
        boolean secondDone = false;
        block5: for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            switch (c) {
                case 'd': {
                    if (degreeDone) continue block5;
                    buffer.append(this.formatDegree(angle));
                    degreeDone = true;
                    continue block5;
                }
                case 'm': {
                    if (minuteDone) continue block5;
                    buffer.append(this.formatMinute(angle));
                    minuteDone = true;
                    continue block5;
                }
                case 's': {
                    if (secondDone) continue block5;
                    buffer.append(this.formatSecond(angle));
                    secondDone = true;
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public String format(int angle, boolean isLongitude) {
        StringBuilder buffer = new StringBuilder();
        boolean degreeDone = false;
        boolean minuteDone = false;
        boolean secondDone = false;
        boolean hemisphereDone = false;
        block6: for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            switch (c) {
                case 'd': {
                    if (degreeDone) continue block6;
                    buffer.append(this.formatDegree(angle));
                    degreeDone = true;
                    continue block6;
                }
                case 'm': {
                    if (minuteDone) continue block6;
                    buffer.append(this.formatMinute(angle));
                    minuteDone = true;
                    continue block6;
                }
                case 's': {
                    if (secondDone) continue block6;
                    buffer.append(this.formatSecond(angle));
                    secondDone = true;
                    continue block6;
                }
                case 'h': {
                    if (hemisphereDone) continue block6;
                    buffer.append(this.formatHemisphere(angle, isLongitude));
                    hemisphereDone = true;
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public double getDegree(int angle, boolean direct) {
        if (angle < 0 && direct) {
            return (double)angle / 3600000.0 * -1.0;
        }
        return (double)angle / 3600000.0;
    }

    @Override
    public int getDigits() {
        return this.digits;
    }

    public double getMinute(int angle, boolean direct) {
        double minutes = (double)angle / 60000.0;
        int degrees = (int)this.getDegree(angle, false);
        double result = minutes - (double)degrees * 60.0;
        if (angle < 0 && direct) {
            return result * -1.0;
        }
        return result;
    }

    public String getPattern() {
        return this.pattern;
    }

    public double getSecond(int angle) {
        double second = (double)angle / 1000.0 - (double)((int)this.getDegree(angle, false) * 60 * 60) - (double)((int)this.getMinute(angle, false) * 60);
        if (second < 0.0) {
            return second * -1.0;
        }
        return second;
    }

    @Override
    public void setDigits(int digits) {
        if (digits < 0) {
            throw new IllegalArgumentException("parameter digits cannot be less then 0");
        }
        this.digits = digits;
    }

    public void setPattern(String pattern) {
        if (pattern == null || pattern.trim().equals("")) {
            throw new IllegalArgumentException("parameter pattern cannot be empty");
        }
        this.pattern = pattern;
    }

    protected String format(double value, int integerDigits, int fractionDigits) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumIntegerDigits(integerDigits);
        numberFormat.setMinimumFractionDigits(fractionDigits);
        numberFormat.setMaximumFractionDigits(fractionDigits);
        String str = numberFormat.format(value);
        return str;
    }

    protected String formatDegree(int angle) {
        double degree = this.getDegree(angle, true);
        if (this.getUseCount('m') == 0) {
            return this.format(degree, this.getUseCount('d'), this.digits);
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumIntegerDigits(this.getUseCount('d'));
        numberFormat.setMaximumFractionDigits(0);
        return numberFormat.format((int)degree);
    }

    protected String formatMinute(int angle) {
        double minute = this.getMinute(angle, true);
        if (this.getUseCount('s') == 0) {
            return this.format(minute, this.getUseCount('m'), this.digits);
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumIntegerDigits(this.getUseCount('m'));
        numberFormat.setMaximumFractionDigits(0);
        return numberFormat.format((int)minute);
    }

    protected String formatSecond(int angle) {
        double second = this.getSecond(angle);
        if (this.getUseCount('s') == 0) {
            return this.format(second, 0, this.digits);
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumIntegerDigits(this.getUseCount('s'));
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(second);
    }

    protected String formatHemisphere(int angle, boolean isLongitude) {
        if (angle < 0) {
            if (isLongitude) {
                return "W";
            }
            return "S";
        }
        if (isLongitude) {
            return "E";
        }
        return "N";
    }

    protected int getUseCount(char c) {
        int count = -1;
        int index = -1;
        do {
            index = this.pattern.indexOf(c, index + 1);
            ++count;
        } while (index > -1);
        return count;
    }
}

