/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;

public class NumberComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            return this.compareNumber(n1, n2);
        }
        throw new IllegalArgumentException("not a Number");
    }

    protected int compareNumber(Number n1, Number n2) {
        long l2;
        if (n1 instanceof BigDecimal && n2 instanceof BigDecimal) {
            BigDecimal bd1 = (BigDecimal)n1;
            BigDecimal bd2 = (BigDecimal)n2;
            return bd1.compareTo(bd2);
        }
        if (n1 instanceof BigInteger && n2 instanceof BigInteger) {
            BigInteger bi1 = (BigInteger)n1;
            BigInteger bi2 = (BigInteger)n2;
            return bi1.compareTo(bi2);
        }
        if (n1 instanceof Double && n2 instanceof Double || n1 instanceof Float && n2 instanceof Float) {
            double d2;
            double d1 = n1.doubleValue();
            if (d1 < (d2 = n2.doubleValue())) {
                return -1;
            }
            if (d1 == d2) {
                return 0;
            }
            return 1;
        }
        long l1 = n1.longValue();
        if (l1 < (l2 = n2.longValue())) {
            return -1;
        }
        if (l1 == l2) {
            return 0;
        }
        return 1;
    }
}

