/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math;

import de.proveo.util.math.LineMath;
import de.proveo.util.math.Point;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Line
implements Serializable {
    private Point begin;
    private Point end;

    public Line(Point begin, Point end) {
        if (begin == null || end == null) {
            throw new NullPointerException("parameter is null");
        }
        this.begin = begin;
        this.end = end;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Line)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Line that = (Line)obj;
        EqualsBuilder eqBuilder = new EqualsBuilder();
        eqBuilder.append((Object)this.begin, (Object)that.begin);
        eqBuilder.append((Object)this.end, (Object)that.end);
        return eqBuilder.isEquals();
    }

    public Point getBegin() {
        return this.begin;
    }

    public Point getEnd() {
        return this.end;
    }

    public int hashCode() {
        HashCodeBuilder hc = new HashCodeBuilder(33, 97);
        hc.append((Object)this.begin);
        hc.append((Object)this.end);
        return hc.toHashCode();
    }

    public boolean isPointOnLine(Point point) {
        if (LineMath.determinant(this.begin, this.end, point) == 0.0) {
            if (this.begin.getX() <= point.getX() && point.getX() <= this.end.getX() || this.end.getX() <= point.getX() && point.getX() <= this.begin.getX()) {
                return this.begin.getY() <= point.getY() && point.getY() <= this.end.getY() || this.end.getY() <= point.getY() && point.getY() <= this.begin.getY();
            }
            return false;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("begin", (Object)this.begin);
        toStringBuilder.append("end", (Object)this.end);
        return toStringBuilder.toString();
    }
}

