/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.logging;

import de.proveo.util.logging.LoggerStream;
import de.proveo.util.logging.OnlyOnceErrorHandler;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggerUtil {
    private static final Log log = LogFactory.getLog(LoggerUtil.class);
    public static final LoggerUtil INSTANCE = new LoggerUtil();
    private PrintStream out;
    private PrintStream err;

    private LoggerUtil() {
    }

    public void installSystemAdapters() {
        Logger logger = Logger.getLogger((String)"STDOUT");
        this.out = System.out;
        System.setOut(new LoggerStream(logger, Level.INFO, this.out));
        log.debug((Object)"Installed System.out adapter");
        logger = Logger.getLogger((String)"STDERR");
        this.err = System.err;
        OnlyOnceErrorHandler.setOutput(this.err);
        System.setErr(new LoggerStream(logger, Level.ERROR, this.err));
        log.debug((Object)"Installed System.err adapter");
    }

    public void uninstallSystemAdapters() {
        if (this.out != null) {
            System.out.flush();
            System.setOut(this.out);
            log.debug((Object)"Removed System.out adapter");
            this.out = null;
        }
        if (this.err != null) {
            System.err.flush();
            System.setErr(this.err);
            log.debug((Object)"Removed System.err adapter");
            this.err = null;
        }
    }
}

