/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.logging;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggerStream
extends PrintStream {
    private Logger logger;
    private Level level;
    private boolean issuedWarning;
    private ThreadLocal recursiveCheck = new ThreadLocal();

    public LoggerStream(Logger logger) {
        this(logger, Level.INFO, System.out);
    }

    public LoggerStream(Logger logger, Level level, PrintStream ps) {
        super(ps);
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void println(String msg) {
        if (msg == null) {
            msg = "null";
        }
        byte[] bytes = msg.getBytes();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void println(Object msg) {
        if (msg == null) {
            msg = "null";
        }
        byte[] bytes = msg.toString().getBytes();
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte b) {
        byte[] bytes = new byte[]{b};
        this.write(bytes, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Boolean recursed = (Boolean)this.recursiveCheck.get();
        if (recursed != null && recursed.equals(Boolean.TRUE)) {
            if (!this.issuedWarning) {
                String msg = "ERROR: invalid console appender config detected, console stream is looping";
                try {
                    this.out.write(msg.getBytes());
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                this.issuedWarning = true;
            }
            return;
        }
        while (len > 0 && (b[len - 1] == 10 || b[len - 1] == 13) && len > off) {
            --len;
        }
        if (len != 0) {
            String msg = new String(b, off, len);
            this.recursiveCheck.set(Boolean.TRUE);
            this.logger.log((Priority)this.level, (Object)msg);
            this.recursiveCheck.set(Boolean.FALSE);
        }
    }
}

