/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.kml.structs;

import de.proveo.util.kml.structs.GeoArea;

public class ValueGrid {
    public static final long NO_DATA_VALUE = -1L;
    private int latRects;
    private int lonRects;
    private GeoArea coveredArea;
    private long[][] valueArray;
    private long[][] countArray;
    private long gridSize;

    public ValueGrid(GeoArea coveredArea, long rectSize) {
        this.coveredArea = coveredArea;
        this.gridSize = rectSize;
        this.latRects = (int)Math.ceil((double)(coveredArea.maxLat - coveredArea.minLat) / (double)rectSize);
        this.lonRects = (int)Math.ceil((double)(coveredArea.maxLon - coveredArea.minLon) / (double)rectSize);
        this.valueArray = new long[this.latRects][this.lonRects];
        this.countArray = new long[this.latRects][this.lonRects];
        for (int latIdx = 0; latIdx != this.latRects; ++latIdx) {
            for (int lonIdx = 0; lonIdx != this.lonRects; ++lonIdx) {
                this.valueArray[latIdx][lonIdx] = -1L;
                this.countArray[latIdx][lonIdx] = -1L;
            }
        }
    }

    public GeoArea getCoverageArea() {
        return this.coveredArea;
    }

    public long getGridSize() {
        return this.gridSize;
    }

    public long getMinLatForRect(int latRect) {
        return this.coveredArea.minLat + (long)latRect * this.gridSize;
    }

    public long getMaxLatForRect(int latRect) {
        return this.coveredArea.minLat + (long)(latRect + 1) * this.gridSize;
    }

    public long getMinLonForRect(int lonRect) {
        return this.coveredArea.minLon + (long)lonRect * this.gridSize;
    }

    public long getMaxLonForRect(int lonRect) {
        return this.coveredArea.minLon + (long)(lonRect + 1) * this.gridSize;
    }

    public int getNumLatRects() {
        return this.latRects;
    }

    public int getNumLonRects() {
        return this.lonRects;
    }

    public long getValue(int latRect, int lonRect) {
        return this.valueArray[latRect][lonRect];
    }

    public void setValue(long value, int latRect, int lonRect) {
        this.valueArray[latRect][lonRect] = value;
    }

    public long getCount(int latRect, int lonRect) {
        return this.countArray[latRect][lonRect];
    }

    public void setCount(long value, int latRect, int lonRect) {
        this.countArray[latRect][lonRect] = value;
    }

    public long getMinLat() {
        return this.coveredArea.minLat;
    }

    public long getMaxLat() {
        return this.coveredArea.maxLat;
    }

    public long getMinLon() {
        return this.coveredArea.minLon;
    }

    public long getMaxLon() {
        return this.coveredArea.maxLon;
    }
}

