/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.kml.structs;

import de.proveo.util.kml.structs.GradientColor;
import java.awt.Color;
import java.io.Serializable;

public class ImageProperties
implements Serializable {
    private static final long serialVersionUID = 3651557990769286534L;
    private int scalingFactor;
    private float minValue;
    private float maxValue;
    private GradientColor[] gradientColors;
    private float[] gradientSteps;
    private float difference;
    private Color noDataColor = new Color(0, true);
    private Color belowMinColor;
    private Color aboveMaxColor;

    public ImageProperties() {
        this(1, 0.0f, 20000.0f, new GradientColor[]{new GradientColor(new Color(-1442775296, true), 0.0f), new GradientColor(new Color(-1426086656, true), 0.5f), new GradientColor(new Color(-1426128896, true), 1.0f)}, null);
    }

    public ImageProperties(int scalingFactor, float minValue, float maxValue, GradientColor[] gradientColors) {
        this(scalingFactor, minValue, maxValue, gradientColors, null);
    }

    public ImageProperties(int scalingFactor, float minValue, float maxValue, GradientColor[] gradientColors, Color noDataColor) {
        this.scalingFactor = scalingFactor;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.gradientColors = gradientColors;
        if (noDataColor != null) {
            this.noDataColor = noDataColor;
        }
        this.calculateGradientSteps();
    }

    private void calculateGradientSteps() {
        this.gradientSteps = new float[this.gradientColors.length - 1];
        this.difference = this.maxValue - this.minValue;
        for (int i = 0; i != this.gradientColors.length - 1; ++i) {
            this.gradientSteps[i] = (this.gradientColors[i + 1].position - this.gradientColors[i].position) * this.difference;
        }
        this.belowMinColor = this.gradientColors[0].color;
        this.aboveMaxColor = this.gradientColors[this.gradientColors.length - 1].color;
    }

    public Color getColor(long value) {
        Color color = null;
        if (value == -1L) {
            color = this.noDataColor;
        } else if ((float)value < this.minValue) {
            color = this.belowMinColor;
        } else if ((float)value > this.maxValue) {
            color = this.aboveMaxColor;
        } else {
            ColorInfo gradientColors = this.getGradientColors(value);
            float colorRange = this.difference * (gradientColors.highColor.position - gradientColors.lowColor.position);
            float ratio = ((float)value - this.minValue - this.difference * gradientColors.lowColor.position) / colorRange;
            int red = (int)((float)gradientColors.highColor.color.getRed() * ratio + (float)gradientColors.lowColor.color.getRed() * (1.0f - ratio));
            int green = (int)((float)gradientColors.highColor.color.getGreen() * ratio + (float)gradientColors.lowColor.color.getGreen() * (1.0f - ratio));
            int blue = (int)((float)gradientColors.highColor.color.getBlue() * ratio + (float)gradientColors.lowColor.color.getBlue() * (1.0f - ratio));
            int alpha = (int)((float)gradientColors.highColor.color.getAlpha() * ratio + (float)gradientColors.lowColor.color.getAlpha() * (1.0f - ratio));
            color = new Color(red, green, blue, alpha);
        }
        return color;
    }

    public int getColorValue(long value) {
        Color color = this.getColor(value);
        return (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
    }

    private ColorInfo getGradientColors(long value) {
        ColorInfo colorInfo = null;
        float position = ((float)value - this.minValue) / this.difference;
        for (int i = 0; i != this.gradientColors.length - 1; ++i) {
            if (!(position >= this.gradientColors[i].position) || !(position <= this.gradientColors[i + 1].position)) continue;
            return new ColorInfo(this.gradientColors[i], this.gradientColors[i + 1]);
        }
        return colorInfo;
    }

    public int getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(int scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public GradientColor[] getGradientColors() {
        return this.gradientColors;
    }

    public void setGradientColors(GradientColor[] gradientColors) {
        this.gradientColors = gradientColors;
        this.calculateGradientSteps();
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
        this.calculateGradientSteps();
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.calculateGradientSteps();
    }

    private static class ColorInfo {
        public GradientColor lowColor;
        public GradientColor highColor;

        public ColorInfo() {
        }

        public ColorInfo(GradientColor lowColor, GradientColor highColor) {
            this.lowColor = lowColor;
            this.highColor = highColor;
        }
    }
}

