/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.kml;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.GroundOverlay;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.LatLonBox;
import de.micromata.opengis.kml.v_2_2_0.LinearRing;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import de.proveo.util.kml.structs.FileInfo;
import de.proveo.util.kml.structs.GeoArea;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.util.kml.structs.GroundOverlayInfo;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KmlUtil {
    private static final Log log = LogFactory.getLog(KmlUtil.class);

    public static String kmlColor(Color color) {
        return String.format("%02X%02X%02X%02X", color.getAlpha(), color.getBlue(), color.getGreen(), color.getRed());
    }

    public static void writeKmz(String kmzFilename, String filename, byte[] data) {
        FileInfo fileInfo = new FileInfo(filename, data);
        KmlUtil.writeKmz(kmzFilename, fileInfo);
    }

    public static void writeKmz(String kmzFilename, FileInfo fileInfo) {
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>(1);
        fileList.add(fileInfo);
        KmlUtil.writeKmz(kmzFilename, fileList);
    }

    public static void writeKmz(String filename, List<FileInfo> fileInfo) {
        KmlUtil.writeFile(filename, KmlUtil.writeKmz(fileInfo));
    }

    public static byte[] writeKmz(String filename, byte[] data) {
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>(1);
        fileList.add(new FileInfo(filename, data));
        return KmlUtil.writeKmz(fileList);
    }

    public static byte[] writeKmz(FileInfo fileInfo) {
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>(1);
        fileList.add(fileInfo);
        return KmlUtil.writeKmz(fileList);
    }

    public static byte[] writeKmz(List<FileInfo> fileInfo) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zip = new ZipOutputStream(baos);
            for (FileInfo fi : fileInfo) {
                zip.putNextEntry(new ZipEntry(fi.filename));
                zip.write(fi.content);
                zip.closeEntry();
            }
            zip.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
            return null;
        }
    }

    public static byte[] serialize(Kml kml) {
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            kml.marshal((OutputStream)baos);
            data = baos.toByteArray();
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return data;
    }

    public static void writeKml(String filename, Kml kml) {
        KmlUtil.writeFile(filename, KmlUtil.serialize(kml));
    }

    public static LinearRing createLinearRing(GeoPoint[] points) {
        return KmlUtil.createLinearRing(points, 0.0);
    }

    public static LinearRing createLinearRing(GeoPoint[] points, double altitude) {
        if (points.length == 0) {
            return null;
        }
        LinearRing linearRing = new LinearRing();
        for (GeoPoint point : points) {
            linearRing.addToCoordinates(KmlUtil.millisToDegrees(point.longitude), KmlUtil.millisToDegrees(point.latitude), altitude);
        }
        if (!points[0].equals(points[points.length - 1])) {
            linearRing.addToCoordinates(KmlUtil.millisToDegrees(points[0].longitude), KmlUtil.millisToDegrees(points[0].latitude), altitude);
        }
        return linearRing;
    }

    public static Point createPoint(GeoPoint geoPoint) {
        if (geoPoint == null) {
            return null;
        }
        Point point = new Point();
        point.addToCoordinates(KmlUtil.millisToDegrees(geoPoint.longitude), KmlUtil.millisToDegrees(geoPoint.latitude));
        return point;
    }

    public static LatLonBox createLatLonBox(long northMillis, long southMillis, long eastMillis, long westMillis) {
        return KmlUtil.createLatLonBox(northMillis, southMillis, eastMillis, westMillis, 0.0);
    }

    public static LatLonBox createLatLonBox(long northMillis, long southMillis, long eastMillis, long westMillis, double rotation) {
        return KmlUtil.createLatLonBox(KmlUtil.millisToDegrees(northMillis), KmlUtil.millisToDegrees(southMillis), KmlUtil.millisToDegrees(eastMillis), KmlUtil.millisToDegrees(westMillis), rotation);
    }

    public static LatLonBox createLatLonBox(double north, double south, double east, double west) {
        return KmlUtil.createLatLonBox(north, south, east, west, 0.0);
    }

    public static LatLonBox createLatLonBox(double north, double south, double east, double west, double rotation) {
        LatLonBox latLonBox = new LatLonBox();
        latLonBox.setNorth(north);
        latLonBox.setSouth(south);
        latLonBox.setEast(east);
        latLonBox.setWest(west);
        latLonBox.setRotation(rotation);
        return latLonBox;
    }

    public static double millisToDegrees(long milliseconds) {
        return (double)milliseconds / 3600000.0;
    }

    public static long degreesToMillis(double degrees) {
        return (long)(degrees * 3600000.0);
    }

    public static <T extends Document, Folder> Placemark createAndAddPlacemark(T container, String name, String description, long lonMillis, long latMillis) {
        Placemark placemark = container.createAndAddPlacemark();
        placemark.setName(name);
        placemark.setDescription(description);
        Point point = placemark.createAndSetPoint();
        point.addToCoordinates(KmlUtil.millisToDegrees(lonMillis), KmlUtil.millisToDegrees(latMillis));
        return placemark;
    }

    public static <T extends Document, Folder> GroundOverlay createAndAddGroundOverlay(T container, GroundOverlayInfo groundOverlayInfo, GeoArea geoArea) {
        GroundOverlay groundOverlay = container.createAndAddGroundOverlay();
        groundOverlay.setName(groundOverlayInfo.groundOverlayName);
        groundOverlay.setDescription(groundOverlayInfo.groundOverlayDescription);
        groundOverlay.setVisibility(Boolean.valueOf(true));
        Icon icon = groundOverlay.createAndSetIcon();
        icon.setHref(groundOverlayInfo.imageUrl);
        LatLonBox latLonBox = KmlUtil.createLatLonBox(geoArea.minLat, geoArea.maxLat, geoArea.minLon, geoArea.maxLon);
        groundOverlay.setLatLonBox(latLonBox);
        return groundOverlay;
    }

    public static void writeFile(String filename, byte[] data) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(data);
            fos.close();
        }
        catch (IOException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }
}

