/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.helper;

import java.util.Calendar;
import java.util.TimeZone;

public abstract class BaseHelperUtil {
    private static final long TO_DAYS_COEFFICIENT = 86400000L;

    public static int[] roundToDaystamps(long beginstamp, long endstamp) {
        Calendar calBegin = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Calendar calEnd = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        if (beginstamp == 0L) {
            int[] ret;
            ret = new int[]{BaseHelperUtil.roundToDaystamp(endstamp), ret[0]};
            return ret;
        }
        if (beginstamp > endstamp) {
            calBegin.setTimeInMillis(endstamp);
            calEnd.setTimeInMillis(beginstamp);
        } else {
            calBegin.setTimeInMillis(beginstamp);
            calEnd.setTimeInMillis(endstamp);
        }
        int days = 0;
        boolean yearchange = false;
        int lastDayOfYear = 0;
        if (calBegin.get(1) == calEnd.get(1)) {
            if (calBegin.get(6) == calEnd.get(6)) {
                days = 1;
            } else {
                days = calEnd.get(6) - calBegin.get(6);
                ++days;
            }
        } else {
            yearchange = true;
            Calendar tmpCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            tmpCal.setTimeInMillis(0L);
            tmpCal.set(1, calBegin.get(1));
            lastDayOfYear = tmpCal.getActualMaximum(6);
            days = calEnd.get(6) + (lastDayOfYear - calBegin.get(6)) + 1;
        }
        int[] ret = new int[]{};
        try {
            ret = new int[days];
        }
        catch (Exception exc) {
            // empty catch block
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(beginstamp);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ret[0] = BaseHelperUtil.daystampConversion(cal.getTimeInMillis());
        if (!yearchange) {
            for (int i = 1; i < days; ++i) {
                cal.set(6, cal.get(6) + 1);
                ret[i] = BaseHelperUtil.daystampConversion(cal.getTimeInMillis());
            }
        } else {
            for (int i = 1; i < days; ++i) {
                if (cal.get(6) < lastDayOfYear) {
                    cal.set(6, cal.get(6) + 1);
                    ret[i] = BaseHelperUtil.daystampConversion(cal.getTimeInMillis());
                    continue;
                }
                if (cal.get(6) != lastDayOfYear) continue;
                cal.set(1, cal.get(1) + 1);
                cal.set(6, 1);
                ret[i] = BaseHelperUtil.daystampConversion(cal.getTimeInMillis());
            }
        }
        return ret;
    }

    public static int roundToDaystamp(long timestamp) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(timestamp);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return BaseHelperUtil.daystampConversion(cal.getTimeInMillis());
    }

    private static int daystampConversion(long ts) {
        return (int)(ts / 86400000L);
    }
}

