/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.geo;

import de.proveo.util.date.DateUtil;
import de.proveo.util.math.angle.AngleFormat;
import de.proveo.util.math.angle.AngleParser;
import de.proveo.util.math.angle.impl.PatternAngleFormat;
import de.proveo.util.math.angle.impl.UnversalAngleParser;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GPSPosition
implements Serializable {
    private static final Log log = LogFactory.getLog(GPSPosition.class);
    private static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+00:00");
    public static float MSEC_TO_METER_LONGITUDE = 0.0208f;
    public static final float MSEC_TO_METER_LATITUDE = 0.03087f;
    public static final String LATITUDE_INDICATOR_NORTH = "N";
    public static final String LATITUDE_INDICATOR_SOUTH = "S";
    public static final String LONGITUDE_INDICATOR_EAST = "E";
    public static final String LONGITUDE_INDICATOR_WEST = "W";
    public static final String WITHOUT_DIFFERENTIAL_GPS = "1";
    public static final String WITH_DIFFERENTIAL_GPS = "2";
    private static final AngleParser angleParser = new UnversalAngleParser();
    private static final AngleFormat angleFormat = new PatternAngleFormat();
    private final String DATA_INVALID = "V";
    private final String DATA_VALID = "A";
    private final String DEGREE_SIGN = "\u00b0";
    private String latitudeIndicator = "";
    private String longitudeIndicator = "";
    private char[] aGGA;
    private char[] aRMC;
    private boolean differentialGPSused = false;
    private boolean trusted = true;
    private boolean valid = false;
    private float altitude = 0.0f;
    private float course = 0.0f;
    private double latitudeArcSecond = 0.0;
    private double longitudeArcSecond = 0.0;
    private float speed = 0.0f;
    private float tolerance = 0.0f;
    private int latitudeArcDegree = 0;
    private int latitudeArcMinute = 0;
    private int latitudeMSec = 0;
    private int longitudeArcDegree = 0;
    private int longitudeArcMinute = 0;
    private int longitudeMSec = 0;
    private Integer magneticVariationMsec;
    private String fixModeIndicator;
    private String rmcChecksum;
    private String ggaChecksum;
    private int numberOfSatellites = 0;
    private long timestamp = 0L;
    private long unitId = 0L;
    private boolean fullFeaturedData = true;
    private boolean parseProblem;
    private static final double METERS_PER_LATITUDE = 0.03087;
    private static final double EARTH_RADIUS_METER = 6378388.0;

    public boolean isParseProblem() {
        return this.parseProblem;
    }

    public GPSPosition(int longMSec, int latMSec) {
        this(longMSec, latMSec, true);
    }

    public GPSPosition(int longMSec, int latMSec, boolean isTrusted) {
        this(longMSec, latMSec, true, 0L);
    }

    public GPSPosition(int longMSec, int latMSec, boolean isTrusted, long uid) {
        this.longitudeMSec = longMSec;
        this.latitudeMSec = latMSec;
        this.trusted = isTrusted;
        this.unitId = uid;
        this.computeArcValues();
        this.fullFeaturedData = false;
    }

    public GPSPosition(String rmc, String gga) {
        this(rmc, gga, true);
    }

    public GPSPosition(String rmc, String gga, boolean isTrusted) {
        this(rmc, gga, isTrusted, 0L);
    }

    public GPSPosition(String rmc, String gga, boolean isTrusted, long uid) {
        this.trusted = isTrusted;
        this.unitId = uid;
        this.fullFeaturedData = true;
        if (rmc == null) {
            rmc = "";
        }
        if (gga == null) {
            gga = "";
        }
        this.aRMC = rmc.toCharArray();
        this.aGGA = gga.toCharArray();
        if (this.aRMC.length > 0) {
            try {
                this.parseRMC();
            }
            catch (Exception e) {
                log.error((Object)("Error while parsing RMC :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
                this.parseProblem = true;
            }
        } else {
            log.debug((Object)("RMC not available" + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
        }
        if (this.aGGA.length > 0) {
            try {
                this.parseGGA();
            }
            catch (Exception e) {
                log.error((Object)("Error while parsing GGA :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
                this.parseProblem = true;
            }
        } else {
            log.debug((Object)("GGA not available" + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
        }
        if (this.aRMC.length > 0) {
            try {
                this.computeMSecValues();
            }
            catch (Exception e) {
                log.error((Object)("Error while compute values for milli arc seconds :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
                this.parseProblem = true;
            }
        }
    }

    public GPSPosition(int longArcDegree, int longArcMinute, float longArcSecond, String longIndicator, int latArcDegree, int latArcMinute, float latArcSecond, String latIndicator) {
        this.longitudeArcDegree = longArcDegree;
        this.longitudeArcMinute = longArcMinute;
        this.longitudeArcSecond = longArcSecond;
        this.longitudeIndicator = longIndicator;
        this.latitudeArcDegree = latArcDegree;
        this.latitudeArcMinute = latArcMinute;
        this.latitudeArcSecond = latArcSecond;
        this.latitudeIndicator = latIndicator;
        try {
            this.computeMSecValues();
        }
        catch (Exception e) {
            log.error((Object)("Error while compute values for milli arc seconds :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
        }
    }

    public static String createNMEArecord(String type, Map<String, String> parameters) {
        if (type.equalsIgnoreCase("rmc")) {
            return GPSPosition.createRMCrecord(parameters);
        }
        if (type.equalsIgnoreCase("gga")) {
            return GPSPosition.createGGArecord(parameters);
        }
        throw new IllegalArgumentException("unkown record type '" + type + "'");
    }

    protected static String createGGArecord(Map<String, String> parameters) {
        StringBuilder buffer = new StringBuilder("$GPGGA,");
        Date time = new Date(Long.parseLong(parameters.get("time")));
        buffer.append(new SimpleDateFormat("HHmmss.SSS").format(time));
        buffer.append(',');
        int latitudeMsec = 0;
        if (parameters.containsKey("latitude")) {
            latitudeMsec = Integer.parseInt(parameters.get("latitude"));
            int degree = Math.abs(latitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)latitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("0000.0000");
        }
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        int longitudeMsec = 0;
        if (parameters.containsKey("longitude")) {
            longitudeMsec = Integer.parseInt(parameters.get("longitude"));
            int degree = Math.abs(longitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("00");
            } else if (degree < 100) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)longitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("00000.0000");
        }
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(',');
        if (parameters.containsKey("quality")) {
            buffer.append(Integer.parseInt(parameters.get("quality")));
        } else {
            buffer.append("0");
        }
        buffer.append(",");
        if (parameters.containsKey("sats")) {
            int sats = Integer.parseInt(parameters.get("sats"));
            if (sats < 10) {
                buffer.append("0");
            }
            buffer.append(sats);
        } else {
            buffer.append("00");
        }
        buffer.append(",");
        if (parameters.containsKey("hdop")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("hdop"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("altitude")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("altitude"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("altitudeUnit")) {
            buffer.append(parameters.get("altitudeUnit"));
        } else {
            buffer.append("M");
        }
        buffer.append(',');
        if (parameters.containsKey("geoidalSeperation")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("geoidalSeperation"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("seperationUnit")) {
            buffer.append(parameters.get("seperationUnit"));
        } else {
            buffer.append("M");
        }
        buffer.append(',');
        if (parameters.containsKey("dgpsAge")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("dgpsAge"))));
        }
        buffer.append(',');
        if (parameters.containsKey("dgpsRef")) {
            buffer.append(parameters.get("dgpsRef"));
        } else {
            buffer.append("0000");
        }
        buffer.append("*00");
        return buffer.toString();
    }

    protected static String createRMCrecord(Map<String, String> parameters) {
        StringBuilder buffer = new StringBuilder("$GPRMC,");
        Date time = new Date(Long.parseLong(parameters.get("time")));
        buffer.append(new SimpleDateFormat("HHmmss.SSS").format(time));
        buffer.append(',');
        if (parameters.containsKey("status")) {
            String status = parameters.get("status");
            if (status.length() != 1) {
                throw new IllegalArgumentException("parameter status must have a length of 1");
            }
            buffer.append(status);
        } else {
            buffer.append('A');
        }
        buffer.append(',');
        int latitudeMsec = 0;
        if (parameters.containsKey("latitude")) {
            latitudeMsec = Integer.parseInt(parameters.get("latitude"));
            int degree = Math.abs(latitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)latitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("0000.0000");
        }
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        int longitudeMsec = 0;
        if (parameters.containsKey("longitude")) {
            longitudeMsec = Integer.parseInt(parameters.get("longitude"));
            int degree = Math.abs(longitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("00");
            } else if (degree < 100) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)longitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("00000.0000");
        }
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(',');
        if (parameters.containsKey("speed")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            numberFormat.setGroupingUsed(false);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("speed"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("trackMadeGood")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("trackMadeGood"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        buffer.append(new SimpleDateFormat("ddMMyy").format(time));
        buffer.append(',');
        float magVar = 0.0f;
        if (parameters.containsKey("magneticVariation")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("magneticVariation"))));
        }
        buffer.append(',');
        if (parameters.containsKey("magneticVariation")) {
            if ((double)magVar >= 0.0) {
                buffer.append(LONGITUDE_INDICATOR_EAST);
            } else {
                buffer.append(LONGITUDE_INDICATOR_WEST);
            }
        }
        buffer.append(",");
        if (parameters.containsKey("modeIndicator")) {
            String status = parameters.get("modeIndicator");
            if (status.length() != 1) {
                throw new IllegalArgumentException("parameter modeIndicator must have a length of 1");
            }
            buffer.append(status);
        } else {
            buffer.append("A");
        }
        buffer.append('*');
        buffer.append("00");
        return buffer.toString();
    }

    public static String createGGA(int latitudeMsec, int longitudeMsec, String time) {
        StringBuilder buffer = new StringBuilder("$GPGGA,");
        buffer.append(time);
        buffer.append(',');
        PatternAngleFormat gpsFormat = new PatternAngleFormat("ddm");
        buffer.append(gpsFormat.format(Math.abs(latitudeMsec)));
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        gpsFormat.setPattern("dddm");
        buffer.append(gpsFormat.format(Math.abs(longitudeMsec)));
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(",1,10,0.9,256.8,M,48.0,M,,0000*52");
        return buffer.toString();
    }

    public static String createRMC(int latitudeMsec, int longitudeMsec, String speed, String trackMadeGood, String time, String date) {
        StringBuilder buffer = new StringBuilder("$GPRMC,");
        buffer.append(time);
        buffer.append(",A,");
        PatternAngleFormat gpsFormat = new PatternAngleFormat("ddm");
        buffer.append(gpsFormat.format(Math.abs(latitudeMsec)));
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        gpsFormat.setPattern("dddm");
        buffer.append(gpsFormat.format(Math.abs(longitudeMsec)));
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(',');
        buffer.append(speed);
        buffer.append(',');
        buffer.append(trackMadeGood);
        buffer.append(',');
        buffer.append(date);
        buffer.append(",,,A*5F");
        return buffer.toString();
    }

    public static String formatLatitude(int latittude) {
        StringBuilder str = new StringBuilder(angleFormat.format(Math.abs(latittude)));
        str.append(" ");
        if (latittude >= 0) {
            str.append(LATITUDE_INDICATOR_NORTH);
        } else {
            str.append(LATITUDE_INDICATOR_SOUTH);
        }
        return str.toString();
    }

    public static String formatLongitude(int longitude) {
        StringBuilder str = new StringBuilder(angleFormat.format(Math.abs(longitude)));
        str.append(" ");
        if (longitude >= 0) {
            str.append(LONGITUDE_INDICATOR_EAST);
        } else {
            str.append(LONGITUDE_INDICATOR_WEST);
        }
        return str.toString();
    }

    public String getFixModeIndicator() {
        return this.fixModeIndicator;
    }

    public Integer getMagneticVariationMsec() {
        return this.magneticVariationMsec;
    }

    public String getGGAChecksum() {
        return this.ggaChecksum;
    }

    public String getRMCChecksum() {
        return this.rmcChecksum;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public float getCourse() {
        return this.course;
    }

    public int getCourseIntValue() {
        return Math.round(this.course);
    }

    public String getGGA() {
        return new String(this.aGGA);
    }

    public int getLatitudeArcDegree() {
        return this.latitudeArcDegree;
    }

    public int getLatitudeArcMinute() {
        return this.latitudeArcMinute;
    }

    public double getLatitudeArcSecond() {
        return this.latitudeArcSecond;
    }

    public String getLatitudeIndicator() {
        return this.latitudeIndicator;
    }

    public int getLatitudeMSec() {
        return this.latitudeMSec;
    }

    public int getLongitudeArcDegree() {
        return this.longitudeArcDegree;
    }

    public int getLongitudeArcMinute() {
        return this.longitudeArcMinute;
    }

    public double getLongitudeArcSecond() {
        return this.longitudeArcSecond;
    }

    public String getLongitudeIndicator() {
        return this.longitudeIndicator;
    }

    public int getLongitudeMSec() {
        return this.longitudeMSec;
    }

    public int getNumberOfSatellites() {
        return this.numberOfSatellites;
    }

    public String getPositionString() {
        return "" + this.longitudeArcDegree + "\u00b0" + " " + ((double)(0.0f + (float)this.longitudeArcMinute) + this.longitudeArcSecond / 60.0) + "' " + this.longitudeIndicator + ", " + this.latitudeArcDegree + "\u00b0" + " " + ((double)(0.0f + (float)this.latitudeArcMinute) + this.latitudeArcSecond / 60.0) + "' " + this.latitudeIndicator;
    }

    public String getPositionStringLimited() {
        return "" + this.longitudeArcDegree + "\u00b0" + " " + this.longitudeArcMinute + "' " + this.roundScale4(0.0 + this.longitudeArcSecond) + "\" " + this.longitudeIndicator + ", " + this.latitudeArcDegree + "\u00b0" + " " + this.latitudeArcMinute + "' " + this.roundScale4(0.0 + this.latitudeArcSecond) + "\" " + this.latitudeIndicator;
    }

    private double roundScale4(double d) {
        return Math.rint(d * 10000.0) / 10000.0;
    }

    public String getRMC() {
        return new String(this.aRMC);
    }

    public float getSpeedKmh() {
        return this.speed * 1.852f;
    }

    public int getSpeedKmhIntValue() {
        return Math.round(this.getSpeedKmh());
    }

    public float getSpeedMph() {
        return this.speed * 1.151f;
    }

    public int getSpeedMphIntValue() {
        return Math.round(this.getSpeedMph());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString() {
        return DateUtil.getDatestring4Timestamp(this.timestamp);
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public boolean isDifferentialGPSused() {
        return this.differentialGPSused;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isFullFeaturedData() {
        return this.fullFeaturedData;
    }

    public static GPSPosition parse(String latitude, String longitude) {
        int latitudeMS = angleParser.parseIntoMS(latitude);
        int longitudeMS = angleParser.parseIntoMS(longitude);
        int longitudeDegree = longitudeMS / 3600 / 1000;
        int longitudeMinute = (longitudeMS - longitudeDegree * 3600 * 1000) / 60 / 1000;
        float longitudeSecond = (float)(longitudeMS - longitudeDegree * 3600 * 1000 - longitudeMinute * 60 * 1000) / 1000.0f;
        String longitudeIndicator = longitude.indexOf(LONGITUDE_INDICATOR_EAST) > -1 ? LONGITUDE_INDICATOR_EAST : LONGITUDE_INDICATOR_WEST;
        int latitudeDegree = latitudeMS / 3600 / 1000;
        int latitudeMinute = (latitudeMS - latitudeDegree * 3600 * 1000) / 60 / 1000;
        float latitudeSecond = (float)(latitudeMS - latitudeDegree * 3600 * 1000 - latitudeMinute * 60 * 1000) / 1000.0f;
        String latitudeIndicator = latitude.indexOf(LATITUDE_INDICATOR_NORTH) > -1 ? LATITUDE_INDICATOR_NORTH : LATITUDE_INDICATOR_SOUTH;
        GPSPosition position = new GPSPosition(longitudeDegree, longitudeMinute, longitudeSecond, longitudeIndicator, latitudeDegree, latitudeMinute, latitudeSecond, latitudeIndicator);
        return position;
    }

    public static int parseLatitudeMS(String latitude) {
        int latitudeMS = angleParser.parseIntoMS(latitude);
        if (latitude.indexOf(LATITUDE_INDICATOR_SOUTH) > -1) {
            latitudeMS *= -1;
        }
        return latitudeMS;
    }

    public static int parseLongitudeMS(String longitude) {
        int longitudeMS = angleParser.parseIntoMS(longitude);
        if (longitude.indexOf(LONGITUDE_INDICATOR_WEST) > -1) {
            longitudeMS *= -1;
        }
        return longitudeMS;
    }

    public String getLatitudeToString() {
        StringBuilder str = new StringBuilder(angleFormat.format(Math.abs(this.latitudeMSec)));
        str.append(" ");
        str.append(this.latitudeIndicator);
        return str.toString();
    }

    public String getLongtitudeToString() {
        StringBuilder str = new StringBuilder(angleFormat.format(Math.abs(this.longitudeMSec)));
        str.append(" ");
        str.append(this.longitudeIndicator);
        return str.toString();
    }

    public void debug() {
        String method = "debug(): ";
        log.debug((Object)(method + "** START, unitID=" + this.unitId));
        log.debug((Object)(method + "longitudeMSec = " + this.getLongitudeMSec()));
        log.debug((Object)(method + "latitudeMSec  = " + this.getLatitudeMSec()));
        log.debug((Object)(method + "* from RMC '" + this.getRMC() + "':"));
        log.debug((Object)(method + "timestamp = " + this.getTimestamp()));
        log.debug((Object)(method + "valid = " + this.isValid()));
        log.debug((Object)(method + "latitudeArcDegree  = " + this.getLatitudeArcDegree()));
        log.debug((Object)(method + "latitudeArcMinute  = " + this.getLatitudeArcMinute()));
        log.debug((Object)(method + "latitudeArcSecond  = " + this.getLatitudeArcSecond()));
        log.debug((Object)(method + "latitudeIndicator  = " + this.getLatitudeIndicator()));
        log.debug((Object)(method + "longitudeArcDegree = " + this.getLongitudeArcDegree()));
        log.debug((Object)(method + "longitudeArcMinute = " + this.getLongitudeArcMinute()));
        log.debug((Object)(method + "longitudeArcSecond = " + this.getLongitudeArcSecond()));
        log.debug((Object)(method + "longitudeIndicator = " + this.getLongitudeIndicator()));
        log.debug((Object)(method + "speed = " + this.getSpeedKmh()));
        log.debug((Object)(method + "course = " + this.getCourse()));
        log.debug((Object)(method + "* from GGA '" + this.getGGA() + "':"));
        log.debug((Object)(method + "differentialGPSused = " + this.isDifferentialGPSused()));
        log.debug((Object)(method + "numberOfSatellites = " + this.getNumberOfSatellites()));
        log.debug((Object)(method + "tolerance = " + this.getTolerance()));
        log.debug((Object)(method + "altitude = " + this.getAltitude()));
        log.debug((Object)(method + "isFullFeaturedData = " + this.isFullFeaturedData()));
        log.debug((Object)(method + "this. (String) = " + this.getPositionString()));
        log.debug((Object)(method + "** END"));
    }

    private void computeArcValues() {
        float fl;
        String sMethodName = "computeArcValues()";
        if (this.longitudeMSec < 0) {
            this.longitudeIndicator = LONGITUDE_INDICATOR_WEST;
            fl = this.longitudeMSec * -1;
        } else {
            this.longitudeIndicator = LONGITUDE_INDICATOR_EAST;
            fl = this.longitudeMSec;
        }
        this.longitudeArcDegree = (int)Math.floor(fl /= 3600000.0f);
        fl -= (float)this.longitudeArcDegree;
        this.longitudeArcMinute = (int)Math.floor(fl *= 60.0f);
        this.longitudeArcSecond = (float)(Math.rint((double)((fl -= (float)this.longitudeArcMinute) * 60.0f) * 100.0) / 100.0);
        if (this.latitudeMSec < 0) {
            this.latitudeIndicator = LATITUDE_INDICATOR_SOUTH;
            fl = this.latitudeMSec * -1;
        } else {
            this.latitudeIndicator = LATITUDE_INDICATOR_NORTH;
            fl = this.latitudeMSec;
        }
        this.latitudeArcDegree = (int)Math.floor(fl /= 3600000.0f);
        fl -= (float)this.latitudeArcDegree;
        this.latitudeArcMinute = (int)Math.floor(fl *= 60.0f);
        this.latitudeArcSecond = (float)(Math.rint((double)((fl -= (float)this.latitudeArcMinute) * 60.0f) * 100.0) / 100.0);
        double cosinus = Math.cos(Math.toRadians(0.0 + (double)this.latitudeArcDegree));
        MSEC_TO_METER_LONGITUDE = new Double(cosinus).floatValue() * 111325.0f / 3600000.0f;
    }

    private void computeMSecValues() {
        String sMethodName = "computeMSecValues()";
        double sec = (double)(this.longitudeArcDegree * 3600 + this.longitudeArcMinute * 60) + this.longitudeArcSecond;
        this.longitudeMSec = (int)Math.round(sec * 1000.0);
        if (this.longitudeIndicator.equals(LONGITUDE_INDICATOR_WEST)) {
            this.longitudeMSec *= -1;
        }
        sec = (double)(this.latitudeArcDegree * 3600 + this.latitudeArcMinute * 60) + this.latitudeArcSecond;
        this.latitudeMSec = (int)Math.round(sec * 1000.0);
        if (this.latitudeIndicator.equals(LATITUDE_INDICATOR_SOUTH)) {
            this.latitudeMSec *= -1;
        }
        double cosinus = Math.cos(Math.toRadians(0.0 + (double)this.latitudeArcDegree));
        MSEC_TO_METER_LONGITUDE = new Double(cosinus).floatValue() * 111325.0f / 3600000.0f;
    }

    private String getAttribute(char[] rec, int pos) {
        String sMethodName = "getAttribute()";
        String val = "";
        int curPos = 0;
        for (int i = 0; i < rec.length; ++i) {
            if (rec[i] == ',') {
                ++curPos;
            }
            if (curPos != pos) continue;
            for (int e = i + 1; e < rec.length && rec[e] != ',' && rec[e] != '*'; ++e) {
                val = val + rec[e];
            }
            break;
        }
        return val;
    }

    private void parseGGA() {
        String sMethodName = "parseGGA()";
        String tmp = "";
        tmp = this.getAttribute(this.aGGA, 6);
        this.differentialGPSused = tmp.equals(WITH_DIFFERENTIAL_GPS);
        tmp = this.getAttribute(this.aGGA, 7);
        this.numberOfSatellites = tmp.length() < 1 ? 0 : Integer.parseInt(tmp);
        tmp = this.getAttribute(this.aGGA, 8);
        this.tolerance = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
        tmp = this.getAttribute(this.aGGA, 9);
        this.altitude = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
        this.ggaChecksum = this.aGGA[this.aGGA.length - 3] == '*' ? new String(this.aGGA, this.aGGA.length - 2, 2) : null;
    }

    private void parseRMC() {
        String sMethodName = "parseRMC()";
        String tmp = this.getAttribute(this.aRMC, 9);
        if (tmp.length() > 0) {
            try {
                String pattern = "ddMMyy HHmmss";
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                sdf.setTimeZone(gmtTimeZone);
                tmp = tmp + " " + this.getAttribute(this.aRMC, 1);
                Date date = sdf.parse(tmp);
                this.timestamp = date.getTime();
            }
            catch (Exception e) {
                log.error((Object)(sMethodName + ": Error while parsing date and time :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
            }
        } else {
            this.timestamp = 0L;
        }
        this.valid = (tmp = this.getAttribute(this.aRMC, 2)).length() > 0 && tmp.equals(this.DATA_VALID);
        tmp = this.getAttribute(this.aRMC, 3);
        if (tmp.length() > 0) {
            this.latitudeArcDegree = Integer.parseInt(tmp.substring(0, 2));
            this.latitudeArcMinute = Integer.parseInt(tmp.substring(2, tmp.indexOf(".")));
            this.latitudeArcSecond = Float.parseFloat(tmp.substring(tmp.indexOf(".")));
            this.latitudeArcSecond *= 60.0;
        } else {
            this.latitudeArcDegree = 0;
            this.latitudeArcMinute = 0;
            this.latitudeArcSecond = 0.0;
        }
        this.latitudeIndicator = this.getAttribute(this.aRMC, 4);
        tmp = this.getAttribute(this.aRMC, 5);
        if (tmp.length() > 0) {
            this.longitudeArcDegree = Integer.parseInt(tmp.substring(0, 3));
            this.longitudeArcMinute = Integer.parseInt(tmp.substring(3, tmp.indexOf(".")));
            this.longitudeArcSecond = Float.parseFloat(tmp.substring(tmp.indexOf(".")));
            this.longitudeArcSecond *= 60.0;
        } else {
            this.longitudeArcDegree = 0;
            this.longitudeArcMinute = 0;
            this.longitudeArcSecond = 0.0;
        }
        this.longitudeIndicator = this.getAttribute(this.aRMC, 6);
        tmp = this.getAttribute(this.aRMC, 7);
        this.speed = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
        tmp = this.getAttribute(this.aRMC, 8);
        this.course = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
        tmp = this.getAttribute(this.aRMC, 10);
        if (!tmp.isEmpty()) {
            this.magneticVariationMsec = (int)(Float.parseFloat(tmp) * 60.0f * 60.0f * 1000.0f);
            tmp = this.getAttribute(this.aRMC, 11);
            if (LONGITUDE_INDICATOR_WEST.equals(tmp)) {
                GPSPosition gPSPosition = this;
                gPSPosition.magneticVariationMsec = gPSPosition.magneticVariationMsec * -1;
            }
            this.fixModeIndicator = this.getAttribute(this.aRMC, 12);
        } else {
            this.magneticVariationMsec = null;
            tmp = this.getAttribute(this.aRMC, 11);
            this.fixModeIndicator = tmp.isEmpty() ? this.getAttribute(this.aRMC, 12) : tmp;
        }
        this.rmcChecksum = this.aRMC[this.aRMC.length - 3] == '*' ? new String(this.aRMC, this.aRMC.length - 2, 2) : null;
    }

    public static double getDistance(GPSPosition pos1, GPSPosition pos2) {
        if (pos1 == null || pos2 == null) {
            return -1.0;
        }
        int latmsec1 = pos1.getLatitudeMSec();
        int longmsec1 = pos1.getLongitudeMSec();
        int latmsec2 = pos2.getLatitudeMSec();
        int longmsec2 = pos2.getLongitudeMSec();
        return GPSPosition.getDistanceByGreatCircle(latmsec1, longmsec1, latmsec2, longmsec2);
    }

    protected static double getMetersPerLongitude(long latitudeMsec) {
        double degrees = (double)latitudeMsec / 1000.0 / 60.0 / 60.0;
        return Math.cos(degrees * Math.PI / 180.0) * 111325.0 / 3600000.0;
    }

    protected static double getDistanceByPythagoras(int latmsec1, int longmsec1, int latmsec2, int longmsec2) {
        long diffLatitude = latmsec1 - latmsec2;
        long diffLongitude = longmsec1 - longmsec2;
        long avgLatitude = (latmsec1 + latmsec2) / 2;
        double metersPerLongitude = GPSPosition.getMetersPerLongitude(avgLatitude);
        double distanceLatitude = (double)diffLatitude * 0.03087;
        double distanceLongitude = (double)diffLongitude * metersPerLongitude;
        distanceLatitude *= distanceLatitude;
        distanceLongitude *= distanceLongitude;
        double sum = distanceLatitude + distanceLongitude;
        return Math.sqrt(sum);
    }

    private static double getRadFromMsec(int degMsec) {
        double rad = degMsec;
        return Math.PI / 180 * (rad /= 3600000.0);
    }

    protected static double getDistanceByGreatCircle(int latmsec1, int longmsec1, int latmsec2, int longmsec2) {
        double lat1 = GPSPosition.getRadFromMsec(latmsec1);
        double lon1 = GPSPosition.getRadFromMsec(longmsec1);
        double lat2 = GPSPosition.getRadFromMsec(latmsec2);
        double lon2 = GPSPosition.getRadFromMsec(longmsec2);
        return 6378388.0 * Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1));
    }
}

