/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.dependencyInjector;

import de.proveo.util.dependencyInjector.Dependency;
import de.proveo.util.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiDependencyInjector {
    private static final Log log = LogFactory.getLog(JndiDependencyInjector.class);
    private Map<Class<?>, String> dependencyMap = Collections.synchronizedMap(new HashMap());
    private InitialContext context;

    public JndiDependencyInjector() {
        try {
            this.context = new InitialContext();
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }

    public void addCustomMapping(Class<?> type, String jndiName) {
        this.dependencyMap.put(type, jndiName);
    }

    public void inject(Object classInstance) {
        Field[] fields;
        for (Field field : fields = ReflectionUtil.getAllDeclaredFields(classInstance.getClass())) {
            String jndiName;
            if (field.getAnnotation(Dependency.class) == null || (jndiName = this.getJndiName(classInstance, field)) == null) continue;
            try {
                ReflectionUtil.setFieldContent(field, classInstance, this.context.lookup(jndiName));
            }
            catch (Exception e) {
                log.error((Object)"Runs into", (Throwable)e);
                break;
            }
        }
    }

    private String getJndiName(Object classInstance, Field field) {
        Class<?> fieldType = field.getType();
        String jndiName = this.dependencyMap.get(fieldType);
        if (jndiName == null) {
            try {
                Field jndiNameField = fieldType.getField("JNDI_NAME");
                if (jndiNameField.getType() == String.class) {
                    jndiName = (String)ReflectionUtil.getFieldContent(jndiNameField, null);
                    this.dependencyMap.put(field.getType(), jndiName);
                } else {
                    log.error((Object)("Field named \"JNDI_NAME\" in " + fieldType.getName() + " has wrong type (must be String). Dependency injection into " + classInstance.getClass().getName() + " failed."));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error finding field named \"JNDI_NAME\" in " + fieldType.getName() + ". Dependency injection into " + classInstance.getClass().getName() + " failed."));
            }
        }
        return jndiName;
    }
}

