/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.database;

import de.proveo.util.database.DatabaseType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseUtil {
    private static final Log log = LogFactory.getLog(DatabaseUtil.class);

    public static DatabaseType getDatabaseType(Connection connection) {
        DatabaseType databaseType = DatabaseType.Unknown;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String dataBaseProductName = metaData.getDatabaseProductName();
            dataBaseProductName = dataBaseProductName.toLowerCase();
            if (dataBaseProductName.contains("mysql")) {
                databaseType = DatabaseType.MySQL;
            } else if (dataBaseProductName.contains("oracle")) {
                databaseType = DatabaseType.Oracle;
            } else if (dataBaseProductName.contains("microsoft sql server")) {
                databaseType = DatabaseType.MSSQL;
            }
            log.debug((Object)("Database SQL Dialect: " + databaseType.name()));
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        return databaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeNonQuery(Connection connection, String sql) {
        boolean result = true;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            log.error((Object)"executeNonQuery() runs into", (Throwable)e);
            result = false;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long executeCustomQuery(Connection connection, String sql, Long valueOnError) {
        Long result = valueOnError;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                result = resultSet.getLong(1);
            }
            if (resultSet.wasNull()) {
                result = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"executeCountingQuery() runs into", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return result;
    }
}

